package cn.xnatural.xnet;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 接口响应数据结构
 * @param <T>
 */
public class R<T> implements Serializable {
    public static String OK_CODE = "00";
    public static String FAIL_CODE = "ee";
    /**
     * 请求是否成功
     * {@link #OK_CODE}: 正常
     * {@link #FAIL_CODE}: 通用错误
     */
    private String code;
    /**
     * 请求返回的数据
     */
    private T      data;
    /**
     * 当前请求返回描述信息
     */
    private String msg;
    /**
     * 返回处理流水号(即: 请求id)
     */
    private String id;
    /**
     * 标记(调用方的入参, 原样返回)
     */
    private String mark;


    public static <T> R<T> ok() { return new R<T>().setCode(OK_CODE); }


    public static <T> R<T> ok(T data) { return new R<T>().setCode(OK_CODE).setData(data); }


    public static <T> R<T> of(String code, String desc) { return new R<T>().setCode(code).setMsg(desc); }


    public static <T> R<T> fail(String errMsg) { return new R<T>().setCode(FAIL_CODE).setMsg(errMsg); }


    /**
     * 一般用法 ApiResp.ok().attr("aaa", 111).attr("bbb", 222)
     *
     * @param attrName 属性名
     * @param attrValue 属性值
     */
    public R<Map<String, Object>> attr(String attrName, Object attrValue) {
        if (data == null) {
            data = (T) new LinkedHashMap<String, Object>();
        }
        if (!(data instanceof Map)) {
            throw new IllegalArgumentException("data类型必须为Map类型");
        }
        ((Map) data).put(attrName, attrValue);
        return (R<Map<String, Object>>) this;
    }


    public R<Map<String, Object>> attrs(Map<String, Object> attrs) {
        attrs.forEach((s, o) -> attr(s, o));
        return (R<Map<String, Object>>) this;
    }


    public R<T> desc(String desc) {this.msg = desc; return this;}


    @Override
    public String toString() {
        return R.class.getSimpleName() + "@" + Integer.toHexString(hashCode()) + "[code=" + code + ", traceNo=" + id + ", desc=" + msg + ", mark: " + mark + ", data=" + data +"]";
    }


    public String getCode() { return code; }

    public R<T> setCode(String code) {
        this.code = code;
        return this;
    }

    public T getData() { return data; }

    public R<T> setData(T data) {
        this.data = data;
        return this;
    }

    public String getMsg() { return msg; }

    public R<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public String getId() { return id; }

    public R<T> setId(String id) {
        this.id = id;
        return this;
    }

    public String getMark() { return mark; }

    public R<T> setMark(String mark) {
        this.mark = mark;
        return this;
    }
}