package cn.xnatural.xnet;


import com.alibaba.fastjson2.JSON;

import java.io.Serializable;
import java.util.Objects;
import java.util.Set;

/**
 * 集群节点 信息
 */
public class Node implements Serializable {
    /**
     * 节点id, 对应 app.id
     */
    protected String id;
    /**
     * 节点名, 对应 app.name
     */
    protected String name;
    /**
     * <pre>
     * 暴露给的应用名
     * 多个以逗号分割
     * 支持格式:
     *      * : 表示匹配任意应用名
     *      a1: 匹配 a1
     *      *a1: 匹配以 a1结尾的节点名
     *      a1*: 匹配以 a1开头的节点名
     * </pre>
     */
    protected Set<String> exposeTo;
    /**
     * endpoint -> host:port
     */
    protected Hp hp;
    /**
     * 上传数据的时间. app up 时间
     */
    protected Long _uptime;
    /**
     * 是否是当前节点的master
     * master是相对的, 即节点1向节点2注册, 那么节点2就是节点1的master
     * 也就是 节点1中的 节点列表中 节点2 的master值为true
     */
    protected boolean _master;
    /**
     * 要求master主动向当前节点同步节点
     */
    protected boolean syncToMe;


    public boolean isExposeTo(String app) {
        return exposeTo.stream().anyMatch(s -> {
            if ("*".equals(s)) return true;
            if (s.equalsIgnoreCase(app)) return true;
            if (s.startsWith("*") && app.endsWith(s.replace("*", ""))) return true;
            if (s.endsWith("*") && app.startsWith(s.replace("*", ""))) return true;
            return false;
        });
    }


    public Node copyTo(Node other) {
        other.id = id; other.name = name; other._master = _master; other.syncToMe = syncToMe;
        other.hp = hp; other._uptime = _uptime; other.exposeTo = exposeTo;
        return other;
    }


    public Node copyFrom(Node other) {
        id = other.id; name = other.name; _master = other._master; syncToMe = other.syncToMe;
        hp = other.hp; _uptime = other._uptime; exposeTo = other.exposeTo;
        return this;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Node node = (Node) o;
        return id.equals(node.id) && name.equals(node.name) && hp.equals(node.hp) && (Objects.equals(exposeTo, node.exposeTo));
    }


    @Override
    public int hashCode() { return Objects.hash(id, name, hp); }


    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }

    public String getId() {
        return id;
    }

    public Node setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return name;
    }

    public Node setName(String name) {
        this.name = name;
        return this;
    }

    public Hp getHp() {
        return hp;
    }

    public Node setHp(Hp hp) {
        this.hp = hp;
        return this;
    }

    public Long get_uptime() {
        return _uptime;
    }

    public Node set_uptime(Long _uptime) {
        this._uptime = _uptime;
        return this;
    }

    public boolean is_master() {
        return _master;
    }

    public Node set_master(boolean _master) {
        this._master = _master;
        return this;
    }

    public Set<String> getExposeTo() {
        return exposeTo;
    }

    public Node setExposeTo(Set<String> exposeTo) {
        this.exposeTo = exposeTo;
        return this;
    }

    public boolean isSyncToMe() {
        return syncToMe;
    }

    public Node setSyncToMe(boolean syncToMe) {
        this.syncToMe = syncToMe;
        return this;
    }
}
