package cn.xnatural.xnet;

import cn.xnatural.xchain.PathHandler;
import cn.xnatural.xchain.RouteHandler;

import java.util.Arrays;
import java.util.List;
import java.util.Set;

public abstract class HttpHandler extends RouteHandler<HttpContext> {

    public HttpHandler(String path) {
        super("HTTP", path);
    }

    public HttpHandler(String protocol, String path) {
        super(protocol, path);
    }

    public HttpHandler(String path, Set<String> method, Set<String> consume, Set<String> produce) {
        super("HTTP", path, method, consume, produce);
    }

    public HttpHandler(String protocol, String path, Set<String> method, Set<String> consume, Set<String> produce) {
        super(protocol, path, method, consume, produce);
    }


    @Override
    public int compareTo(PathHandler<HttpContext> other) {
        int c = super.compareTo(other);
        if (c == 0 && other instanceof HttpHandler) {
            HttpHandler h = (HttpHandler) other;
            // 排序: GET, POST, PUT, DELETE, OPTION, PATCH, HEAD, TRACE(一般来说方法用的频率)
            List<String> ms = Arrays.asList("GET", "POST", "PUT", "DELETE", "OPTION", "PATCH", "HEAD", "TRACE");
            return h.method.stream().mapToInt(ms::indexOf).sum() - method.stream().mapToInt(ms::indexOf).sum();
        }
        return c;
    }

    @Override
    public int match(HttpContext hCtx) {
        int m = super.match(hCtx);
        if (m == 0) {
            if (hCtx.response.status != null && (415 == hCtx.response.status || 405 == hCtx.response.status)) {
                hCtx.response.status = null; // 重新找到匹配的Handler
            }
        }
        return m;
    }


    @Override
    protected boolean methodMatch(HttpContext ctx) {
        boolean b = super.methodMatch(ctx);
        if (!b) ctx.response.statusIfNotSet(405);
        return b;
    }


    @Override
    protected boolean consumeMatch(HttpContext ctx) {
        boolean b = super.consumeMatch(ctx);
        if (!b) ctx.response.statusIfNotSet(415);
        return b;
    }


    @Override
    protected boolean produceMatch(HttpContext ctx) {
        boolean b = super.produceMatch(ctx);
        if (!b) ctx.response.statusIfNotSet(406);
        return b;
    }
}
