package cn.xnatural.xnet;

import java.io.Serializable;
import java.net.URI;
import java.util.Objects;

/**
 * 节点 endpoint 表示 host:port
 */
public class Hp implements Serializable {
    protected final String host;
    protected final Integer port;
    /**
     * 是否是 ssl
     */
    protected final boolean secure;

    public Hp(String host, Integer port, boolean secure) {
        this.host = host;
        this.port = port;
        this.secure = secure;
    }

    public Hp(String host, Integer port) {
        this(host, port, false);
    }


    /**
     * 解析
     * @param hp 支持的格式有:
     *  <ul>
     *      <li>:port</li>
     *      <li>host:port</li>
     *      <li>https://:port</li>
     *      <li>https://host:port</li>
     *  </ul>
     */
    public static Hp parse(String hp) {
        if (hp == null || hp.isEmpty()) return null;
        if (hp.startsWith("http://:")) {
            return new Hp(null, Integer.valueOf(hp.replace("http://:", "")), false);
        }
        else if (hp.startsWith("https://:")) {
            return new Hp(null, Integer.valueOf(hp.replace("https://:", "")), true);
        } else if (hp.startsWith("http://")) {
            URI uri = URI.create(hp);
            return new Hp(uri.getHost(), uri.getPort(), false);
        } else if (hp.startsWith("https://")) {
            URI uri = URI.create(hp);
            return new Hp(uri.getHost(), uri.getPort(), true);
        }
        String[] arr = hp.split(":");
        return new Hp(arr[0].trim(), arr.length < 2 ? 80 : Integer.valueOf(arr[1].trim()), false);
    }


    public Hp resolved() {
        return host == null || host.isEmpty() ? new Hp(XNet.ipv4(), port, secure) : this;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Hp hp = (Hp) o;
        return Objects.equals(host, hp.host) && Objects.equals(port, hp.port) && Objects.equals(secure, hp.secure);
    }


    @Override
    public int hashCode() {
        return Objects.hash(host, port);
    }


    @Override
    public String toString() { return ((host == null ? "" : host) + ":" + port); }



    public String getHost() {return host;}

    public Integer getPort() {return port;}

    public boolean isSecure() {
        return secure;
    }
}
