package cn.xnatural.xchain;


/**
 * 处理器
 */
@FunctionalInterface
public interface Handler<T extends Context> {

    /**
     * 逻辑处理
     * @param ctx {@link Context}
     * @return true: 继续往下匹配执行, false: 中断匹配执行
     */
    boolean handle(T ctx) throws Throwable;


    /**
     * 去掉 路径 前后 的 /
     * @param path 路径
     */
    static String extract(String path) {
        path = path.split("\\?")[0];
        if (path.endsWith("/") && path.length() > 1) path = path.substring(0, path.length() - 1);
        if (path.startsWith("/")) path = path.substring(1);
        return path;
    }
}

