package cn.xnatural.xchain;

import java.lang.annotation.*;

/**
 * <pre>
 * 请求过虑器(拦截器)
 * 方法返回值
 *  1. void
 *  2. boolean, false: 则中断往下匹配执行
 *  3. 其他忽略
 *  </pre>
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Filter {
    /**
     * <pre>
     * 要匹配的路由前缀
     * 不为空
     * 例: /a/b
     * </pre>
     */
    String[] prefix() default {"/"};

    /**
     * 优先级 越大越先执行
     */
    int order() default 0;

    /**
     * <pre>
     * 支持哪种协议, 用于处理器分组, 不区分大小写
     * </pre>
     */
    String[] protocol() default {};
}
