package cn.xnatural.xchain;

import java.lang.annotation.*;

/**
 * 表明一个路由处理器
 */
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Route {
    /**
     * <pre>
     * 路径
     * 例: /a/b/{c}
     * </pre>
     */
    String[] path();

    /**
     * <pre>
     * 排他执行
     * true: 当前处理器匹配成功后，就不继续往下匹配了
     * false: 当前处理器匹配成功后，可继续往下匹配
     * </pre>
     */
    boolean exclusive() default true;

    /**
     * <pre>
     * 支持哪种协议, 用于处理器分组, 不区分大小写
     * </pre>
     */
    String[] protocol() default {};

    /**
     * get,post,delete
     */
    String[] method() default {};

    /**
     * <pre>
     * 指定请求支持接收的 Content-Type
     * application/json, multipart/form-data, application/x-www-form-urlencoded, text/plain
     * </pre>
     */
    String[] consume() default {};

    /**
     * <pre>
     * 指定响应支持的 Content-Type
     * application/json, multipart/form-data, application/x-www-form-urlencoded, text/plain
     * </pre>
     */
    String[] produce() default {};

    /**
     * 额外属性
     */
    String extra() default "";
}
