package cn.xnatural.xchain;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * 对应 {@link Filter}
 */
public abstract class FilterHandler<T extends Context> extends PathHandler<T> {
    /**
     * 同路由下的 {@link Filter#order()} 的执行顺序
     */
    public final int order;


    /**
     * 创建 {@link FilterHandler}
     * @param path {@link #path}
     */
    public FilterHandler(String path) {
        this(null, path, 0);
    }

    /**
     * 创建 {@link FilterHandler}
     * @param protocol {@link #protocol}
     * @param path {@link #path}
     */
    public FilterHandler(String protocol, String path) {
        this(protocol, path, 0);
    }

    /**
     * 创建 {@link FilterHandler}
     * @param protocol {@link #protocol}
     * @param path {@link #path}
     * @param order {@link #order}
     */
    public FilterHandler(String protocol, String path, int order) {
        super(protocol, path);
        this.order = order;
    }


    @Override
    public int compareTo(PathHandler<T> other) {
        if (other instanceof FilterHandler) {
            int c = doCompare(other);
            return c == 0 ? order - ((FilterHandler<T>) other).order : -c;
        }
        return 1;
    }


    @Override
    protected int pathMatch(List<String> pieces, Map<String, String> pathToken) {
        // 不匹配: 请求路径片 少于 当前handler路径片
        if (pieces.size() < this.pieces.size()) return -1;
        if ("/".equals(path)) return 0; // 匹配所有

        int i = 0;
        for (Iterator<Piece> it = this.pieces.iterator(); it.hasNext(); i++) {
            Piece p = it.next();
            boolean match = p.match(pieces.get(i), pathToken);
            if (!match) {
                if (pathToken != null) pathToken.clear();
                return i+1;
            }
        }
        return 0;
    }

    @Override
    public String toString() {
        return Filter.class.getSimpleName() + "[(" + order + ")" + (path == null || path.isEmpty() ? "" : path) + "]";
    }
}