/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.app.util;

import cn.xnatural.app.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Httper {
    protected static final Logger log = LoggerFactory.getLogger(Httper.class);
    protected static final Map<String, List<SocketHolder>> socketCache = new ConcurrentHashMap<String, List<SocketHolder>>();
    protected static final long checkValidTimeout = Long.getLong("tinyHttpCheckValidTimeout", 30000L);
    protected static final String end = "\r\n";
    protected String urlStr;
    protected String contentType;
    protected String method;
    protected String bodyStr;
    protected Map<String, Param> params;
    protected Map<String, Object> cookies;
    protected final Map<String, String> requestHeader = new LinkedHashMap<String, String>();
    public final Map<String, String> responseHeader = new LinkedHashMap<String, String>();
    protected int connectTimeout = 3000;
    protected int readTimeout = 10000;
    protected Integer respCode;
    protected boolean debug;
    protected int ioExceptionRetryCount = 0;
    protected Charset charset = StandardCharsets.UTF_8;
    protected BiConsumer<Throwable, Httper> exHandler;
    protected Function<Map<String, String>, OutputStream> grafting;
    protected final Set<String> toStringType = new HashSet<String>(Arrays.asList("application/json", "text/plain", "application/javascript", "application/x-javascript", "text/html", "text/css", "text/xml"));
    protected BiFunction<OutputStream, Map<String, String>, ?> resultHandler = (os, headers) -> {
        String _ct = (String)headers.get("content-type");
        if ((_ct == null || _ct.isEmpty()) && os instanceof ByteArrayOutputStream) {
            try {
                return ((ByteArrayOutputStream)os).toString(this.charset.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return Optional.ofNullable(_ct).map(s -> s.split(";")).map(arr -> {
            String charset;
            String ct = arr[0].trim().toLowerCase();
            String string = charset = ((String[])arr).length > 1 ? arr[1].trim().split("=")[1] : this.charset.toString();
            if ((this.toStringType.contains(ct) || this.urlStr.endsWith(".m3u8")) && os instanceof ByteArrayOutputStream) {
                try {
                    return ((ByteArrayOutputStream)os).toString(charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }).orElse(null);
    };
    protected transient long chunkedLen = 0L;
    protected int perSecondKb;
    protected String result = null;
    protected final List<Httper> preReq = new LinkedList<Httper>();

    public Httper(String url) {
        this.urlStr = url;
    }

    public static void close() {
        for (Map.Entry<String, List<SocketHolder>> e : socketCache.entrySet()) {
            for (SocketHolder sh : e.getValue()) {
                sh.close();
            }
        }
    }

    public String get() {
        this.method = "GET";
        return this.execute();
    }

    public Httper fileHandle(Function<String, OutputStream> fileConsumer) {
        if (fileConsumer == null) {
            return this;
        }
        this.grafting = headers -> (OutputStream)fileConsumer.apply(Optional.ofNullable(headers.get("content-disposition")).map(s -> {
            try {
                return s.split("filename=")[1].trim();
            }
            catch (Exception exception) {
                return null;
            }
        }).orElse(null));
        this.resultHandler = (os, headers) -> {
            try {
                os.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return null;
        };
        return this;
    }

    public Httper resultHandle(BiFunction<OutputStream, Map<String, String>, ?> resultHandler) {
        this.resultHandler = resultHandler;
        return this;
    }

    public String post() {
        this.method = "POST";
        return this.execute();
    }

    public String put() {
        this.method = "PUT";
        return this.execute();
    }

    public String delete() {
        this.method = "DELETE";
        return this.execute();
    }

    public String method(String method) {
        this.method = method;
        return this.execute();
    }

    public Httper contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public Httper toStringType(String contentType) {
        this.toStringType.add(contentType);
        return this;
    }

    public Httper jsonBody(String jsonStr) {
        this.bodyStr = jsonStr;
        this.contentType = "application/json";
        return this;
    }

    public Httper textBody(String bodyStr) {
        this.bodyStr = bodyStr;
        this.contentType = "text/plain";
        return this;
    }

    public Httper formBody(String bodyStr) {
        this.bodyStr = bodyStr;
        this.contentType = "application/x-www-form-urlencoded";
        return this;
    }

    public Httper body(String bodyStr) {
        this.bodyStr = bodyStr;
        return this;
    }

    public Httper body(String bodyStr, String contentType) {
        this.bodyStr = bodyStr;
        this.contentType = contentType;
        return this;
    }

    public Httper readTimeout(int timeout) {
        this.readTimeout = timeout;
        return this;
    }

    public Httper connectTimeout(int timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    public Httper debug() {
        return this.debug(true);
    }

    public Httper debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public Httper charset(String charset) {
        this.charset = Charset.forName(charset);
        return this;
    }

    public Httper id(String id) {
        this.header("x-request-id", id);
        return this;
    }

    public Httper param(String name, Object value) {
        if (this.params == null) {
            this.params = new LinkedHashMap<String, Param>();
        }
        this.params.put(name, new Param(value));
        if (value instanceof File) {
            this.contentType = "multipart/form-data";
        }
        return this;
    }

    public Httper param(String name, Object value, String contentType) {
        if (this.params == null) {
            this.params = new LinkedHashMap<String, Param>();
        }
        this.params.put(name, new Param(value, contentType));
        if (value instanceof File) {
            this.contentType = "multipart/form-data";
        }
        return this;
    }

    public Httper fileStream(String name, InputStream is, int length, String filename) {
        if (this.params == null) {
            this.params = new LinkedHashMap<String, Param>();
        }
        this.params.put(name, new Param(new FileStream(is, length, filename)));
        this.contentType = "multipart/form-data";
        return this;
    }

    public Httper perSecondKb(int speed) {
        this.perSecondKb = speed;
        return this;
    }

    public Httper header(String name, String value) {
        this.requestHeader.put(name, value);
        return this;
    }

    public Httper digestAuth(String username, String password) {
        this.preReq.add(new Httper(this.urlStr).resultHandle((os, headers) -> {
            Object r = this.resultHandler.apply((OutputStream)os, (Map<String, String>)headers);
            String hValue = (String)headers.get("www-authenticate");
            String realm = hValue.split("realm=")[1].split(",")[0].trim().replace("\"", "");
            String qop = hValue.split("qop=")[1].split(",")[0].trim().replace("\"", "");
            String nonce = hValue.split("nonce=")[1].split(",")[0].replace("\"", "");
            String opaque = hValue.contains("opaque") ? hValue.split("opaque=")[1].split(",")[0].replace("\"", "") : null;
            String nc = "00000001";
            URI uri = URI.create(this.urlStr);
            String cnonce = UUID.randomUUID().toString().replace("-", "");
            StringBuilder sb = new StringBuilder();
            sb.append("Digest ").append("username=\"").append(username).append("\",realm=\"").append(realm).append("\",qop=").append(qop).append(",nonce=\"").append(nonce).append("\",uri=\"").append(uri.getPath()).append("\",nc=").append(nc).append(",cnonce=\"").append(cnonce).append("\"");
            if (opaque != null && !nonce.isEmpty()) {
                sb.append(",opaque=\"").append(opaque).append("\"");
            }
            String ha1 = Utils.md5Hex((username + ":" + realm + ":" + password).getBytes());
            String ha2 = Utils.md5Hex((this.method.toUpperCase() + ":" + uri.getPath()).getBytes());
            String response = Utils.md5Hex((ha1 + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + ha2).getBytes());
            sb.append(",response=\"").append(response).append("\"");
            this.header("Authorization", sb.toString());
            return r;
        }));
        return this;
    }

    public Httper basicAuth(String username, String password) {
        this.header("Authorization", "Basic " + new String(Base64.getEncoder().encode((username + password).getBytes())));
        return this;
    }

    public Httper cookie(String name, Object value) {
        if (this.cookies == null) {
            this.cookies = new LinkedHashMap<String, Object>(7);
        }
        this.cookies.put(name, value);
        return this;
    }

    public Httper cookies(Map<String, Object> cookies) {
        if (this.cookies == null) {
            this.cookies = new LinkedHashMap<String, Object>(7);
        }
        if (cookies != null) {
            this.cookies.putAll(cookies);
        }
        return this;
    }

    public Httper exHandler(BiConsumer<Throwable, Httper> exHandler) {
        if (this.exHandler == null) {
            this.exHandler = exHandler;
        } else {
            BiConsumer<Throwable, Httper> exist = this.exHandler;
            this.exHandler = (ex, h) -> {
                exist.accept((Throwable)ex, (Httper)h);
                exHandler.accept((Throwable)ex, (Httper)h);
            };
        }
        return this;
    }

    public Map<String, Object> cookies() {
        return this.cookies;
    }

    public Integer getResponseCode() {
        return this.respCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SocketHolder getOrCreate(URI uri) throws Exception {
        SocketHolder holder;
        String proto = uri.toURL().getProtocol();
        boolean secure = "https".equalsIgnoreCase(proto);
        int port = uri.getPort() > 1 ? uri.getPort() : (secure ? 443 : 80);
        String key = proto + "://" + uri.getHost() + ":" + port;
        List holders = socketCache.get(key);
        if (holders == null) {
            Map<String, List<SocketHolder>> map = socketCache;
            synchronized (map) {
                holders = socketCache.computeIfAbsent(key, k -> new CopyOnWriteArrayList());
            }
        }
        long now = System.currentTimeMillis();
        Iterator<SocketHolder> it = holders.iterator();
        while (it.hasNext()) {
            holder = it.next();
            if (!holder._locked.compareAndSet(false, true)) continue;
            if (holder.socket.isClosed() || !holder.socket.isConnected() || !holder.socket.isBound() || holder.socket.isInputShutdown() || holder.socket.isOutputShutdown() || holder.isExpired(now)) {
                holder.release();
                holder.close();
                continue;
            }
            if (now - holder.lastUsed > checkValidTimeout) {
                try {
                    holder.socket.setSoTimeout(10);
                    if (holder.socket.getInputStream().read() == -1) {
                        holder.release();
                        holder.close();
                        continue;
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    // empty catch block
                }
            }
            holder.socket.setSoTimeout(this.readTimeout);
            holder.lastUsed = now;
            while (it.hasNext()) {
                SocketHolder h = it.next();
                if (it.hasNext() || !h.isExpired(now)) continue;
                h.close();
            }
            return holder;
        }
        Socket socket = SocketFactory.getDefault().createSocket();
        socket.setKeepAlive(true);
        socket.setReuseAddress(false);
        socket.setTcpNoDelay(true);
        socket.connect(new InetSocketAddress(uri.getHost(), port), this.connectTimeout);
        if (secure) {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, null, null);
            socket = sc.getSocketFactory().createSocket(socket, uri.getHost(), port, true);
            SSLSocket sso = (SSLSocket)socket;
            sso.startHandshake();
        }
        holder = new SocketHolder(socket, key);
        holders.add(holder);
        socket.setSoTimeout(this.readTimeout);
        log.info("New connection({})({}): {}", new Object[]{holders.size(), proto, socket});
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String execute() {
        if (this.urlStr == null || this.urlStr.isEmpty()) {
            throw new IllegalArgumentException("url\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String boundary = null;
        Exception ex = null;
        SocketHolder holder = null;
        long start = this.debug || log.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        try {
            for (Httper h : this.preReq) {
                h.contentType(this.contentType).method(this.method);
            }
            URI uri = URI.create("GET".equalsIgnoreCase(this.method) ? Httper.buildUrl(this.urlStr, this.params == null ? null : this.params.entrySet().stream().filter(e -> e.getKey() != null && e.getValue() != null && ((Param)e.getValue()).value != null).collect(Collectors.toMap(Map.Entry::getKey, e -> ((Param)e.getValue()).value))) : this.urlStr);
            StringBuilder pre = new StringBuilder();
            pre.append(this.method).append(" ").append(uri.getRawPath()).append(uri.getRawQuery() == null ? "" : "?" + uri.getRawQuery()).append(" HTTP/1.1");
            if (this.contentType == null) {
                this.contentType = "application/x-www-form-urlencoded;charset=" + this.charset;
            } else if (this.contentType.toLowerCase().contains("multipart/form-data")) {
                String id = this.requestHeader.computeIfAbsent("x-request-id", s -> UUID.randomUUID().toString().replace("-", ""));
                boundary = "boundary" + (String)id;
                this.contentType = "multipart/form-data;boundary=" + boundary;
            } else if (!this.contentType.toLowerCase().contains(";charset=")) {
                this.contentType = this.contentType + ";charset=" + this.charset;
            }
            this.requestHeader.putIfAbsent("Accept", "*/*");
            if ("https".equals(uri.getScheme()) && uri.getPort() == 443) {
                this.requestHeader.putIfAbsent("Host", uri.getHost());
            } else {
                this.requestHeader.putIfAbsent("Host", uri.getHost() + (uri.getPort() > 0 ? ":" + uri.getPort() : ""));
            }
            this.requestHeader.putIfAbsent("Connection", "keep-alive");
            this.requestHeader.putIfAbsent("User-Agent", "Tiny");
            this.requestHeader.putIfAbsent("Content-Type", this.contentType);
            if (this.cookies != null) {
                this.requestHeader.putIfAbsent("Cookie", this.cookies.entrySet().stream().map(e -> (String)e.getKey() + "=" + e.getValue()).collect(Collectors.joining(";")));
            }
            for (Map.Entry entry : this.requestHeader.entrySet()) {
                pre.append(end).append((String)entry.getKey()).append(":").append((String)entry.getValue());
            }
            holder = this.getOrCreate(uri);
            OutputStream os = holder.socket.getOutputStream();
            if (this.bodyStr != null && !this.bodyStr.isEmpty()) {
                byte[] byArray = this.bodyStr.getBytes(this.charset);
                pre.append(end).append("Content-Length:").append(byArray.length).append(end).append(end);
                os.write(pre.toString().getBytes(this.charset));
                os.write(byArray);
            } else if (boundary != null && this.params != null && !this.params.isEmpty()) {
                final AtomicLong atomicLong = new AtomicLong();
                LinkedList piece = new LinkedList(){

                    @Override
                    public boolean add(Object o) {
                        if (o instanceof byte[]) {
                            atomicLong.addAndGet(((byte[])o).length);
                        } else if (o instanceof File) {
                            atomicLong.addAndGet(((File)o).length());
                        } else if (o instanceof FileStream) {
                            atomicLong.addAndGet(((FileStream)o).length);
                        }
                        return super.add(o);
                    }
                };
                String twoHyphens = "--";
                Iterator it = this.params.entrySet().stream().sorted((o1, o2) -> {
                    if (((Param)o1.getValue()).value instanceof File && !(((Param)o2.getValue()).value instanceof File)) {
                        return 1;
                    }
                    if (!(((Param)o1.getValue()).value instanceof File) && ((Param)o2.getValue()).value instanceof File) {
                        return -1;
                    }
                    return 0;
                }).iterator();
                while (it.hasNext()) {
                    Map.Entry e3 = (Map.Entry)it.next();
                    StringBuilder sb = new StringBuilder().append(end).append(twoHyphens).append(boundary).append(end);
                    if (((Param)e3.getValue()).value instanceof File) {
                        piece.add(sb.append("Content-Disposition: form-data; name=\"").append((String)e3.getKey()).append("\"; filename=\"").append(((File)((Param)e3.getValue()).value).getName()).append("\"").append(end).append("Content-Type: application/octet-stream").append(end).append(end).toString().getBytes(this.charset));
                        piece.add(((Param)e3.getValue()).value);
                        continue;
                    }
                    if (((Param)e3.getValue()).value instanceof FileStream) {
                        piece.add(sb.append("Content-Disposition: form-data; name=\"").append((String)e3.getKey()).append("\"; filename=\"").append(((FileStream)((Param)e3.getValue()).value).name).append("\"").append(end).append("Content-Type: application/octet-stream").append(end).append(end).toString().getBytes(this.charset));
                        piece.add(((Param)e3.getValue()).value);
                        continue;
                    }
                    piece.add(sb.append("Content-Disposition: form-data; name=\"").append((String)e3.getKey()).append("\"").append(end).append("Content-Type: ").append(((Param)e3.getValue()).contentType == null ? "text/plain" : ((Param)e3.getValue()).contentType).append(end).append(end).append(e3.getValue() == null ? "" : ((Param)e3.getValue()).value).toString().getBytes(this.charset));
                }
                piece.add((end + twoHyphens + boundary + twoHyphens + end + end).getBytes(this.charset));
                pre.append(end).append("Content-Length:").append(atomicLong.get()).append(end).append(end);
                os.write(pre.toString().getBytes(this.charset));
                for (Object o : piece) {
                    if (o instanceof byte[]) {
                        os.write((byte[])o);
                        continue;
                    }
                    if (!(o instanceof File)) continue;
                    FileInputStream is = new FileInputStream((File)o);
                    Throwable throwable = null;
                    try {
                        int l;
                        byte[] bs = new byte[5120];
                        while (-1 != (l = is.read(bs))) {
                            os.write(bs, 0, l);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
            } else if ("POST".equalsIgnoreCase(this.method) && this.params != null && !this.params.isEmpty()) {
                byte[] byArray = this.params.entrySet().stream().filter(e -> ((Param)e.getValue()).value != null).map(e -> (String)e.getKey() + "=" + URLEncoder.encode(((Param)e.getValue()).value.toString())).collect(Collectors.joining("&")).getBytes(this.charset);
                pre.append(end).append("Content-Length:").append(byArray.length).append(end).append(end);
                os.write(pre.toString().getBytes(this.charset));
                os.write(byArray);
            } else {
                os.write(pre.append(end).append("Content-Length:0").append(end).append(end).toString().getBytes(this.charset));
            }
            os.flush();
        }
        catch (Exception e4) {
            if (e4 instanceof IOException && this.ioExceptionRetryCount++ < 1) {
                if (holder != null) {
                    holder.release();
                    holder.close();
                }
                return this.execute();
            }
            ex = e4;
        }
        if (ex == null && holder != null) {
            try {
                this.receive(holder.socket.getInputStream());
            }
            catch (Exception e5) {
                ex = e5;
            }
            finally {
                holder.release();
                if ("close".equalsIgnoreCase(this.responseHeader.get("connection"))) {
                    holder.close();
                } else if (this.respCode == null || this.respCode != 200 || ex != null) {
                    holder.close();
                }
            }
        }
        if (start > 0L) {
            String id = this.requestHeader.get("x-request-id");
            String logMsg = "Send " + (id == null ? "" : "(" + id + ")") + "(" + this.method + ")" + this.urlStr + (this.params == null ? "" : ", params: " + this.params) + (this.bodyStr == null ? "" : ", body: " + this.bodyStr) + ", spend: " + (System.currentTimeMillis() - start) + ", result" + (this.respCode == null ? "" : "(" + this.respCode + ")") + ": " + this.result;
            if (ex == null) {
                log.info(logMsg);
            } else {
                log.error(logMsg, (Throwable)ex);
            }
        }
        if (ex != null) {
            if (this.exHandler == null && !this.debug) {
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException(ex);
            }
            if (this.exHandler != null) {
                this.exHandler.accept(ex, this);
            }
        }
        return this.result;
    }

    protected void receive(InputStream is) throws Exception {
        int bufSize;
        long oneSecondStartReadTime;
        LinkedList<ByteBuffer> datas = new LinkedList<ByteBuffer>();
        AtomicBoolean firstLine = new AtomicBoolean(false);
        AtomicBoolean headerEnd = new AtomicBoolean(false);
        AtomicReference os = new AtomicReference();
        AtomicReference contentLength = new AtomicReference();
        int logPerStep = 0x500000;
        HashSet<Long> logFlags = new HashSet<Long>();
        long contentCount = 0L;
        AtomicBoolean chunked = new AtomicBoolean(false);
        long oneSecondReadCount = 0L;
        long oneSecondReadTotal = this.perSecondKb > 0 ? (long)this.perSecondKb * 1024L : -1L;
        long l = oneSecondStartReadTime = this.perSecondKb > 0 ? System.currentTimeMillis() : -1L;
        int n = contentLength.get() == null ? 81920 : (bufSize = (Long)contentLength.get() >= 81920L ? 81920 : ((Long)contentLength.get()).intValue());
        block0: while (true) {
            long logFlag;
            byte[] bs;
            int len;
            if ((len = is.read(bs = new byte[bufSize])) == -1) {
                throw new EOFException();
            }
            if (len > 0) {
                datas.add(ByteBuffer.wrap(bs, 0, len));
            }
            if (datas.isEmpty() || !firstLine.get() && !this.processLine(datas, line -> {
                line = line.replace("\r", "");
                String[] arr = line.split(" ");
                this.respCode = Integer.valueOf(arr[1]);
                firstLine.set(true);
            })) continue;
            while (!headerEnd.get()) {
                boolean f = this.processLine(datas, line -> {
                    if ("\r".equals(line)) {
                        headerEnd.set(true);
                        contentLength.set(Optional.ofNullable(this.responseHeader.get("content-length")).map(Long::valueOf).orElse(null));
                        chunked.set(Optional.ofNullable(this.responseHeader.get("transfer-encoding")).map("chunked"::equalsIgnoreCase).orElse(false));
                        this.grafting = this.grafting == null ? headers -> new ByteArrayOutputStream(contentLength.get() == null ? 512 : ((Long)contentLength.get()).intValue()) : this.grafting;
                        os.set(this.grafting.apply(this.responseHeader));
                    } else {
                        int index = line.indexOf(":");
                        String hName = line.substring(0, index).toLowerCase();
                        String hValue = line.substring(index + 1).trim();
                        if ("set-cookie".equals(hName)) {
                            this.cookie(hName, hValue.split(";")[0].split("=")[1]);
                            if (this.responseHeader.containsKey(hName)) {
                                hValue = this.responseHeader.get(hValue) + "," + hValue;
                            }
                        }
                        this.responseHeader.put(hName, hValue);
                    }
                });
                if (f) continue;
                continue block0;
            }
            if (chunked.get()) {
                contentCount += (long)len;
                if (this.processChunked(datas, (OutputStream)os.get())) {
                    break;
                }
            } else if ((contentCount += this.decodeContent(datas, (OutputStream)os.get(), (Long)contentLength.get())) >= (Long)contentLength.get()) break;
            if ((logFlag = contentCount / (long)logPerStep) > 0L && !logFlags.contains(logFlag)) {
                logFlags.add(logFlag);
                String id = this.requestHeader.get("x-request-id");
                log.info("{}Http received. {}{}", new Object[]{id == null || id.isEmpty() ? "" : "(" + id + ")", contentLength.get() == null ? "" : contentLength.get() + ", ", contentCount});
            }
            if (this.perSecondKb <= 0 || (oneSecondReadCount += (long)len) < oneSecondReadTotal) continue;
            long now = System.currentTimeMillis();
            long wait = 1000L - (now - oneSecondStartReadTime);
            if (wait > 5L) {
                Thread.sleep(wait);
                oneSecondStartReadTime = now + wait;
            } else {
                oneSecondStartReadTime = now;
            }
            oneSecondReadCount = 0L;
        }
        this.result = Optional.ofNullable(this.resultHandler.apply((OutputStream)os.get(), this.responseHeader)).map(Object::toString).orElse(null);
    }

    protected boolean processLine(List<ByteBuffer> datas, Consumer<String> lineConsumer) {
        if (datas.isEmpty()) {
            return false;
        }
        ByteBuffer bb1 = datas.get(0);
        if (!bb1.hasRemaining()) {
            datas.remove(0);
            return this.processLine(datas, lineConsumer);
        }
        String line = this.readLine(bb1);
        if (line != null) {
            lineConsumer.accept(line);
            return true;
        }
        if (datas.size() > 1) {
            ByteBuffer bb2 = datas.remove(1);
            datas.set(0, ByteBuffer.allocate(bb1.remaining() + bb2.remaining()).put(bb1).put(bb2));
            return this.processLine(datas, lineConsumer);
        }
        return false;
    }

    protected boolean processChunked(List<ByteBuffer> datas, OutputStream os) throws Exception {
        if (datas.isEmpty()) {
            return false;
        }
        if (this.chunkedLen < 1L) {
            if (!this.processLine(datas, line -> {
                if ("\r".equals(line)) {
                    --this.chunkedLen;
                } else {
                    line = line.replace("\r", "");
                    this.chunkedLen = Long.parseLong(line, 16);
                    if (this.chunkedLen == 0L) {
                        --this.chunkedLen;
                    }
                }
            })) {
                return false;
            }
            if (this.chunkedLen == -2L) {
                this.chunkedLen = 0L;
                return true;
            }
            return this.processChunked(datas, os);
        }
        this.chunkedLen -= this.decodeContent(datas, os, this.chunkedLen);
        return this.processChunked(datas, os);
    }

    protected long decodeContent(List<ByteBuffer> datas, OutputStream os, Long limit) throws Exception {
        if (datas.isEmpty()) {
            return 0L;
        }
        String contentEncoding = this.responseHeader.get("content-encoding");
        long len = 0L;
        Iterator<ByteBuffer> it = datas.iterator();
        while (it.hasNext() && (limit == null || limit > 0L)) {
            ByteBuffer data = it.next();
            if (!data.hasRemaining()) {
                it.remove();
                continue;
            }
            byte[] bs = new byte[limit == null ? data.remaining() : (int)Math.min((long)data.remaining(), limit)];
            limit = limit == null ? null : Long.valueOf(limit - (len += (long)bs.length));
            data.get(bs);
            if ("gzip".equalsIgnoreCase(contentEncoding)) {
                GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(bs));
                int l = 0;
                byte[] bb = new byte[512];
                while ((l = ((InputStream)gis).read(bb)) != -1) {
                    os.write(bb, 0, l);
                }
                continue;
            }
            os.write(bs);
        }
        return len;
    }

    protected String readLine(ByteBuffer buf) {
        byte[] lineDelimiter = "\n".getBytes(this.charset);
        int index = this.indexOf(buf, lineDelimiter);
        if (index == -1) {
            return null;
        }
        int readableLength = index - buf.position();
        byte[] bs = new byte[readableLength];
        buf.get(bs);
        for (int i = 0; i < lineDelimiter.length; ++i) {
            buf.get();
        }
        return new String(bs, this.charset);
    }

    protected int indexOf(ByteBuffer buf, byte[] delim) {
        byte[] hb = buf.array();
        int delimIndex = -1;
        int size = buf.limit();
        for (int i = buf.position(); i < size; ++i) {
            boolean match = true;
            for (int j = 0; j < delim.length; ++j) {
                match = match && i + j < size && delim[j] == hb[i + j];
            }
            if (!match) continue;
            delimIndex = i;
            break;
        }
        return delimIndex;
    }

    public static String buildUrl(String urlStr, Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return urlStr;
        }
        String queryStr = params.entrySet().stream().filter(e -> e.getValue() != null).map(e -> (String)e.getKey() + "=" + URLEncoder.encode(e.getValue().toString())).collect(Collectors.joining("&"));
        urlStr = urlStr.endsWith("?") || urlStr.endsWith("&") ? urlStr + queryStr : (urlStr.contains("?") ? urlStr + "&" + queryStr : urlStr + "?" + queryStr);
        return urlStr;
    }

    protected static class FileStream {
        public final InputStream is;
        public final int length;
        public String name;

        public FileStream(InputStream is, int length, String name) {
            if (is == null) {
                throw new RuntimeException("File stream required");
            }
            if (length < 1) {
                throw new RuntimeException("File length incorrect");
            }
            this.is = is;
            this.length = length;
            this.name = name == null ? "" : name.trim();
        }
    }

    protected static class SocketHolder
    implements AutoCloseable {
        final Socket socket;
        final String key;
        final long expire = Long.getLong("tinyHttpConnectionExpire", 1800000L);
        long lastUsed = System.currentTimeMillis();
        final AtomicBoolean _locked = new AtomicBoolean(true);

        public SocketHolder(Socket socket, String key) {
            this.socket = socket;
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this._locked.compareAndSet(false, true)) {
                try {
                    List<SocketHolder> holders = socketCache.get(this.key);
                    if (holders == null) {
                        return;
                    }
                    holders.remove(this);
                    if (holders.isEmpty()) {
                        Map<String, List<SocketHolder>> map = socketCache;
                        synchronized (map) {
                            if (holders.isEmpty()) {
                                socketCache.remove(this.key);
                            }
                        }
                    }
                    this.socket.close();
                }
                catch (IOException e) {
                    log.error("close socket error: " + this.key, (Throwable)e);
                }
            }
        }

        boolean isExpired(long now) {
            return now - this.lastUsed > this.expire;
        }

        void release() {
            this._locked.set(false);
        }
    }

    protected static class Param {
        public final Object value;
        public final String contentType;

        public Param(Object value) {
            this(value, null);
        }

        public Param(Object value, String contentType) {
            this.value = value;
            this.contentType = contentType;
        }

        public String toString() {
            return Objects.toString(this.value, null);
        }
    }
}

