/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.app.util;

import cn.xnatural.app.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.sql.DataSource;

public class DB
implements AutoCloseable {
    protected static final AtomicInteger count = new AtomicInteger();
    public final String name = "DB-" + count.getAndIncrement();
    protected final DataSource ds;
    protected static final ThreadLocal<Connection> txConn = new ThreadLocal();

    public DB(DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("Param dataSource required");
        }
        this.ds = dataSource;
    }

    public DB(Map<String, Object> dsAttr) {
        if (dsAttr == null) {
            throw new IllegalArgumentException("Param dsAttr required");
        }
        this.ds = DB.createDataSource(dsAttr);
    }

    public DB(String jdbcUrl) {
        this(jdbcUrl, null, null, 2, 8);
    }

    public DB(String jdbcUrl, String username, String password) {
        this(jdbcUrl, username, password, 2, 8);
    }

    public DB(String jdbcUrl, Integer minIdle, Integer maxActive) {
        this(jdbcUrl, null, null, minIdle, maxActive);
    }

    public DB(String jdbcUrl, String username, String password, Integer minIdle, Integer maxActive) {
        if (jdbcUrl == null || jdbcUrl.isEmpty()) {
            throw new IllegalArgumentException("Param jdbcUrl required");
        }
        if (minIdle == null || minIdle < 0) {
            throw new IllegalArgumentException("Param minIdle must >= 0");
        }
        if (maxActive == null || maxActive <= 0) {
            throw new IllegalArgumentException("Param maxActive must > 0");
        }
        HashMap<String, Object> dsAttr = new HashMap<String, Object>();
        dsAttr.put("jdbcUrl", jdbcUrl);
        dsAttr.put("username", username);
        dsAttr.put("password", password);
        dsAttr.put("minimumIdle", minIdle);
        dsAttr.put("maximumPoolSize", maxActive);
        this.ds = DB.createDataSource(dsAttr);
    }

    public <T> T withConn(Function<Connection, T> fn) {
        Connection conn = null;
        try {
            conn = txConn.get() == null ? this.ds.getConnection() : txConn.get();
            T t = fn.apply(conn);
            return t;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (txConn.get() == null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    public <T> T trans(Supplier<T> fn) {
        return (T)this.withConn(conn -> {
            try {
                boolean ac = conn.getAutoCommit();
                try {
                    txConn.set((Connection)conn);
                    conn.setAutoCommit(false);
                    Object t = fn.get();
                    conn.commit();
                    Object t2 = t;
                    return t2;
                }
                catch (Exception ex) {
                    conn.rollback();
                    throw ex;
                }
                finally {
                    conn.setAutoCommit(ac);
                    conn.close();
                    txConn.set(null);
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public int execute(String sql, Object ... params) {
        return this.withConn(conn -> {
            try (PreparedStatement pst = conn.prepareStatement(sql);){
                this.fillParam(pst, params);
                Integer n = pst.executeUpdate();
                return n;
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public int call(String sql, Object ... params) {
        return this.withConn(conn -> {
            try (CallableStatement cst = conn.prepareCall(sql);){
                this.fillParam(cst, params);
                Integer n = cst.executeUpdate();
                return n;
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public Object insertWithGeneratedKey(String sql, Object ... params) {
        return this.withConn(conn -> {
            try (PreparedStatement pst = conn.prepareStatement(sql, 1);){
                this.fillParam(pst, params);
                pst.executeUpdate();
                try (ResultSet rs = pst.getGeneratedKeys();){
                    if (!rs.next()) return null;
                    Object object = rs.getObject(1);
                    return object;
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public List<Map<String, Object>> rows(String sql, Object ... params) {
        LinkedList ts = new LinkedList();
        return this.withConn(conn -> {
            try (PreparedStatement pst = conn.prepareStatement(sql);){
                this.fillParam(pst, params);
                try (ResultSet rs = pst.executeQuery();){
                    while (rs.next()) {
                        ResultSetMetaData metadata = rs.getMetaData();
                        LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>(metadata.getColumnCount(), 1.0f);
                        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                            row.put(Utils.hump(metadata.getColumnLabel(i)), rs.getObject(i));
                        }
                        ts.add(row);
                    }
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            return ts;
        });
    }

    public <T> List<T> rows(String sql, Class<T> type, Object ... params) {
        LinkedList ts = new LinkedList();
        return this.withConn(conn -> {
            try (PreparedStatement pst = conn.prepareStatement(sql);){
                this.fillParam(pst, params);
                try (ResultSet rs = pst.executeQuery();){
                    while (rs.next()) {
                        ResultSetMetaData metadata = rs.getMetaData();
                        LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>(metadata.getColumnCount(), 1.0f);
                        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                            row.put(Utils.hump(metadata.getColumnLabel(i)), rs.getObject(i));
                        }
                        ts.add(Map.class.isAssignableFrom(type) ? row : Utils.copier(row, type.newInstance()).build());
                    }
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            return ts;
        });
    }

    public <T> void iterate(String sql, Class<T> type, Function<T, Boolean> fn, Object ... params) {
        boolean isMap = Map.class.isAssignableFrom(type);
        this.withConn(conn -> {
            try (PreparedStatement pst = conn.prepareStatement(sql);){
                this.fillParam(pst, params);
                try (ResultSet rs = pst.executeQuery();){
                    while (rs.next()) {
                        ResultSetMetaData metadata = rs.getMetaData();
                        LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>(metadata.getColumnCount(), 1.0f);
                        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                            String label = metadata.getColumnLabel(i);
                            Object v = rs.getObject(i);
                            if (!isMap) {
                                row.put(label, v);
                            }
                            row.put(Utils.hump(label), v);
                        }
                        if (((Boolean)fn.apply(isMap ? row : Utils.copier(row, type.newInstance()).build())).booleanValue()) continue;
                        break;
                    }
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            return null;
        });
    }

    public Map<String, Object> row(String sql, Object ... params) {
        return this.row(sql, Map.class, params);
    }

    public <T> T row(String sql, Class<T> type, Object ... params) {
        boolean isMap = Map.class.isAssignableFrom(type);
        return (T)this.withConn(conn -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public <T> T single(String sql, Class<T> retType, Object ... params) {
        return (T)this.withConn(conn -> {
            try (PreparedStatement pst = conn.prepareStatement(sql);){
                this.fillParam(pst, params);
                try (ResultSet rs = pst.executeQuery();){
                    if (!rs.next()) return null;
                    Object t = rs.getObject(1, retType);
                    return t;
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    protected void fillParam(PreparedStatement pst, Object ... params) throws SQLException {
        ParameterMetaData metaData = pst.getParameterMetaData();
        if (metaData != null && params != null) {
            for (int i = 0; i < params.length; ++i) {
                Object v = params[i];
                if (v instanceof java.util.Date) {
                    v = new Date(((java.util.Date)v).getTime());
                }
                pst.setObject(i + 1, v);
            }
        }
    }

    @Override
    public void close() {
        try {
            this.ds.getClass().getMethod("close", new Class[0]).invoke((Object)this.ds, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getJdbcUrl() {
        try {
            Class<?> c = this.ds.getClass();
            do {
                for (Field f : c.getDeclaredFields()) {
                    if (!"jdbcUrl".equals(f.getName()) && !"url".equals(f.getName())) continue;
                    f.setAccessible(true);
                    return (String)f.get(this.ds);
                }
            } while ((c = c.getSuperclass()) != null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        return "DB{name='" + this.name + '\'' + "jdbcUrl='" + this.getJdbcUrl() + '\'' + '}';
    }

    public static DataSource createDataSource(Map<String, Object> dsAttr) {
        DataSource ds = null;
        try {
            Properties props = new Properties();
            dsAttr.forEach((k, v) -> {
                if (k.startsWith("hibernate")) {
                    return;
                }
                if ("url".equals(k)) {
                    props.put("jdbcUrl", v);
                } else if ("minIdle".equals(k)) {
                    props.put("minimumIdle", v);
                } else if ("maxActive".equals(k)) {
                    props.put("maximumPoolSize", v);
                } else {
                    props.put(k, v);
                }
            });
            props.putIfAbsent("minimumIdle", (Object)2);
            props.putIfAbsent("maximumPoolSize", (Object)8);
            Class<?> cfgClz = Class.forName("com.zaxxer.hikari.HikariConfig");
            ds = (DataSource)Class.forName("com.zaxxer.hikari.HikariDataSource").getConstructor(cfgClz).newInstance(cfgClz.getConstructor(Properties.class).newInstance(props));
            return ds;
        }
        catch (ClassNotFoundException props) {
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try {
            HashMap<String, Object> props = new HashMap<String, Object>();
            dsAttr.forEach((k, v) -> {
                if (k.startsWith("hibernate")) {
                    return;
                }
                v = Objects.toString(v, "");
                if ("jdbcUrl".equals(k)) {
                    props.put("url", v);
                } else if ("minimumIdle".equals(k)) {
                    props.put("minIdle", v);
                } else if ("maximumPoolSize".equals(k)) {
                    props.put("maxActive", v);
                } else {
                    props.put((String)k, v);
                }
            });
            props.putIfAbsent("minIdle", 2);
            props.putIfAbsent("maxActive", 8);
            if (!props.containsKey("filters")) {
                props.put("filters", "stat");
            }
            if (!props.containsKey("connectionProperties")) {
                props.put("connectionProperties", "druid.stat.logSlowSql=true;druid.stat.slowSqlMillis=5000");
            }
            if (!props.containsKey("druid.timeBetweenEvictionRunsMillis")) {
                props.put("druid.timeBetweenEvictionRunsMillis", "1800000");
            }
            ds = (DataSource)Class.forName("com.alibaba.druid.pool.DruidDataSourceFactory").getMethod("createDataSource", Map.class).invoke(null, props);
            Object v2 = props.get("druid.breakAfterAcquireFailure");
            if (v2 != null) {
                Method m = ds.getClass().getMethod("setBreakAfterAcquireFailure", Boolean.TYPE);
                m.invoke((Object)ds, Boolean.parseBoolean(v2.toString()));
            }
            return ds;
        }
        catch (ClassNotFoundException props) {
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try {
            Properties props = new Properties();
            dsAttr.forEach((k, v) -> {
                if (k.startsWith("hibernate")) {
                    return;
                }
                props.put(k, Objects.toString(v, ""));
            });
            ds = (DataSource)Class.forName("org.apache.commons.dbcp2.BasicDataSourceFactory").getMethod("createDataSource", Properties.class).invoke(null, props);
            return ds;
        }
        catch (ClassNotFoundException props) {
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        throw new RuntimeException("No found DataSource impl class");
    }
}

