/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.app.util;

import java.lang.reflect.InvocationTargetException;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cron {
    private static final Logger log = LoggerFactory.getLogger(Cron.class);
    final String exp;
    final Second second;
    final Minute minute;
    final Hour hour;
    final Day day;
    final Month month;
    final Week week;
    final Year year;
    final Function<Calendar, Boolean> isWorkDay;
    Calendar _last;

    public Cron(String exp) {
        this(exp, cal -> {
            int week = cal.get(7);
            return week >= 2 && week <= 6;
        });
    }

    public Cron(String exp, Function<Calendar, Boolean> isWorkDay) {
        if (exp == null || exp.isEmpty()) {
            throw new IllegalArgumentException("exp isEmpty");
        }
        this.exp = exp;
        String[] parts = exp.trim().split(" ");
        if (parts.length < 3) {
            throw new IllegalArgumentException(exp + " At least 3 segments should be included");
        }
        int i = 0;
        this.second = new Second(this, parts[i++].trim());
        this.minute = new Minute(this, parts[i++].trim());
        this.hour = new Hour(this, parts[i++].trim());
        this.day = new Day(this, parts.length >= 4 ? parts[i++].trim() : null);
        this.month = new Month(this, parts.length >= 5 ? parts[i++].trim() : null);
        this.week = new Week(this, parts.length >= 6 ? parts[i++].trim() : null);
        this.year = new Year(this, parts.length >= 7 ? parts[i++].trim() : null);
        this.isWorkDay = isWorkDay;
    }

    public Date next() {
        return this.next(this._last == null ? new Date() : this._last.getTime());
    }

    public Date next(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        this._last = this.year.next(cal);
        this.year._origins.clear();
        this.month._origins.clear();
        this.week._origins.clear();
        this.day._origins.clear();
        this.hour._origins.clear();
        this.minute._origins.clear();
        this.second._origins.clear();
        return this._last == null ? null : this._last.getTime();
    }

    static class LTRange {
        final LocalTime start;
        final LocalTime end;

        public LTRange(LocalTime start, LocalTime end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return "[" + this.start + "," + this.end + "]";
        }
    }

    static class Range {
        final int start;
        final int end;
        final Integer step;

        public Range(int start, int end, Integer step) {
            this.start = start;
            this.end = end;
            this.step = step;
        }

        public String toString() {
            return "[" + this.start + "," + this.end + (this.step == null ? "" : ", " + this.step) + "]";
        }
    }

    static class Year
    extends Part {
        public Year(Cron cron, String exp) {
            super(cron, exp);
        }

        Function<Calendar, Calendar> pattern_3() {
            final List<Range> ranges = this.ranges(0, 9999);
            if (ranges == null) {
                return null;
            }
            return new Function<Calendar, Calendar>(){

                @Override
                public Calendar apply(Calendar cal) {
                    int cur = cal.get(1);
                    for (Range range : ranges) {
                        if (cur < range.start) {
                            cal.set(1, range.start);
                            cal.set(2, 1);
                            cal.set(5, 1);
                            cal.set(11, 0);
                            cal.set(12, 0);
                            cal.set(13, 0);
                            cal.set(14, 0);
                            return cal;
                        }
                        if (cur > range.end) continue;
                        if (range.step == null) {
                            return cal;
                        }
                        if (_origins.size() == 1 && ((Calendar)_origins.get(0)).compareTo(cal) == 0) {
                            cal.add(1, range.step);
                            if (cal.get(1) > range.end) {
                                return this.apply(cal);
                            }
                        }
                        return cal;
                    }
                    return null;
                }
            };
        }

        @Override
        Calendar next(Calendar cal) {
            super.next(cal);
            cal = (Calendar)this.generate.apply(cal);
            return this.cron.month.next(cal);
        }
    }

    static class Week
    extends Part {
        public Week(Cron cron, String seg) {
            super(cron, seg);
        }

        Function<Calendar, Calendar> pattern_3() {
            final List<Range> ranges = this.ranges(1, 6);
            if (ranges == null) {
                return null;
            }
            final int[] arr1 = new int[]{0, 7, 1, 2, 3, 4, 5, 6};
            final int[] arr2 = new int[]{0, 2, 3, 4, 5, 6, 7, 1};
            return new Function<Calendar, Calendar>(){

                @Override
                public Calendar apply(Calendar cal) {
                    int cur = arr1[cal.get(7)];
                    for (Range range : ranges) {
                        if (cur < range.start) {
                            cal.set(7, arr2[range.start]);
                            cal.set(11, 0);
                            cal.set(12, 0);
                            cal.set(13, 0);
                            cal.set(14, 0);
                            return cal;
                        }
                        if (cur > range.end) continue;
                        if (range.step == null) {
                            return cal;
                        }
                        if (_origins.size() == 1 && ((Calendar)_origins.get(0)).compareTo((Calendar)cron.year._origins.get(0)) == 0) {
                            cal.add(7, range.step);
                            if (arr1[cal.get(7)] > range.end) {
                                return this.apply(cal);
                            }
                        }
                        return cal;
                    }
                    cal.add(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    return this.apply(cal);
                }
            };
        }

        @Override
        Calendar next(Calendar cal) {
            super.next(cal);
            int curMonth = cal.get(2);
            cal = (Calendar)this.generate.apply(cal);
            if (cal.get(2) != curMonth) {
                return this.cron.month.next(cal);
            }
            return this.cron.day.next(cal);
        }
    }

    static class Month
    extends Part {
        public Month(Cron cron, String seg) {
            super(cron, seg);
        }

        Function<Calendar, Calendar> pattern_3() {
            final List<Range> ranges = this.ranges(1, 11);
            if (ranges == null) {
                return null;
            }
            return new Function<Calendar, Calendar>(){

                @Override
                public Calendar apply(Calendar cal) {
                    int cur = cal.get(2);
                    for (Range range : ranges) {
                        if (cur < range.start) {
                            cal.set(2, range.start);
                            cal.set(5, 1);
                            cal.set(11, 0);
                            cal.set(12, 0);
                            cal.set(13, 0);
                            cal.set(14, 0);
                            return cal;
                        }
                        if (cur > range.end) continue;
                        if (range.step == null) {
                            return cal;
                        }
                        if (_origins.size() == 1 && ((Calendar)_origins.get(0)).compareTo((Calendar)cron.year._origins.get(0)) == 0) {
                            cal.add(2, range.step);
                            if (cal.get(2) > range.end) {
                                return this.apply(cal);
                            }
                        }
                        return cal;
                    }
                    cal.add(1, 1);
                    cal.set(2, 0);
                    cal.set(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    return cal;
                }
            };
        }

        @Override
        Calendar next(Calendar cal) {
            super.next(cal);
            int curYear = cal.get(1);
            cal = (Calendar)this.generate.apply(cal);
            if (cal.get(1) != curYear) {
                return this.cron.year.next(cal);
            }
            return this.cron.week.next(cal);
        }
    }

    static class Day
    extends Part {
        public Day(Cron cron, String exp) {
            super(cron, exp);
        }

        Calendar fixed(Calendar cal, List<Integer> fixed) {
            int cur = cal.get(5);
            if (cur < fixed.get(0)) {
                cal.set(5, fixed.get(0));
                return cal;
            }
            if (cur > fixed.get(fixed.size() - 1)) {
                cal.add(2, 1);
                cal.set(5, fixed.get(0));
                return cal;
            }
            for (Integer v : fixed) {
                if (v < cur) continue;
                cal.set(5, v);
                break;
            }
            return cal;
        }

        Function<Calendar, Calendar> pattern_2() {
            Matcher m = Pattern.compile("^(\\d{1,2}|L)((,\\d{1,2})*|,L)$").matcher(this.exp);
            if (!m.find()) {
                return null;
            }
            List fixed = Arrays.stream(this.exp.split(",")).filter(s -> !s.isEmpty()).map(s -> s.equals("L") ? null : Integer.valueOf(Integer.parseInt(s))).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            for (Integer v : fixed) {
                if (v > 31) {
                    throw new IllegalArgumentException("(" + this.cron.exp + ") " + this.getClass().getSimpleName() + " (" + this.exp + ") fixed value > 31 error");
                }
                if (v >= 1) continue;
                throw new IllegalArgumentException("(" + this.cron.exp + ") " + this.getClass().getSimpleName() + " (" + this.exp + ") fixed value < 1 error");
            }
            boolean hasMaxDay = this.exp.contains("L");
            return cal -> {
                if (this._origins.size() == 1 && ((Calendar)this._origins.get(0)).compareTo((Calendar)cal) == 0) {
                    if (hasMaxDay) {
                        ArrayList<Integer> newFixed = new ArrayList<Integer>(fixed);
                        newFixed.add(cal.getActualMaximum(5));
                        return this.fixed((Calendar)cal, (List<Integer>)newFixed);
                    }
                    return this.fixed((Calendar)cal, fixed);
                }
                return cal;
            };
        }

        Function<Calendar, Calendar> pattern_3() {
            final List<Range> ranges = this.ranges(1, 31);
            if (ranges == null) {
                return null;
            }
            return new Function<Calendar, Calendar>(){

                @Override
                public Calendar apply(Calendar cal) {
                    int cur = cal.get(5);
                    for (Range range : ranges) {
                        if (cur < range.start) {
                            if (range.start > cal.getActualMaximum(5)) break;
                            cal.set(5, range.start);
                            cal.set(11, 0);
                            cal.set(12, 0);
                            cal.set(13, 0);
                            cal.set(14, 0);
                            return cal;
                        }
                        if (cur > range.end) continue;
                        if (range.step == null) {
                            return cal;
                        }
                        if (_origins.size() == 1 && ((Calendar)_origins.get(0)).compareTo((Calendar)cron.year._origins.get(0)) == 0) {
                            cal.add(5, range.step);
                            if (cal.get(5) > range.end) {
                                return this.apply(cal);
                            }
                        }
                        return cal;
                    }
                    cal.add(2, 1);
                    cal.set(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    return cal;
                }
            };
        }

        Function<Calendar, Calendar> pattern_5() {
            Matcher m = Pattern.compile("^\\*/(?<step>\\d{1,2})$").matcher(this.exp);
            if (!m.find()) {
                return null;
            }
            int step = Integer.parseInt(m.group("step"));
            if (step < 2) {
                throw new IllegalArgumentException("(" + this.cron.exp + ") " + this.getClass().getSimpleName() + " (" + this.exp + ") step < 2 error");
            }
            return cal -> {
                if (this._origins.size() == 1 && ((Calendar)this._origins.get(0)).compareTo((Calendar)cal) == 0) {
                    cal.add(5, step);
                }
                return cal;
            };
        }

        @Override
        Calendar next(Calendar cal) {
            super.next(cal);
            int curMonth = cal.get(2);
            cal = (Calendar)this.generate.apply(cal);
            if (cal.get(2) != curMonth) {
                return this.cron.month.next(cal);
            }
            return this.cron.hour.next(cal);
        }
    }

    static class Hour
    extends Part {
        public Hour(Cron cron, String exp) {
            super(cron, exp);
        }

        Function<Calendar, Calendar> pattern_3() {
            final List<Range> ranges = this.ranges(0, 23);
            if (ranges == null) {
                return null;
            }
            return new Function<Calendar, Calendar>(){

                @Override
                public Calendar apply(Calendar cal) {
                    int cur = cal.get(11);
                    for (Range range : ranges) {
                        if (cur < range.start) {
                            cal.set(11, range.start);
                            cal.set(12, 0);
                            cal.set(13, 0);
                            cal.set(14, 0);
                            return cal;
                        }
                        if (cur > range.end) continue;
                        if (range.step == null) {
                            return cal;
                        }
                        if (_origins.size() == 1 && ((Calendar)_origins.get(0)).compareTo((Calendar)cron.year._origins.get(0)) == 0) {
                            cal.add(11, range.step);
                            if (cal.get(11) > range.end) {
                                return this.apply(cal);
                            }
                        }
                        return cal;
                    }
                    cal.add(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    return cal;
                }
            };
        }

        Function<Calendar, Calendar> pattern_3_1() {
            Pattern pattern = Pattern.compile("^(?<startHour>\\d{1,2})(:(?<startMinute>\\d{1,2}))?-(?<endHour>\\d{1,2})(:(?<endMinute>\\d{1,2}))?$");
            String[] segs = this.exp.split(",");
            ArrayList<LTRange> ranges = new ArrayList<LTRange>();
            for (String seg : segs) {
                LocalTime endLt;
                Matcher m = pattern.matcher(seg);
                if (!m.find()) {
                    return null;
                }
                String _startMinute = m.group("startMinute");
                String _endMinute = m.group("endMinute");
                LocalTime startLt = LocalTime.of(Integer.parseInt(m.group("startHour")), _startMinute == null ? 0 : Integer.parseInt(_startMinute));
                if (startLt.isAfter(endLt = LocalTime.of(Integer.parseInt(m.group("endHour")), _endMinute == null ? 0 : Integer.parseInt(_endMinute)))) {
                    ranges.add(0, new LTRange(LocalTime.MIN, endLt));
                    ranges.add(new LTRange(startLt, LocalTime.MAX));
                    continue;
                }
                ranges.add(new LTRange(startLt, endLt));
            }
            int size = ranges.size();
            for (int i = 0; i < size && i + 1 < size; ++i) {
                if (!((LTRange)ranges.get((int)i)).start.isAfter(((LTRange)ranges.get((int)(i + 1))).start)) continue;
                throw new IllegalArgumentException("(" + this.cron.exp + ") " + this.getClass().getSimpleName() + " (" + this.exp + ") order error");
            }
            ranges.trimToSize();
            return cal -> {
                int curHour = cal.get(11);
                int curMinute = cal.get(12);
                LocalTime curLt = LocalTime.of(curHour, curMinute);
                for (LTRange range : ranges) {
                    if (curLt.isBefore(range.start)) {
                        cal.set(11, range.start.getHour());
                        cal.set(12, range.start.getMinute());
                        cal.set(13, range.start.getSecond());
                        cal.set(14, 0);
                    }
                    if (curLt.isAfter(range.end)) continue;
                    return cal;
                }
                cal.add(5, 1);
                cal.set(11, ((LTRange)ranges.get((int)0)).start.getHour());
                cal.set(12, ((LTRange)ranges.get((int)0)).start.getMinute());
                cal.set(13, ((LTRange)ranges.get((int)0)).start.getSecond());
                cal.set(14, 0);
                return cal;
            };
        }

        Function<Calendar, Calendar> pattern_5() {
            Matcher m = Pattern.compile("^\\*/(?<step>\\d{1,2})$").matcher(this.exp);
            if (!m.find()) {
                return null;
            }
            int step = Integer.parseInt(m.group("step"));
            if (step < 2) {
                throw new IllegalArgumentException("(" + this.cron.exp + ") " + this.getClass().getSimpleName() + " (" + this.exp + ") step < 2 error");
            }
            return cal -> {
                if (this._origins.size() == 1 && ((Calendar)this._origins.get(0)).compareTo((Calendar)cal) == 0) {
                    cal.add(11, step);
                }
                return cal;
            };
        }

        @Override
        Calendar next(Calendar cal) {
            super.next(cal);
            int curDay = cal.get(5);
            cal = (Calendar)this.generate.apply(cal);
            if (cal.get(5) != curDay) {
                return this.cron.day.next(cal);
            }
            return this.cron.minute.next(cal);
        }
    }

    static class Minute
    extends Part {
        public Minute(Cron cron, String exp) {
            super(cron, exp);
        }

        Function<Calendar, Calendar> pattern_3() {
            final List<Range> ranges = this.ranges(0, 59);
            if (ranges == null) {
                return null;
            }
            return new Function<Calendar, Calendar>(){

                @Override
                public Calendar apply(Calendar cal) {
                    int cur = cal.get(12);
                    for (Range range : ranges) {
                        if (cur < range.start) {
                            cal.set(12, range.start);
                            cal.set(13, 0);
                            cal.set(14, 0);
                            return cal;
                        }
                        if (cur > range.end) continue;
                        if (range.step == null) {
                            return cal;
                        }
                        if (_origins.size() == 1 && ((Calendar)_origins.get(0)).compareTo((Calendar)cron.year._origins.get(0)) == 0) {
                            cal.add(12, range.step);
                            if (cal.get(12) > range.end) {
                                return this.apply(cal);
                            }
                        }
                        return cal;
                    }
                    cal.add(11, 1);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    return cal;
                }
            };
        }

        Function<Calendar, Calendar> pattern_5() {
            Matcher m = Pattern.compile("^\\*/(?<step>\\d{1,2})$").matcher(this.exp);
            if (!m.find()) {
                return null;
            }
            int step = Integer.parseInt(m.group("step"));
            if (step < 2) {
                throw new IllegalArgumentException("(" + this.cron.exp + ") " + this.getClass().getSimpleName() + " (" + this.exp + ") step < 2 error");
            }
            return cal -> {
                if (this._origins.size() == 1 && ((Calendar)this._origins.get(0)).compareTo((Calendar)cal) == 0) {
                    cal.add(12, step);
                }
                return cal;
            };
        }

        @Override
        Calendar next(Calendar cal) {
            super.next(cal);
            int curHour = cal.get(11);
            cal = (Calendar)this.generate.apply(cal);
            if (cal.get(11) != curHour) {
                return this.cron.hour.next(cal);
            }
            return this.cron.second.next(cal);
        }
    }

    static class Second
    extends Part {
        public Second(Cron cron, String exp) {
            super(cron, exp);
        }

        @Override
        Function<Calendar, Calendar> pattern_1() {
            Matcher m = Pattern.compile("^\\*$").matcher(this.exp);
            if (!m.find()) {
                return null;
            }
            return cal -> {
                if (this._origins.size() == 1 && ((Calendar)this._origins.get(0)).compareTo((Calendar)this.cron.year._origins.get(0)) == 0) {
                    cal.add(13, 1);
                }
                return cal;
            };
        }

        Function<Calendar, Calendar> pattern_3() {
            final List<Range> ranges = this.ranges(0, 59);
            if (ranges == null) {
                return null;
            }
            return new Function<Calendar, Calendar>(){

                @Override
                public Calendar apply(Calendar cal) {
                    int cur = cal.get(13);
                    for (Range range : ranges) {
                        if (cur < range.start) {
                            cal.set(13, range.start);
                            cal.set(14, 0);
                            return cal;
                        }
                        if (cur > range.end) continue;
                        if (_origins.size() == 1 && ((Calendar)_origins.get(0)).compareTo((Calendar)cron.year._origins.get(0)) == 0) {
                            if (range.step == null) continue;
                            cal.add(13, range.step);
                            if (cal.get(13) > range.end) {
                                return this.apply(cal);
                            }
                        }
                        return cal;
                    }
                    cal.add(12, 1);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    return cal;
                }
            };
        }

        Function<Calendar, Calendar> pattern_5() {
            Matcher m = Pattern.compile("^\\*/(?<step>\\d{1,2})$").matcher(this.exp);
            if (!m.find()) {
                return null;
            }
            int step = Integer.parseInt(m.group("step"));
            if (step < 2) {
                throw new IllegalArgumentException("(" + this.cron.exp + ") " + this.getClass().getSimpleName() + " (" + this.exp + ") step < 2 error");
            }
            return cal -> {
                if (this._origins.size() == 1 && ((Calendar)this._origins.get(0)).compareTo((Calendar)cal) == 0) {
                    cal.add(13, step);
                }
                return cal;
            };
        }

        @Override
        Calendar next(Calendar cal) {
            super.next(cal);
            int curMinute = cal.get(12);
            cal = (Calendar)this.generate.apply(cal);
            if (curMinute != cal.get(12)) {
                return this.cron.hour.next(cal);
            }
            return cal;
        }
    }

    static class Part {
        protected final Cron cron;
        protected final String exp;
        protected Function<Calendar, Calendar> generate;
        final List<Calendar> _origins = new ArrayList<Calendar>(7);

        public Part(Cron cron, String exp) {
            this.cron = cron;
            this.exp = exp == null ? null : exp.trim();
            this.parse();
        }

        void parse() {
            String prefix = "pattern_";
            this.generate = Stream.of(this.getClass().getSuperclass().getDeclaredMethods(), this.getClass().getDeclaredMethods()).flatMap(Arrays::stream).filter(m -> m.getName().startsWith(prefix)).filter(m -> Function.class.equals(m.getReturnType())).filter(m -> m.getParameterCount() == 0).sorted(Comparator.comparing(m -> m.getName().replace(prefix, ""))).distinct().map(m -> {
                try {
                    return (Function)m.invoke((Object)this, new Object[0]);
                }
                catch (Exception ex) {
                    if (ex instanceof InvocationTargetException && ex.getCause() instanceof IllegalArgumentException) {
                        throw (IllegalArgumentException)ex.getCause();
                    }
                    if (ex instanceof IllegalArgumentException) {
                        throw (IllegalArgumentException)ex;
                    }
                    throw new IllegalArgumentException("(" + this.cron.exp + ") " + this.getClass().getSimpleName() + " (" + this.exp + ") parse error", ex);
                }
            }).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalArgumentException("(" + this.cron.exp + ") " + this.getClass().getSimpleName() + " (" + this.exp + ") format error"));
        }

        protected List<Range> ranges(int min, int max) {
            String[] segs = this.exp.split(",");
            ArrayList<Range> ranges = new ArrayList<Range>();
            Pattern p = Pattern.compile("^(?<start>\\d{1,2})(-(?<end>\\d{1,2}))?(/(?<step>\\d{1,2}))?$");
            for (String seg : segs) {
                Integer step;
                Matcher m = p.matcher(seg);
                if (!m.find()) {
                    return null;
                }
                int start = Integer.parseInt(m.group("start"));
                String _end = m.group("end");
                Integer end = _end == null ? null : Integer.valueOf(Integer.parseInt(_end));
                String _step = m.group("step");
                Integer n = step = _step == null ? null : Integer.valueOf(Integer.parseInt(_step));
                if (start < min) {
                    throw new IllegalArgumentException("(" + this.cron.exp + ") " + this.getClass().getSimpleName() + " (" + this.exp + ") start < " + min + " error");
                }
                if (start > max) {
                    throw new IllegalArgumentException("(" + this.cron.exp + ") " + this.getClass().getSimpleName() + " (" + this.exp + ") start > " + max + " error");
                }
                if (end != null && end > max) {
                    throw new IllegalArgumentException("(" + this.cron.exp + ") " + this.getClass().getSimpleName() + " (" + this.exp + ") end > " + max + " error");
                }
                if (end == null && step == null) {
                    ranges.add(new Range(start, start, null));
                    continue;
                }
                if (end == null && step != null) {
                    for (int i = start; i <= max; i += step.intValue()) {
                        ranges.add(new Range(i, i, null));
                    }
                    continue;
                }
                if (start > end) {
                    ranges.add(0, new Range(min, end, step));
                    ranges.add(new Range(start, max, step));
                    continue;
                }
                ranges.add(new Range(start, end, step));
            }
            int size = ranges.size();
            for (int i = 0; i < size && i + 1 < size; ++i) {
                if (ranges.get((int)i).end <= ranges.get((int)(i + 1)).start) continue;
                throw new IllegalArgumentException("(" + this.cron.exp + ") " + this.getClass().getSimpleName() + " (" + this.exp + ") order error");
            }
            ranges.trimToSize();
            return ranges;
        }

        Function<Calendar, Calendar> pattern_1() {
            if (this.exp == null || this.exp.isEmpty()) {
                return cal -> cal;
            }
            Matcher m = Pattern.compile("^[?*]$").matcher(this.exp);
            if (!m.find()) {
                return null;
            }
            return cal -> cal;
        }

        Calendar next(Calendar cal) {
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(cal.getTimeInMillis());
            this._origins.add(c);
            return cal;
        }
    }
}

