/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.app;

import cn.xnatural.app.util.Copier;
import cn.xnatural.app.util.Httper;
import cn.xnatural.app.util.Tailer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.JarURLConnection;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    protected static final Logger log = LoggerFactory.getLogger(Utils.class);
    public static final char[] CS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    public static final Pattern PLACEHOOLDE_RPATTERN = Pattern.compile("\\$\\{(.+?)\\}");

    public static String pid() {
        return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase(Locale.UK).trim().startsWith("linux");
    }

    public static File baseDir(String child) {
        File p = new File(System.getProperty("user.dir"));
        if (child != null) {
            return new File(p, child);
        }
        return p;
    }

    public static String ipv4() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface current = en.nextElement();
                if (!current.isUp() || current.isLoopback() || current.isVirtual()) continue;
                Enumeration<InetAddress> addresses = current.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (addr.isLoopbackAddress() || !(addr instanceof Inet4Address)) continue;
                    return addr.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static byte[] sha1(byte[] bs) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(bs);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String md5Hex(byte[] bs) {
        try {
            byte[] secretBytes = MessageDigest.getInstance("md5").digest(bs);
            String md5code = new BigInteger(1, secretBytes).toString(16);
            for (int i = 0; i < 32 - md5code.length(); ++i) {
                md5code = "0" + md5code;
            }
            return md5code;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String nanoId() {
        return Utils.nanoId(21, CS);
    }

    public static String nanoId(int len) {
        return Utils.nanoId(len, CS);
    }

    public static String nanoId(int len, char[] CS) {
        if (len < 1) {
            throw new IllegalArgumentException("Param len must >= 1");
        }
        if (CS == null || CS.length < 1) {
            throw new IllegalArgumentException("Param CS required");
        }
        SecureRandom SR = new SecureRandom();
        int mask = (2 << (int)Math.floor(Math.log(CS.length - 1) / Math.log(2.0))) - 1;
        int step = (int)Math.ceil(1.6 * (double)mask * (double)len / (double)CS.length);
        StringBuilder sb = new StringBuilder();
        block0: while (true) {
            byte[] bytes = new byte[step];
            SR.nextBytes(bytes);
            int i = 0;
            while (true) {
                if (i >= step) continue block0;
                int idx = bytes[i] & mask;
                if (idx < CS.length) {
                    sb.append(CS[idx]);
                    if (sb.length() == len) {
                        return sb.toString();
                    }
                }
                ++i;
            }
            break;
        }
    }

    public static <T> T to(Object v, Class<T> type) {
        if (type == null) {
            return (T)v;
        }
        if (v == null) {
            if (Boolean.TYPE.equals(type)) {
                return (T)Boolean.FALSE;
            }
            if (Short.TYPE.equals(type)) {
                return (T)Short.valueOf("0");
            }
            if (Byte.TYPE.equals(type)) {
                return (T)Byte.valueOf("0");
            }
            if (Integer.TYPE.equals(type)) {
                return (T)Integer.valueOf(0);
            }
            if (Long.TYPE.equals(type)) {
                return (T)Long.valueOf(0L);
            }
            if (Double.TYPE.equals(type)) {
                return (T)Double.valueOf(0.0);
            }
            if (Float.TYPE.equals(type)) {
                return (T)Float.valueOf(0.0f);
            }
            if (Character.TYPE.equals(type)) {
                return (T)Character.valueOf('\u0000');
            }
            return null;
        }
        if (type.isAssignableFrom(v.getClass())) {
            return (T)v;
        }
        if (String.class.equals(type)) {
            if (v instanceof InputStream || v instanceof File) {
                StringBuilder sb = new StringBuilder();
                try (InputStreamReader rd = new InputStreamReader(v instanceof File ? Files.newInputStream(((File)v).toPath(), new OpenOption[0]) : (InputStream)v);){
                    char[] bs;
                    int len;
                    while ((len = rd.read(bs = new char[3069])) != -1) {
                        sb.append(bs, 0, len);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return (T)sb.toString();
            }
            if (v instanceof Throwable) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ((Throwable)v).printStackTrace(pw);
                return (T)sw.toString();
            }
            return (T)v.toString();
        }
        if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            return (T)Boolean.valueOf(v.toString());
        }
        if (Short.class.equals(type) || Short.TYPE.equals(type)) {
            return (T)Short.valueOf(v.toString());
        }
        if (Byte.class.equals(type) || Byte.TYPE.equals(type)) {
            return (T)Byte.valueOf(v.toString());
        }
        if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
            return (T)Integer.valueOf(v.toString());
        }
        if (BigInteger.class.equals(type)) {
            return (T)new BigInteger(v.toString());
        }
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            return (T)Long.valueOf(v.toString());
        }
        if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            return (T)Double.valueOf(v.toString());
        }
        if (Float.class.equals(type) || Float.TYPE.equals(type)) {
            return (T)Float.valueOf(v.toString());
        }
        if (BigDecimal.class.equals(type)) {
            return (T)new BigDecimal(v.toString());
        }
        if (AtomicInteger.class.equals(type)) {
            return (T)new AtomicInteger(Integer.valueOf(v.toString()));
        }
        if (AtomicLong.class.equals(type)) {
            return (T)new AtomicLong(Long.valueOf(v.toString()));
        }
        if (LongAdder.class.equals(type)) {
            LongAdder la = new LongAdder();
            la.add(Long.valueOf(v.toString()));
            return (T)la;
        }
        if (URI.class.equals(type)) {
            return (T)URI.create(v.toString());
        }
        if (Duration.class.equals(type)) {
            String s = v.toString().toLowerCase();
            if (s.isEmpty()) {
                return (T)Duration.ofMillis(0L);
            }
            if (s.endsWith("s")) {
                return (T)Duration.ofSeconds(Long.parseLong(s.replace("s", "")));
            }
            if (s.endsWith("m")) {
                return (T)Duration.ofMinutes(Long.parseLong(s.replace("m", "")));
            }
            if (s.endsWith("h")) {
                return (T)Duration.ofHours(Long.parseLong(s.replace("h", "")));
            }
            if (s.endsWith("d")) {
                return (T)Duration.ofDays(Long.parseLong(s.replace("d", "")));
            }
            return (T)Duration.ofMillis(Long.parseLong(s.replace("ms", "")));
        }
        if (type.isEnum()) {
            return Arrays.stream(type.getEnumConstants()).filter(o -> v.equals(((Enum)o).name())).findFirst().orElse(null);
        }
        if (v instanceof Annotation && type.isAssignableFrom(Map.class)) {
            return (T)new Function<Annotation, Map<String, Object>>(){

                @Override
                public Map<String, Object> apply(Annotation anno) {
                    Method[] ms;
                    HashMap<String, Object> attr = new HashMap<String, Object>();
                    for (Method m : ms = anno.annotationType().getDeclaredMethods()) {
                        try {
                            Map<String, Object> v = m.invoke((Object)anno, new Object[0]);
                            if (v.getClass().isArray() && v.getClass().getComponentType().isAnnotation()) {
                                LinkedList<Map<String, Object>> ls = new LinkedList<Map<String, Object>>();
                                attr.put(m.getName(), ls);
                                for (Annotation a : (Annotation[])v) {
                                    ls.add(this.apply(a));
                                }
                                continue;
                            }
                            attr.put(m.getName(), v instanceof Annotation ? this.apply((Annotation)((Object)v)) : v);
                        }
                        catch (Exception e) {
                            log.warn("", (Throwable)e);
                        }
                    }
                    return attr;
                }
            }.apply((Annotation)v);
        }
        return (T)v;
    }

    public static void iterateMethod(Class<?> clz, Consumer<Method> fn) {
        if (fn == null) {
            return;
        }
        Class<?> c = clz;
        do {
            for (Method m : c.getDeclaredMethods()) {
                fn.accept(m);
            }
        } while ((c = c.getSuperclass()) != null);
    }

    public static void iterateField(Class<?> clz, Consumer<Field> fn) {
        if (fn == null) {
            return;
        }
        Class<?> c = clz;
        do {
            for (Field f : c.getDeclaredFields()) {
                fn.accept(f);
            }
        } while ((c = c.getSuperclass()) != null);
    }

    public static void scan(String pkgName, Consumer<Class<?>> fn) {
        Utils.scan(pkgName, Thread.currentThread().getContextClassLoader(), clz -> {
            fn.accept((Class<?>)clz);
            return true;
        });
    }

    public static void scan(final String pkgName, ClassLoader loader, final Function<Class<?>, Boolean> fn) {
        if (pkgName == null || pkgName.isEmpty()) {
            return;
        }
        if (loader == null) {
            return;
        }
        try {
            Function<File, Boolean> handle = new Function<File, Boolean>(){

                @Override
                public Boolean apply(File f) {
                    if (f.isDirectory()) {
                        File[] fs = f.listFiles();
                        if (fs != null) {
                            for (File ff : fs) {
                                Boolean isContinue = this.apply(ff);
                                if (isContinue.booleanValue()) continue;
                                return false;
                            }
                        }
                    } else if (f.getName().endsWith(".class")) {
                        try {
                            String path = f.getAbsolutePath().replaceAll("\\\\", "/");
                            String className = path.substring(path.lastIndexOf(pkgName.replaceAll("\\.", "/"))).replace(".class", "").replace("/", ".");
                            if (fn != null && !((Boolean)fn.apply(Class.forName(className))).booleanValue()) {
                                return false;
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    return true;
                }
            };
            Enumeration<URL> e = loader.getResources(pkgName.replaceAll("\\.", "/"));
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                if ("file".equals(url.getProtocol())) {
                    File f = new File(url.getFile());
                    try {
                        if (((Boolean)handle.apply(f)).booleanValue()) continue;
                        return;
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                }
                if (!"jar".equals(url.getProtocol())) continue;
                Enumeration<JarEntry> it = ((JarURLConnection)url.openConnection()).getJarFile().entries();
                while (it.hasMoreElements()) {
                    JarEntry je = it.nextElement();
                    if (!je.getName().endsWith(".class")) continue;
                    try {
                        String className = je.getName().replace(".class", "").replace("/", ".");
                        if (fn == null || fn.apply(Class.forName(className)).booleanValue()) continue;
                        return;
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("scan error", (Throwable)e);
        }
    }

    public static Httper http(String url) {
        return new Httper(url);
    }

    public static Tailer tailer() {
        return new Tailer();
    }

    public static <S, T> Copier<S, T> copier(S src, T target) {
        return new Copier<S, T>(src, target);
    }

    public static long ioCopy(InputStream is, OutputStream os, Integer bufSize) throws IOException {
        int len;
        byte[] buf = new byte[bufSize == null || bufSize < 1 ? 5120 : bufSize];
        long count = 0L;
        while (-1 != (len = is.read(buf))) {
            os.write(buf, 0, len);
            count += (long)len;
        }
        return count;
    }

    public static long ioCopy(InputStream is, OutputStream os) throws IOException {
        return Utils.ioCopy(is, os, 4096);
    }

    public static String placeholder(String content, Map<String, String> ctx) {
        if (content == null) {
            return null;
        }
        if (!content.contains("${")) {
            return content;
        }
        Matcher m = PLACEHOOLDE_RPATTERN.matcher(content);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String key = m.group(1);
            m.appendReplacement(sb, ctx.getOrDefault(key, m.group()));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String hump(String input) {
        StringBuilder sb = new StringBuilder();
        boolean nextUpperCase = false;
        for (char c : input.toCharArray()) {
            if (c == '_') {
                nextUpperCase = true;
                continue;
            }
            if (nextUpperCase) {
                sb.append(Character.toUpperCase(c));
                nextUpperCase = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String cmd(String cmd, Duration timeout) throws IOException, InterruptedException {
        timeout = timeout == null ? Duration.ofSeconds(30L) : timeout;
        long ms = timeout.toMillis();
        log.info("Executing command: {}, {}", (Object)cmd, (Object)ms);
        Process p = null;
        File output = null;
        File error = null;
        try {
            String filename = Utils.md5Hex(cmd.getBytes());
            output = new File("/dev/shm/" + filename + ".output");
            if (output.exists()) {
                output.delete();
            }
            output.getParentFile().mkdirs();
            output.createNewFile();
            error = new File("/dev/shm/" + filename + ".error");
            if (error.exists()) {
                error.delete();
            }
            error.createNewFile();
            ProcessBuilder pb = new ProcessBuilder(cmd.split("\\ "));
            p = pb.redirectOutput(output).redirectError(error).start();
            if (!p.waitFor(ms, TimeUnit.MILLISECONDS)) {
                p.destroyForcibly();
                throw new InterruptedException("Subprocess did not terminate within the timeout. " + cmd);
            }
            String string = p.exitValue() == 0 ? new String(Files.readAllBytes(output.toPath())) : new String(Files.readAllBytes(error.toPath()));
            return string;
        }
        finally {
            if (p != null) {
                p.destroyForcibly();
            }
            if (output != null && output.exists()) {
                output.delete();
            }
            if (error != null && error.exists()) {
                error.delete();
            }
        }
    }
}

