/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.app;

import cn.xnatural.app.Bean;
import cn.xnatural.app.Inject;
import cn.xnatural.app.ServerTpl;
import cn.xnatural.app.util.Cron;
import cn.xnatural.enet.event.EL;
import java.time.Duration;
import java.util.Date;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

@Bean
public class Sched
extends ServerTpl
implements AutoCloseable {
    @Inject
    protected ScheduledExecutorService scheduler;
    protected final Queue<ScheduledFuture<?>> futures = new LinkedBlockingQueue();

    @Override
    @EL(name={"sys.stopping"})
    public void close() {
        for (ScheduledFuture scheduledFuture : this.futures) {
            scheduledFuture.cancel(true);
        }
    }

    public Sched cron(String cron, Runnable fn) {
        return this.cron(cron, fn, null);
    }

    public Sched cron(String exp, Runnable fn, Supplier<Boolean> stopCondition) {
        if (exp == null || exp.isEmpty()) {
            throw new IllegalArgumentException("Param exp not empty");
        }
        if (fn == null) {
            throw new IllegalArgumentException("Param fn required");
        }
        Cron cron = new Cron(exp);
        return this.dynRate(() -> stopCondition == null || (Boolean)stopCondition.get() == false ? cron.next() : null, Duration.ofMillis(cron.next().getTime() - new Date().getTime()), fn);
    }

    public ScheduledFuture<?> time(Date time, Runnable fn) {
        if (time == null) {
            throw new IllegalArgumentException("Param time required");
        }
        if (fn == null) {
            throw new IllegalArgumentException("Param fn required");
        }
        return this.after(Duration.ofMillis(time.getTime() - System.currentTimeMillis()), fn);
    }

    @EL(name={"{name}.after"})
    public ScheduledFuture<?> after(Duration duration, Runnable fn) {
        if (duration == null) {
            throw new IllegalArgumentException("Param duration required");
        }
        if (fn == null) {
            throw new IllegalArgumentException("Param fn required");
        }
        ScheduledFuture<ServerTpl> future = this.scheduler.schedule(() -> this.async(fn), duration.toMillis(), TimeUnit.MILLISECONDS);
        this.futures.offer(future);
        this.futures.removeIf(f -> f.isDone() || f.isCancelled());
        return future;
    }

    public Sched fixedDelay(Duration duration, Duration initialDelay, Runnable fn) {
        return this.fixedDelay(duration, initialDelay, fn, () -> false);
    }

    public Sched fixedDelay(final Duration duration, Duration initialDelay, final Runnable fn, final Supplier<Boolean> stopCondition) {
        if (duration == null) {
            throw new IllegalArgumentException("Param duration required");
        }
        if (fn == null) {
            throw new IllegalArgumentException("Param fn required");
        }
        Runnable wrapFn = new Runnable(){

            @Override
            public void run() {
                try {
                    fn.run();
                }
                finally {
                    if (stopCondition == null || !((Boolean)stopCondition.get()).booleanValue()) {
                        Sched.this.after(duration, this);
                    }
                }
            }
        };
        if (initialDelay == null) {
            wrapFn.run();
        } else {
            this.after(initialDelay, wrapFn);
        }
        return this;
    }

    public Sched fixedDelay(Duration duration, Runnable fn) {
        return this.fixedDelay(duration, null, fn);
    }

    public Sched fixedRate(final Duration duration, Duration initialDelay, final Runnable fn, final Supplier<Boolean> stopCondition) {
        if (duration == null) {
            throw new IllegalArgumentException("Param duration required");
        }
        if (fn == null) {
            throw new IllegalArgumentException("Param fn required");
        }
        Runnable wrapFn = new Runnable(){

            @Override
            public void run() {
                try {
                    Sched.this.async(fn);
                }
                finally {
                    if (stopCondition == null || !((Boolean)stopCondition.get()).booleanValue()) {
                        Sched.this.after(duration, this);
                    }
                }
            }
        };
        if (initialDelay == null) {
            wrapFn.run();
        } else {
            this.after(initialDelay, wrapFn);
        }
        return this;
    }

    public Sched fixedRate(Duration duration, Duration initialDelay, Runnable fn) {
        return this.fixedRate(duration, initialDelay, fn, () -> false);
    }

    public Sched fixedRate(Duration duration, Runnable fn) {
        return this.fixedRate(duration, null, fn, () -> false);
    }

    public Sched dynDelay(Supplier<Date> dateSupplier, Runnable fn) {
        return this.dynDelay(dateSupplier, null, fn);
    }

    public Sched dynDelay(final Supplier<Date> dateSupplier, Duration initialDelay, final Runnable fn) {
        if (dateSupplier == null) {
            throw new IllegalArgumentException("Param dateSupplier required");
        }
        if (fn == null) {
            throw new IllegalArgumentException("Param fn required");
        }
        Runnable wrapFn = new Runnable(){

            @Override
            public void run() {
                try {
                    fn.run();
                }
                finally {
                    Date d = (Date)dateSupplier.get();
                    if (d != null) {
                        Sched.this.time(d, this);
                    }
                }
            }
        };
        if (initialDelay == null) {
            wrapFn.run();
        } else {
            this.after(initialDelay, wrapFn);
        }
        return this;
    }

    public Sched dynRate(Supplier<Date> dateSupplier, Runnable fn) {
        return this.dynRate(dateSupplier, null, fn);
    }

    public Sched dynRate(final Supplier<Date> dateSupplier, Duration initialDelay, final Runnable fn) {
        if (dateSupplier == null) {
            throw new IllegalArgumentException("Param dateSupplier required");
        }
        if (fn == null) {
            throw new IllegalArgumentException("Param fn required");
        }
        Runnable wrapFn = new Runnable(){

            @Override
            public void run() {
                try {
                    Sched.this.async(fn);
                }
                finally {
                    Date d = (Date)dateSupplier.get();
                    if (d != null) {
                        Sched.this.time(d, this);
                    }
                }
            }
        };
        if (initialDelay == null) {
            wrapFn.run();
        } else {
            this.after(initialDelay, wrapFn);
        }
        return this;
    }
}

