/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.app.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.sql.DataSource;

public class DB
implements AutoCloseable {
    protected static final AtomicInteger count = new AtomicInteger();
    public final String name = "DB-" + count.getAndIncrement();
    protected volatile DataSource dataSource;
    protected Integer maxRows = 5000;
    protected final Map<String, Object> dsAttr = new HashMap<String, Object>();
    protected static final ThreadLocal<Connection> txConn = new ThreadLocal();

    public DB(DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("Param dataSource required");
        }
        this.dataSource = dataSource;
    }

    public DB(Map<String, Object> dsAttr) {
        if (dsAttr == null) {
            throw new IllegalArgumentException("Param dsAttr required");
        }
        this.dsAttr.putAll(dsAttr);
    }

    public DB(String jdbcUrl) {
        this(jdbcUrl, null, null, 1, 8);
    }

    public DB(String jdbcUrl, String username, String password) {
        this(jdbcUrl, username, password, 1, 8);
    }

    public DB(String jdbcUrl, Integer minIdle, Integer maxActive) {
        this(jdbcUrl, null, null, minIdle, maxActive);
    }

    public DB(String jdbcUrl, String username, String password, Integer minIdle, Integer maxActive) {
        if (jdbcUrl == null || jdbcUrl.isEmpty()) {
            throw new IllegalArgumentException("Param jdbcUrl required");
        }
        if (minIdle == null || minIdle < 0) {
            throw new IllegalArgumentException("Param minIdle must >= 0");
        }
        if (maxActive == null || maxActive <= 0) {
            throw new IllegalArgumentException("Param maxActive must > 0");
        }
        this.dsAttr.put("jdbcUrl", jdbcUrl);
        if (username != null) {
            this.dsAttr.put("username", username);
        }
        if (password != null) {
            this.dsAttr.put("password", password);
        }
        this.dsAttr.put("minimumIdle", minIdle);
        this.dsAttr.put("maximumPoolSize", maxActive);
    }

    public DB dsAttr(String attrName, Object attrValue) {
        if (this.dataSource != null) {
            throw new RuntimeException("dataSource already created");
        }
        this.dsAttr.put(attrName, attrValue);
        return this;
    }

    public DB setMaxRows(int maxRows) {
        if (maxRows < 1) {
            throw new IllegalArgumentException("Param maxRows must > 0");
        }
        this.maxRows = maxRows;
        return this;
    }

    public <T> T withConn(Function<Connection, T> fn) {
        this.init();
        Connection conn = null;
        try {
            conn = txConn.get() == null ? this.dataSource.getConnection() : txConn.get();
            T t = fn.apply(conn);
            return t;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (txConn.get() == null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    public <T> T trans(Supplier<T> fn) {
        return (T)this.withConn(conn -> {
            try {
                boolean ac = conn.getAutoCommit();
                try {
                    txConn.set((Connection)conn);
                    conn.setAutoCommit(false);
                    Object t = fn.get();
                    conn.commit();
                    Object t2 = t;
                    return t2;
                }
                catch (Exception ex) {
                    conn.rollback();
                    throw ex;
                }
                finally {
                    conn.setAutoCommit(ac);
                    conn.close();
                    txConn.set(null);
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public int execute(String sql, Object ... params) {
        return this.withConn(conn -> {
            try (PreparedStatement pst = conn.prepareStatement(sql);){
                this.fillParam(pst, params);
                Integer n = pst.executeUpdate();
                return n;
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public int call(String sql, Object ... params) {
        return this.withConn(conn -> {
            try (CallableStatement cst = conn.prepareCall(sql);){
                this.fillParam(cst, params);
                Integer n = cst.executeUpdate();
                return n;
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public Object insertWithGeneratedKey(String sql, Object ... params) {
        return this.withConn(conn -> {
            try (PreparedStatement pst = conn.prepareStatement(sql, 1);){
                this.fillParam(pst, params);
                pst.executeUpdate();
                try (ResultSet rs = pst.getGeneratedKeys();){
                    if (!rs.next()) return null;
                    Object object = rs.getObject(1);
                    return object;
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public List<Map<String, Object>> rows(String sql, Object ... params) {
        LinkedList result = new LinkedList();
        return this.withConn(conn -> {
            try (PreparedStatement pst = conn.prepareStatement(sql);){
                this.fillParam(pst, params);
                try (ResultSet rs = pst.executeQuery();){
                    while (rs.next()) {
                        ResultSetMetaData metadata = rs.getMetaData();
                        LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>(metadata.getColumnCount(), 1.0f);
                        result.add(row);
                        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                            row.put(metadata.getColumnLabel(i), rs.getObject(i));
                        }
                    }
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            return result;
        });
    }

    public Map<String, Object> row(String sql, Object ... params) {
        LinkedHashMap result = new LinkedHashMap();
        return this.withConn(conn -> {
            try (PreparedStatement pst = conn.prepareStatement(sql);){
                this.fillParam(pst, params);
                try (ResultSet rs = pst.executeQuery();){
                    if (rs.next()) {
                        ResultSetMetaData metadata = rs.getMetaData();
                        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                            result.put(metadata.getColumnLabel(i), rs.getObject(i));
                        }
                    }
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            return result;
        });
    }

    public <T> T single(String sql, Class<T> retType, Object ... params) {
        return (T)this.withConn(conn -> {
            try (PreparedStatement pst = conn.prepareStatement(sql);){
                this.fillParam(pst, params);
                try (ResultSet rs = pst.executeQuery();){
                    if (!rs.next()) return null;
                    Object t = rs.getObject(1, retType);
                    return t;
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    protected void fillParam(PreparedStatement pst, Object ... params) throws SQLException {
        ParameterMetaData metaData = pst.getParameterMetaData();
        if (metaData != null && params != null) {
            for (int i = 0; i < params.length; ++i) {
                Object v = params[i];
                if (v instanceof java.util.Date) {
                    v = new Date(((java.util.Date)v).getTime());
                }
                pst.setObject(i + 1, v);
            }
        }
        pst.setMaxRows(this.maxRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        if (this.dataSource == null) {
            DB dB = this;
            synchronized (dB) {
                if (this.dataSource == null) {
                    this.dataSource = DB.createDataSource(this.dsAttr);
                }
            }
        }
    }

    @Override
    public void close() {
        try {
            this.dataSource.getClass().getMethod("close", new Class[0]).invoke((Object)this.dataSource, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getJdbcUrl() {
        if (this.dataSource == null) {
            this.init();
        }
        try {
            Class<?> c = this.dataSource.getClass();
            do {
                for (Field f : c.getDeclaredFields()) {
                    if (!"jdbcUrl".equals(f.getName()) && !"url".equals(f.getName())) continue;
                    f.setAccessible(true);
                    return (String)f.get(this.dataSource);
                }
            } while ((c = c.getSuperclass()) != null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        return "DB{name='" + this.name + '\'' + "jdbcUrl='" + this.getJdbcUrl() + '\'' + '}';
    }

    public static DataSource createDataSource(Map<String, Object> dsAttr) {
        DataSource ds = null;
        try {
            Properties props = new Properties();
            dsAttr.forEach((k, v) -> {
                if (k.startsWith("hibernate")) {
                    return;
                }
                if ("url".equals(k)) {
                    props.put("jdbcUrl", v);
                } else if ("minIdle".equals(k)) {
                    props.put("minimumIdle", v);
                } else if ("maxActive".equals(k)) {
                    props.put("maximumPoolSize", v);
                } else {
                    props.put(k, v);
                }
            });
            Class<?> cfgClz = Class.forName("com.zaxxer.hikari.HikariConfig");
            ds = (DataSource)Class.forName("com.zaxxer.hikari.HikariDataSource").getConstructor(cfgClz).newInstance(cfgClz.getConstructor(Properties.class).newInstance(props));
            return ds;
        }
        catch (ClassNotFoundException props) {
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try {
            HashMap<String, String> props = new HashMap<String, String>();
            dsAttr.forEach((k, v) -> {
                if (k.startsWith("hibernate")) {
                    return;
                }
                v = Objects.toString(v, "");
                if ("jdbcUrl".equals(k)) {
                    props.put("url", (String)v);
                } else if ("minimumIdle".equals(k)) {
                    props.put("minIdle", (String)v);
                } else if ("maximumPoolSize".equals(k)) {
                    props.put("maxActive", (String)v);
                } else {
                    props.put((String)k, (String)v);
                }
            });
            if (!props.containsKey("filters")) {
                props.put("filters", "stat");
            }
            if (!props.containsKey("connectionProperties")) {
                props.put("connectionProperties", "druid.stat.logSlowSql=true;druid.stat.slowSqlMillis=5000");
            }
            if (!props.containsKey("druid.timeBetweenEvictionRunsMillis")) {
                props.put("druid.timeBetweenEvictionRunsMillis", "1800000");
            }
            ds = (DataSource)Class.forName("com.alibaba.druid.pool.DruidDataSourceFactory").getMethod("createDataSource", Map.class).invoke(null, props);
            Object v2 = props.get("druid.breakAfterAcquireFailure");
            if (v2 != null) {
                Method m = ds.getClass().getMethod("setBreakAfterAcquireFailure", Boolean.TYPE);
                m.invoke((Object)ds, Boolean.parseBoolean(v2.toString()));
            }
            return ds;
        }
        catch (ClassNotFoundException props) {
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try {
            Properties props = new Properties();
            dsAttr.forEach((k, v) -> {
                if (k.startsWith("hibernate")) {
                    return;
                }
                props.put(k, Objects.toString(v, ""));
            });
            ds = (DataSource)Class.forName("org.apache.commons.dbcp2.BasicDataSourceFactory").getMethod("createDataSource", Properties.class).invoke(null, props);
            return ds;
        }
        catch (ClassNotFoundException props) {
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        throw new RuntimeException("No found DataSource impl class");
    }
}

