/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.app;

import java.util.HashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

@FunctionalInterface
public interface Recursion<T> {
    public Recursion<T> apply();

    default public boolean isFinished() {
        return false;
    }

    default public T getResult() {
        if (!this.isFinished()) {
            throw new RuntimeException("\u9012\u5f52\u8fd8\u6ca1\u6709\u7ed3\u675f,\u8c03\u7528\u83b7\u5f97\u7ed3\u679c\u5f02\u5e38!");
        }
        return null;
    }

    default public T invoke() {
        return Stream.iterate(this, Recursion::apply).filter(Recursion::isFinished).findFirst().map(Recursion::getResult).orElse(null);
    }

    public static <T> Recursion<T> call(Recursion<T> nextFrame) {
        return nextFrame;
    }

    public static <T> Recursion<T> done(final T value) {
        return new Recursion<T>(){

            @Override
            public Recursion<T> apply() {
                throw new RuntimeException("\u9012\u5f52\u5df2\u7ecf\u7ed3\u675f,\u975e\u6cd5\u8c03\u7528apply\u65b9\u6cd5");
            }

            @Override
            public boolean isFinished() {
                return true;
            }

            @Override
            public T getResult() {
                return value;
            }
        };
    }

    public static <I, R> R memo(final BiFunction<Function<I, R>, I, R> function, I input) {
        final HashMap cache = new HashMap();
        return new Function<I, R>(){

            @Override
            public R apply(I input) {
                return cache.computeIfAbsent(input, key -> function.apply(this, key));
            }
        }.apply(input);
    }
}

