/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.app;

import cn.xnatural.app.LatchLock;
import cn.xnatural.app.Pause;
import java.time.Duration;
import java.util.Arrays;
import java.util.Deque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Devourer {
    protected static final Logger log = LoggerFactory.getLogger(Devourer.class);
    protected final Executor exec;
    protected final String key;
    protected Integer failMaxKeep = 0;
    protected final LatchLock lock = new LatchLock();
    protected final Deque<Runnable> waiting = new ConcurrentLinkedDeque<Runnable>();
    protected BiConsumer<Throwable, Devourer> errorHandler;
    protected Predicate<Devourer> pauseCondition;
    protected boolean useLast;
    protected Long perSpend;

    public Devourer(String key, Executor exec) {
        this.key = key == null || key.isEmpty() ? Devourer.class.getSimpleName() + "@" + Integer.toHexString(this.hashCode()) : key;
        this.exec = exec == null ? new ThreadPoolExecutor(2, 4, 6L, TimeUnit.HOURS, (BlockingQueue<Runnable>)new LinkedBlockingQueue<Runnable>(100000){

            boolean threshold() {
                int size = super.size();
                if (size <= 1) {
                    return false;
                }
                ThreadPoolExecutor e = (ThreadPoolExecutor)Devourer.this.exec;
                if (Devourer.this.lock.limit <= e.getCorePoolSize()) {
                    return false;
                }
                int ps = e.getPoolSize();
                if (ps >= e.getMaximumPoolSize()) {
                    return false;
                }
                return size >= (int)((double)ps * 0.5);
            }

            @Override
            public boolean offer(Runnable r) {
                return !this.threshold() && super.offer(r);
            }
        }, new ThreadFactory(){
            final AtomicInteger i = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, Devourer.this.key + "-" + this.i.incrementAndGet());
            }
        }) : exec;
    }

    public Devourer(String key) {
        this(key, null);
    }

    public Devourer() {
        this(null, null);
    }

    public Devourer offer(Runnable fn) {
        if (fn == null) {
            return this;
        }
        if (this.useLast) {
            this.waiting.clear();
        }
        this.waiting.offer(fn);
        this.trigger();
        return this;
    }

    protected void trigger() {
        Predicate<Devourer> condition = this.pauseCondition;
        if (condition != null) {
            if (condition.test(this)) {
                return;
            }
            this.pauseCondition = null;
        }
        if (this.waiting.isEmpty()) {
            return;
        }
        if (!this.lock.tryLock()) {
            return;
        }
        this.exec.execute(() -> {
            long start = this.perSpend == null ? 0L : System.currentTimeMillis();
            Runnable task = null;
            try {
                task = this.waiting.poll();
                if (task != null) {
                    task.run();
                }
            }
            catch (Throwable ex) {
                if (task != null && this.failMaxKeep != null && this.failMaxKeep > 0 && this.getWaitingCount() < this.failMaxKeep) {
                    this.waiting.addFirst(task);
                }
                if (this.errorHandler != null) {
                    try {
                        this.errorHandler.accept(ex, this);
                    }
                    catch (Throwable exx) {
                        log.error(this.key + " errorHandler error", exx);
                    }
                } else {
                    log.error(this.key, ex);
                }
            }
            finally {
                long left;
                if (this.perSpend != null && this.perSpend > 0L && (left = this.perSpend - (System.currentTimeMillis() - start)) > 1L) {
                    try {
                        Thread.sleep(left - 1L);
                    }
                    catch (InterruptedException e) {
                        log.error(this.key + " speed sleep error", (Throwable)e);
                    }
                }
                this.lock.release();
                if (!this.waiting.isEmpty()) {
                    this.trigger();
                }
            }
        });
    }

    public Devourer parallel(int parallel) {
        if (parallel < 1) {
            throw new IllegalArgumentException("Param parallel >= 1");
        }
        this.lock.limit(parallel);
        return this;
    }

    public Devourer speed(String speed) {
        if (speed == null) {
            this.perSpend = null;
            return this;
        }
        String[] arr = speed.split("/");
        int limit = Integer.valueOf(arr[0].trim());
        if (limit < 1) {
            throw new IllegalArgumentException("speed must > 0");
        }
        String unit = arr[1].trim().toLowerCase();
        if (!Arrays.asList("s", "m", "h", "d").contains(unit)) {
            throw new IllegalArgumentException("speed format 10/s, 10/m, 10/h, 10/d");
        }
        long unitDuration = 0L;
        if ("s".equals(unit)) {
            unitDuration = 1000L;
        } else if ("m".equals(unit)) {
            unitDuration = 60000L;
        } else if ("h".equals(unit)) {
            unitDuration = 3600000L;
        } else if ("d".equals(unit)) {
            unitDuration = 86400000L;
        }
        this.perSpend = unitDuration / (long)limit;
        return this;
    }

    public int getWaitingCount() {
        return this.waiting.size();
    }

    public Devourer errorHandle(BiConsumer<Throwable, Devourer> handler) {
        this.errorHandler = handler;
        return this;
    }

    public Devourer failMaxKeep(Integer maxKeep) {
        this.failMaxKeep = maxKeep;
        return this;
    }

    public Devourer suspend(final Duration duration) {
        this.pauseCondition = new Predicate<Devourer>(){
            final Pause pause;
            {
                this.pause = new Pause(duration);
            }

            @Override
            public boolean test(Devourer devourer) {
                return !this.pause.isTimeout();
            }
        };
        return this;
    }

    public Devourer suspend(Predicate<Devourer> pauseCondition) {
        this.pauseCondition = pauseCondition;
        return this;
    }

    public Devourer resume() {
        this.pauseCondition = null;
        this.trigger();
        return this;
    }

    public Devourer useLast(boolean useLast) {
        this.useLast = useLast;
        return this;
    }

    public boolean isUseLast() {
        return this.useLast;
    }

    public boolean isSuspended() {
        try {
            if (this.pauseCondition != null && this.pauseCondition.test(this)) {
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public int getParallel() {
        return this.lock.getLatchSize();
    }

    public int getLimit() {
        return this.lock.getLimit();
    }

    public void shutdown() {
        this.waiting.clear();
        if (this.exec instanceof ExecutorService) {
            ((ExecutorService)this.exec).shutdown();
        }
    }

    public String toString() {
        return this.key + "{parallel: " + this.getParallel() + ", waitingCount: " + this.getWaitingCount() + ", suspended: " + this.isSuspended() + ", useLast: " + this.isUseLast() + "}";
    }
}

