/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.app.util;

import java.io.RandomAccessFile;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tailer {
    protected static final Logger log = LoggerFactory.getLogger(Tailer.class);
    protected Thread th;
    protected boolean stopFlag;
    protected Function<String, Boolean> lineFn;
    protected Executor exec;

    public Tailer handle(Function<String, Boolean> lineFn) {
        this.lineFn = lineFn;
        return this;
    }

    public Tailer exec(Executor exec) {
        this.exec = exec;
        return this;
    }

    public void stop() {
        this.stopFlag = true;
    }

    public Tailer tail(String file) {
        return this.tail(file, 5);
    }

    public Tailer tail(String file, Integer follow) {
        if (this.lineFn == null) {
            this.lineFn = line -> {
                System.out.println((String)line);
                return true;
            };
        }
        Runnable fn = () -> {
            String tName = Thread.currentThread().getName();
            try {
                Thread.currentThread().setName("Tailer-" + file);
                this.run(file, follow == null ? 0 : follow);
            }
            catch (Exception ex) {
                log.error("Tail file " + file + " error", (Throwable)ex);
            }
            finally {
                Thread.currentThread().setName(tName);
            }
        };
        if (this.exec != null) {
            this.exec.execute(fn);
        } else {
            this.th = new Thread(fn, "Tailer-" + file);
            this.th.start();
        }
        return this;
    }

    private void run(String file, Integer follow) throws Exception {
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            LinkedList<String> buffer = follow != null && follow > 0 ? new LinkedList<String>() : null;
            boolean firstEnd = false;
            while (!this.stopFlag) {
                String line = raf.readLine();
                if (line == null) {
                    if (firstEnd) {
                        Thread.sleep(100L * (long)new Random().nextInt(10));
                        continue;
                    }
                    firstEnd = true;
                    if (buffer == null) continue;
                    while ((line = (String)buffer.poll()) != null) {
                        boolean bl = this.stopFlag = this.lineFn.apply(line) == false;
                        if (!this.stopFlag) continue;
                    }
                    buffer = null;
                    continue;
                }
                line = new String(line.getBytes("ISO-8859-1"), "utf-8");
                if (firstEnd) {
                    this.stopFlag = this.lineFn.apply(line) == false;
                    continue;
                }
                if (follow == null || follow <= 0) continue;
                buffer.offer(line);
                if (buffer.size() <= follow) continue;
                buffer.poll();
            }
        }
    }
}

