/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.app;

import cn.xnatural.app.util.Copier;
import cn.xnatural.app.util.Httper;
import cn.xnatural.app.util.Tailer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    protected static final Logger log = LoggerFactory.getLogger(Utils.class);
    public static final char[] CS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    public static final SecureRandom SR = new SecureRandom();

    public static String pid() {
        return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase(Locale.UK).trim().startsWith("linux");
    }

    public static File baseDir(String child) {
        File p = new File(System.getProperty("user.dir"));
        if (child != null) {
            return new File(p, child);
        }
        return p;
    }

    public static String ipv4() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface current = en.nextElement();
                if (!current.isUp() || current.isLoopback() || current.isVirtual()) continue;
                Enumeration<InetAddress> addresses = current.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (addr.isLoopbackAddress() || !(addr instanceof Inet4Address)) continue;
                    return addr.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static byte[] sha1(byte[] bs) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(bs);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String md5Hex(byte[] bs) {
        try {
            byte[] secretBytes = MessageDigest.getInstance("md5").digest(bs);
            String md5code = new BigInteger(1, secretBytes).toString(16);
            for (int i = 0; i < 32 - md5code.length(); ++i) {
                md5code = "0" + md5code;
            }
            return md5code;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String nanoId() {
        return Utils.nanoId(21, CS);
    }

    public static String nanoId(int len) {
        return Utils.nanoId(len, CS);
    }

    public static String nanoId(int len, char[] CS) {
        if (len < 1) {
            throw new IllegalArgumentException("Param len must >= 1");
        }
        if (CS == null || CS.length < 1) {
            throw new IllegalArgumentException("Param CS required");
        }
        int mask = (2 << (int)Math.floor(Math.log(CS.length - 1) / Math.log(2.0))) - 1;
        int step = (int)Math.ceil(1.6 * (double)mask * (double)len / (double)CS.length);
        StringBuilder sb = new StringBuilder();
        block0: while (true) {
            byte[] bytes = new byte[step];
            SR.nextBytes(bytes);
            int i = 0;
            while (true) {
                if (i >= step) continue block0;
                int idx = bytes[i] & mask;
                if (idx < CS.length) {
                    sb.append(CS[idx]);
                    if (sb.length() == len) {
                        return sb.toString();
                    }
                }
                ++i;
            }
            break;
        }
    }

    public static <T> T to(Object v, Class<T> type) {
        if (type == null) {
            return (T)v;
        }
        if (v == null) {
            if (Boolean.TYPE.equals(type)) {
                return (T)Boolean.FALSE;
            }
            if (Short.TYPE.equals(type)) {
                return (T)Short.valueOf("0");
            }
            if (Byte.TYPE.equals(type)) {
                return (T)Byte.valueOf("0");
            }
            if (Integer.TYPE.equals(type)) {
                return (T)Integer.valueOf(0);
            }
            if (Long.TYPE.equals(type)) {
                return (T)Long.valueOf(0L);
            }
            if (Double.TYPE.equals(type)) {
                return (T)Double.valueOf(0.0);
            }
            if (Float.TYPE.equals(type)) {
                return (T)Float.valueOf(0.0f);
            }
            if (Character.TYPE.equals(type)) {
                return (T)Character.valueOf('\u0000');
            }
            return null;
        }
        if (type.isAssignableFrom(v.getClass())) {
            return (T)v;
        }
        if (String.class.equals(type)) {
            if (v instanceof InputStream || v instanceof File) {
                StringBuilder sb = new StringBuilder();
                try (InputStreamReader rd = new InputStreamReader(v instanceof File ? Files.newInputStream(((File)v).toPath(), new OpenOption[0]) : (InputStream)v);){
                    char[] bs;
                    int len;
                    while ((len = rd.read(bs = new char[3069])) != -1) {
                        sb.append(bs, 0, len);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return (T)sb.toString();
            }
            return (T)v.toString();
        }
        if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            return (T)Boolean.valueOf(v.toString());
        }
        if (Short.class.equals(type) || Short.TYPE.equals(type)) {
            return (T)Short.valueOf(v.toString());
        }
        if (Byte.class.equals(type) || Byte.TYPE.equals(type)) {
            return (T)Byte.valueOf(v.toString());
        }
        if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
            return (T)Integer.valueOf(v.toString());
        }
        if (BigInteger.class.equals(type)) {
            return (T)new BigInteger(v.toString());
        }
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            return (T)Long.valueOf(v.toString());
        }
        if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            return (T)Double.valueOf(v.toString());
        }
        if (Float.class.equals(type) || Float.TYPE.equals(type)) {
            return (T)Float.valueOf(v.toString());
        }
        if (BigDecimal.class.equals(type)) {
            return (T)new BigDecimal(v.toString());
        }
        if (AtomicInteger.class.equals(type)) {
            return (T)new AtomicInteger(Integer.valueOf(v.toString()));
        }
        if (AtomicLong.class.equals(type)) {
            return (T)new AtomicLong(Long.valueOf(v.toString()));
        }
        if (LongAdder.class.equals(type)) {
            LongAdder la = new LongAdder();
            la.add(Long.valueOf(v.toString()));
            return (T)la;
        }
        if (URI.class.equals(type)) {
            return (T)URI.create(v.toString());
        }
        if (type.isEnum()) {
            return Arrays.stream(type.getEnumConstants()).filter(o -> v.equals(((Enum)o).name())).findFirst().orElse(null);
        }
        if (v instanceof Annotation && type.isAssignableFrom(Map.class)) {
            return (T)new Function<Annotation, Map<String, Object>>(){

                @Override
                public Map<String, Object> apply(Annotation anno) {
                    Method[] ms;
                    HashMap<String, Object> attr = new HashMap<String, Object>();
                    for (Method m : ms = anno.annotationType().getDeclaredMethods()) {
                        try {
                            Map<String, Object> v = m.invoke((Object)anno, new Object[0]);
                            if (v.getClass().isArray() && v.getClass().getComponentType().isAnnotation()) {
                                LinkedList<Map<String, Object>> ls = new LinkedList<Map<String, Object>>();
                                attr.put(m.getName(), ls);
                                for (Annotation a : (Annotation[])v) {
                                    ls.add(this.apply(a));
                                }
                                continue;
                            }
                            attr.put(m.getName(), v instanceof Annotation ? this.apply((Annotation)((Object)v)) : v);
                        }
                        catch (Exception e) {
                            log.warn("", (Throwable)e);
                        }
                    }
                    return attr;
                }
            }.apply((Annotation)v);
        }
        return (T)v;
    }

    public static void iterateMethod(Class clz, Consumer<Method> fn) {
        if (fn == null) {
            return;
        }
        Class c = clz;
        do {
            for (Method m : c.getDeclaredMethods()) {
                fn.accept(m);
            }
        } while ((c = c.getSuperclass()) != null);
    }

    public static void iterateField(Class clz, Consumer<Field> fn) {
        if (fn == null) {
            return;
        }
        Class c = clz;
        do {
            for (Field f : c.getDeclaredFields()) {
                fn.accept(f);
            }
        } while ((c = c.getSuperclass()) != null);
    }

    public static Httper http(String url) {
        return new Httper(url);
    }

    public static Tailer tailer() {
        return new Tailer();
    }

    public static <S, T> Copier<S, T> copier(S src, T target) {
        return new Copier<S, T>(src, target);
    }

    public static long ioCopy(InputStream is, OutputStream os, Integer bufSize) throws IOException {
        byte[] buf = new byte[bufSize == null || bufSize < 1 ? 1024 : bufSize];
        long count = 0L;
        int n = 0;
        while (-1 != (n = is.read(buf))) {
            os.write(buf, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long ioCopy(InputStream is, OutputStream os) throws IOException {
        return Utils.ioCopy(is, os, 4096);
    }
}

