/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.app;

import java.util.function.Supplier;

public class Lazier<T>
implements Supplier<T> {
    private final Supplier<T> supplier;
    private boolean once = false;
    private T result;

    public Lazier(Supplier<T> supplier) {
        if (supplier == null) {
            throw new NullPointerException("Param supplier is null");
        }
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Lazier lazier = this;
        synchronized (lazier) {
            this.once = false;
            this.result = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (!this.once) {
            Lazier lazier = this;
            synchronized (lazier) {
                if (!this.once) {
                    this.result = this.supplier.get();
                    if (this.result != null) {
                        this.once = true;
                    }
                }
            }
        }
        return this.result;
    }

    public boolean done() {
        return this.once;
    }

    public String toString() {
        return this.result == null ? null : this.result.toString();
    }
}

