/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.app;

import java.util.concurrent.atomic.AtomicInteger;

public class LatchLock {
    protected int limit = 1;
    protected final AtomicInteger latchSize = new AtomicInteger();

    public LatchLock limit(int limit) {
        if (limit < 1) {
            throw new IllegalArgumentException("Param limit must >0");
        }
        this.limit = limit;
        return this;
    }

    public boolean tryLock() {
        int latch = this.latchSize.get();
        if (latch >= this.limit) {
            return false;
        }
        if (this.latchSize.compareAndSet(latch, latch + 1)) {
            return true;
        }
        return this.tryLock();
    }

    public int release() {
        int latch = this.latchSize.get();
        if (latch <= 0) {
            return latch;
        }
        if (this.latchSize.compareAndSet(latch, latch - 1)) {
            return latch - 1;
        }
        return this.latchSize.get();
    }

    public int getLatchSize() {
        return this.latchSize.get();
    }
}

