/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.app;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiConsumer;
import org.slf4j.LoggerFactory;

public class Counter {
    protected final BiConsumer<String, LongAdder> fn;
    protected final String countByPattern;
    protected volatile String time;
    protected volatile LongAdder count = new LongAdder();

    public Counter(String countByPattern, BiConsumer<String, LongAdder> fn) {
        this.countByPattern = countByPattern;
        this.fn = fn;
        this.time = new SimpleDateFormat(countByPattern).format(new Date());
    }

    public Counter() {
        this("MM-dd HH", (time, count) -> LoggerFactory.getLogger((String)"ROOT").info("{} handle count {}", time, count));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment() {
        String hStr = new SimpleDateFormat(this.countByPattern).format(new Date());
        if (!this.time.equals(hStr)) {
            String oldTime = null;
            LongAdder oldCount = null;
            Counter counter = this;
            synchronized (counter) {
                if (!this.time.equals(hStr)) {
                    oldTime = this.time;
                    this.time = hStr;
                    oldCount = this.count;
                    this.count = new LongAdder();
                }
            }
            if (oldTime != null && this.fn != null) {
                this.fn.accept(oldTime, oldCount);
            }
        }
        this.count.increment();
    }
}

