/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.app;

import cn.xnatural.app.Lazier;
import cn.xnatural.app.ServerTpl;
import cn.xnatural.enet.event.EL;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;

public class CacheSrv
extends ServerTpl {
    protected final Lazier<Integer> _limit = new Lazier<Object>(() -> {
        this.queue(this.name).useLast(true);
        return this.getInteger("itemLimit", 1000);
    });
    protected final Lazier<Map<String, Record>> _data = new Lazier<Object>(() -> new ConcurrentHashMap(this._limit.get() / 3));
    protected final Lazier<Map<String, Map<String, Record>>> _hashdata = new Lazier<Object>(() -> new ConcurrentHashMap(this._limit.get() / 3));

    public CacheSrv(String name) {
        super(name);
    }

    public CacheSrv() {
    }

    public Object set(String key, Object value) {
        return this.set(key, value, Duration.ofMinutes(this.getInteger("defaultExpire", this.getInteger("expire." + key, 30)).intValue()));
    }

    public Object hset(String key, String dataKey, Object value) {
        return this.hset(key, dataKey, value, Duration.ofMinutes(this.getInteger("defaultExpire", this.getInteger("expire." + key, 30)).intValue()));
    }

    @EL(name={"{name}.set"})
    public Object set(String key, Object value, Duration expire) {
        return this.set(key, value, (Record record) -> expire == null ? Long.MAX_VALUE : expire.toMillis() + record.updateTime);
    }

    @EL(name={"{name}.hset"})
    public Object hset(String key, String dataKey, Object value, Duration expire) {
        return this.hset(key, dataKey, value, (Record record) -> expire == null ? Long.MAX_VALUE : expire.toMillis() + record.updateTime);
    }

    @EL(name={"{name}.set2"})
    public Object set(String key, Object value, Function<Record, Long> expireFn) {
        this.log.trace("Set cache. key: {}, value: {}", (Object)key, value);
        Record old = this._data.get().put(key, new Record(expireFn, value));
        if (old != null) {
            old.close(key);
        }
        this.clean();
        return old == null ? null : old.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EL(name={"{name}.hset2"})
    public Object hset(String key, String dataKey, Object value, Function<Record, Long> expireFn) {
        Record old;
        this.log.trace("HSet cache. key: {}, dataKey: {}, value: {}", new Object[]{key, dataKey, value});
        Map<String, Record> data = this._hashdata.get().get(key);
        if (data == null) {
            Lazier<Map<String, Map<String, Record>>> lazier = this._hashdata;
            synchronized (lazier) {
                data = this._hashdata.get().get(key);
                if (data == null) {
                    data = new ConcurrentHashMap<String, Record>();
                    this._hashdata.get().put(key, data);
                }
            }
        }
        if ((old = data.put(dataKey, new Record(expireFn, value))) != null) {
            old.close(dataKey);
        }
        this.clean();
        return old == null ? null : old.value;
    }

    @EL(name={"{name}.remove"})
    public Object remove(String key) {
        Record record = this._data.get().remove(key);
        if (record == null) {
            return null;
        }
        record.close(key);
        return record.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EL(name={"{name}.hremove"})
    public Object hremove(String key, String dataKey) {
        Map<String, Record> data = this._hashdata.get().get(key);
        if (data == null) {
            return null;
        }
        Record record = data.remove(dataKey);
        if (record == null) {
            return null;
        }
        record.close(dataKey);
        if (data.isEmpty()) {
            Lazier<Map<String, Map<String, Record>>> lazier = this._hashdata;
            synchronized (lazier) {
                if (data.isEmpty()) {
                    this._hashdata.get().remove(key);
                }
            }
        }
        return record.value;
    }

    @EL(name={"{name}.get"})
    public Object get(String key) {
        Record record = this._data.get().get(key);
        if (record == null) {
            return null;
        }
        if (record.valid()) {
            return record.value;
        }
        this.remove(key);
        return null;
    }

    @EL(name={"{name}.hget"})
    public Object hget(String key, String dataKey) {
        Map<String, Record> data = this._hashdata.get().get(key);
        if (data == null) {
            return null;
        }
        Record record = data.get(dataKey);
        if (record == null) {
            return null;
        }
        if (record.valid()) {
            return record.value;
        }
        this.hremove(key, dataKey);
        return null;
    }

    @EL(name={"{name}.getAndUpdate"})
    public Object getAndUpdate(String key) {
        Record record = this._data.get().get(key);
        if (record == null) {
            return null;
        }
        if (record.valid()) {
            record.updateTime = System.currentTimeMillis();
            return record.value;
        }
        this.remove(key);
        return null;
    }

    @EL(name={"{name}.hgetAndUpdate"})
    public Object hgetAndUpdate(String key, String dataKey) {
        Map<String, Record> data = this._hashdata.get().get(key);
        if (data == null) {
            return null;
        }
        Record record = data.get(dataKey);
        if (record == null) {
            return null;
        }
        if (record.valid()) {
            record.updateTime = System.currentTimeMillis();
            return record.value;
        }
        this.hremove(key, dataKey);
        return null;
    }

    protected void clean() {
        boolean onlyCleanExpired = this.count() < this._limit.get();
        long now = System.currentTimeMillis();
        Runnable clean = () -> {
            Record removed;
            AtomicInteger cleanCnt = new AtomicInteger();
            AtomicReference oldestData = new AtomicReference();
            AtomicReference oldestKey = new AtomicReference();
            AtomicReference oldestRecord = new AtomicReference();
            Consumer<Map> doClean = data -> {
                long oldLeft = 0L;
                Iterator iter = data.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    long left = ((Record)entry.getValue()).left(now);
                    if (left < 1L) {
                        iter.remove();
                        ((Record)entry.getValue()).close((String)entry.getKey());
                        oldestData.set(null);
                        cleanCnt.incrementAndGet();
                        if (!onlyCleanExpired) break;
                    }
                    if (onlyCleanExpired || cleanCnt.get() > 0 || oldestRecord.get() != null && left >= oldLeft && (oldLeft != left || ((Record)oldestRecord.get()).updateTime >= ((Record)entry.getValue()).updateTime)) continue;
                    oldestData.set(data);
                    oldestKey.set(entry.getKey());
                    oldestRecord.set(entry.getValue());
                    oldLeft = left;
                }
            };
            doClean.accept(this._data.get());
            for (Map<String, Record> data2 : this._hashdata.get().values()) {
                if (cleanCnt.get() > 0 && !onlyCleanExpired) break;
                doClean.accept(data2);
            }
            if (!onlyCleanExpired && cleanCnt.get() < 1 && oldestData.get() != null && (removed = (Record)((Map)oldestData.get()).remove(oldestKey.get())) != null) {
                removed.close((String)oldestKey.get());
            }
        };
        if (onlyCleanExpired) {
            this.queue(clean);
        } else {
            clean.run();
        }
    }

    @EL(name={"{name}.count"})
    public int count() {
        return this._data.get().size() + this._hashdata.get().values().stream().mapToInt(Map::size).sum();
    }

    public String toString() {
        return "CacheSrv@" + Integer.toHexString(this.hashCode()) + "[size=" + this.count() + ", limit=" + this._limit.get() + "]";
    }

    public class Record {
        protected final Function<Record, Long> expireFn;
        protected long updateTime = System.currentTimeMillis();
        public final Object value;

        protected Record(Function<Record, Long> expireFn, Object value) {
            this.expireFn = expireFn;
            this.value = value;
        }

        protected boolean valid() {
            return this.left(System.currentTimeMillis()) > 0L;
        }

        protected long left(long timePoint) {
            Long expireTime = this.expireFn == null ? null : this.expireFn.apply(this);
            return expireTime == null ? Long.MAX_VALUE : expireTime - timePoint;
        }

        public long getUpdateTime() {
            return this.updateTime;
        }

        protected void close(String key) {
            if (this.value instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)this.value).close();
                }
                catch (Exception e) {
                    CacheSrv.this.log.error("Remove cache: " + key + " close error", (Throwable)e);
                }
            }
        }
    }
}

