/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.app;

import cn.xnatural.app.Devourer;
import cn.xnatural.app.Inject;
import cn.xnatural.app.Lazier;
import cn.xnatural.app.ServerTpl;
import cn.xnatural.app.Utils;
import cn.xnatural.enet.event.EC;
import cn.xnatural.enet.event.EL;
import cn.xnatural.enet.event.EP;
import cn.xnatural.enet.event.Listener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppContext {
    protected static final Logger log = LoggerFactory.getLogger(AppContext.class);
    protected final Map<String, Object> sourceMap = new ConcurrentHashMap<String, Object>();
    protected final Map<String, Devourer> queues = new ConcurrentHashMap<String, Devourer>();
    public final Date startup = new Date();
    protected final Thread shutdownHook = new Thread(() -> {
        CountDownLatch latch = new CountDownLatch(1);
        this.ep().fire(new EC("sys.stopping", (Object)this).completeFn(ec -> latch.countDown()));
        try {
            latch.await(this.getAttr("sys.stopWait", Long.class, 30L), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }, "stop");
    protected final Lazier<ThreadPoolExecutor> _exec = new Lazier<ThreadPoolExecutor>(() -> {
        log.debug("init sys executor ...");
        int processorCount = Runtime.getRuntime().availableProcessors();
        Integer corePoolSize = Math.max(2, this.getAttr("sys.exec.corePoolSize", Integer.class, processorCount >= 4 ? 8 : 4));
        ThreadPoolExecutor exec = new ThreadPoolExecutor(corePoolSize, Math.max(corePoolSize, this.getAttr("sys.exec.maximumPoolSize", Integer.class, processorCount <= 8 ? 16 : Math.min(processorCount * 2, 64))), this.getAttr("sys.exec.keepAliveTime", Long.class, 6L), TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>(this.getAttr("sys.exec.queueCapacity", Integer.class, 100000).intValue()){
            double upThreadThreshold;
            {
                this.upThreadThreshold = AppContext.this.getAttr("sys.exec.upThreadThreshold", Double.class, 0.5);
            }

            boolean threshold() {
                int size = super.size();
                if (size <= 1) {
                    return false;
                }
                int ps = AppContext.this._exec.get().getPoolSize();
                if (ps >= AppContext.this._exec.get().getMaximumPoolSize()) {
                    return false;
                }
                return size >= (int)((double)ps * this.upThreadThreshold) && !AppContext.this.shutdownHook.isAlive();
            }

            @Override
            public boolean offer(Runnable r) {
                return !this.threshold() && super.offer(r);
            }
        }, new ThreadFactory(){
            final AtomicLong i = new AtomicLong(1L);

            @Override
            public Thread newThread(Runnable r) {
                log.trace("New thread: {}", (Object)this.i.get());
                return new Thread(r, "sys-" + this.i.getAndIncrement());
            }
        }, new ThreadPoolExecutor.CallerRunsPolicy()){

            @Override
            public void execute(Runnable cmd) {
                super.execute(() -> {
                    try {
                        cmd.run();
                    }
                    catch (Throwable ex) {
                        log.error("", ex);
                    }
                });
            }
        };
        if (this.getAttr("sys.exec.allowCoreThreadTimeOut", Boolean.class, false).booleanValue()) {
            exec.allowCoreThreadTimeOut(true);
        }
        return exec;
    });
    protected final Lazier<EP> _ep = new Lazier<EP>(() -> {
        log.debug("init ep ...");
        EP ep = new EP(this.exec(), LoggerFactory.getLogger(EP.class)){

            public Object fire(EC ec, List<Listener> ls) {
                if (("sys.inited".equals(ec.eName) || "sys.starting".equals(ec.eName) || "sys.stopping".equals(ec.eName) || "sys.started".equals(ec.eName)) && ec.source() != AppContext.this) {
                    throw new UnsupportedOperationException("not allow fire event '" + ec.eName + "'");
                }
                return super.fire(ec, ls);
            }

            public String toString() {
                return "coreEp";
            }
        };
        String track = this.getAttr("ep.track", String.class, null);
        if (track != null) {
            Arrays.stream(track.split(",")).filter(s -> s != null && !s.trim().isEmpty()).forEach(s -> ep.addTrackEvent(new String[]{s.trim()}));
        }
        ep.addListenerSource((Object)this);
        return ep;
    });
    private final Lazier<Map<String, Object>> _env = new Lazier<Map>(() -> {
        Properties p2;
        Throwable throwable;
        InputStream is;
        final ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>();
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> result.put(k.toString(), v)));
        String configname = result.getOrDefault("configname", "app");
        String profile = (String)result.get("profile");
        String configdir = (String)result.get("configdir");
        String fName = configname + ".properties";
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(fName);
            throwable = null;
            try {
                if (is != null) {
                    log.debug("load classpath config file: {}", (Object)fName);
                    p2 = new Properties();
                    p2.load(new InputStreamReader(is, StandardCharsets.UTF_8));
                    p2.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> result.put(k.toString(), v)));
                }
            }
            catch (Throwable p2) {
                throwable = p2;
                throw p2;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable p2) {
                            throwable.addSuppressed(p2);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            log.error("Load classpath config file: " + fName + " error", (Throwable)e);
        }
        if (profile != null) {
            fName = configname + "-" + profile + ".properties";
            try {
                is = this.getClass().getClassLoader().getResourceAsStream(fName);
                throwable = null;
                try {
                    if (is != null) {
                        log.debug("load classpath profile config file: {}", (Object)fName);
                        p2 = new Properties();
                        p2.load(new InputStreamReader(is, StandardCharsets.UTF_8));
                        p2.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> result.put(k.toString(), v)));
                    }
                }
                catch (Throwable p3) {
                    throwable = p3;
                    throw p3;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable p3) {
                                throwable.addSuppressed(p3);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                log.error("Load classpath config file: " + fName + " error", (Throwable)e);
            }
        }
        fName = configname + ".properties";
        try {
            is = new FileInputStream(fName);
            throwable = null;
            try {
                log.debug("load file:./ config file: {}", (Object)fName);
                p2 = new Properties();
                p2.load(new InputStreamReader(is, StandardCharsets.UTF_8));
                p2.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> result.put(k.toString(), v)));
            }
            catch (Throwable p4) {
                throwable = p4;
                throw p4;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable p4) {
                            throwable.addSuppressed(p4);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            log.trace("load file:./ config file: '{}' not found", (Object)fName);
        }
        catch (IOException e) {
            log.error("load file:./ config file: " + fName + " error", (Throwable)e);
        }
        if (profile != null) {
            fName = configname + "-" + profile + ".properties";
            try {
                is = new FileInputStream(fName);
                throwable = null;
                try {
                    log.debug("load file:./ profile config file: {}", (Object)fName);
                    p2 = new Properties();
                    p2.load(new InputStreamReader(is, StandardCharsets.UTF_8));
                    p2.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> result.put(k.toString(), v)));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                log.trace("load file:./ profile config file: {} not found", (Object)fName);
            }
            catch (IOException e) {
                log.error("load file:./ profile config file: " + fName + " error", (Throwable)e);
            }
        }
        if (configdir != null) {
            Properties p52;
            Throwable throwable4;
            FileInputStream is2;
            File targetFile = new File(configdir, configname + ".properties");
            try {
                is2 = new FileInputStream(targetFile);
                throwable4 = null;
                try {
                    log.debug("load configdir config file: {}", (Object)targetFile.getAbsolutePath());
                    p52 = new Properties();
                    p52.load(new InputStreamReader((InputStream)is2, StandardCharsets.UTF_8));
                    p52.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> result.put(k.toString(), v)));
                }
                catch (Throwable p52) {
                    throwable4 = p52;
                    throw p52;
                }
                finally {
                    if (is2 != null) {
                        if (throwable4 != null) {
                            try {
                                ((InputStream)is2).close();
                            }
                            catch (Throwable p52) {
                                throwable4.addSuppressed(p52);
                            }
                        } else {
                            ((InputStream)is2).close();
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                log.trace("load configdir config file: {} not found", (Object)targetFile.getAbsolutePath());
            }
            catch (IOException e) {
                log.error("load configdir config file: " + targetFile.getAbsolutePath() + "' error", (Throwable)e);
            }
            if (profile != null) {
                targetFile = new File(configdir, configname + "-" + profile + ".properties");
                try {
                    is2 = new FileInputStream(targetFile);
                    throwable4 = null;
                    try {
                        log.debug("load configdir profile config file: {}", (Object)targetFile.getAbsolutePath());
                        p52 = new Properties();
                        p52.load(new InputStreamReader((InputStream)is2, StandardCharsets.UTF_8));
                        p52.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> result.put(k.toString(), v)));
                    }
                    catch (Throwable throwable5) {
                        throwable4 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (is2 != null) {
                            if (throwable4 != null) {
                                try {
                                    ((InputStream)is2).close();
                                }
                                catch (Throwable throwable6) {
                                    throwable4.addSuppressed(throwable6);
                                }
                            } else {
                                ((InputStream)is2).close();
                            }
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    log.trace("load configdir profile config file: {} not found", (Object)targetFile.getAbsolutePath());
                }
                catch (IOException e) {
                    log.error("load configdir profile config file: " + targetFile.getAbsolutePath() + " error", (Throwable)e);
                }
            }
        }
        this.customEnv(result);
        new Runnable(){
            final Pattern pattern = Pattern.compile("(\\$\\{(?<attr>[\\w\\._]+)\\})+");
            final AtomicInteger count = new AtomicInteger(0);

            @Override
            public void run() {
                if (this.count.getAndIncrement() >= 3) {
                    return;
                }
                boolean f = false;
                for (Map.Entry e : result.entrySet()) {
                    Matcher m;
                    if (e.getValue() == null || !(m = this.pattern.matcher(e.getValue().toString())).find()) continue;
                    f = true;
                    result.put(e.getKey(), e.getValue().toString().replace(m.group(0), result.getOrDefault(m.group("attr"), "").toString()));
                }
                if (f) {
                    this.run();
                }
            }
        }.run();
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> result.put(k.toString(), v)));
        return result;
    });
    protected final Lazier<String> _name = new Lazier<String>(() -> this.getAttr("sys.name", String.class, "tiny"));
    protected final Lazier<String> _id = new Lazier<String>(() -> this.getAttr("sys.id", String.class, Utils.nanoId(10)));

    public ExecutorService exec() {
        return this._exec.get();
    }

    public EP ep() {
        return this._ep.get();
    }

    public Map<String, Object> env() {
        return this._env.get();
    }

    public AppContext start() {
        log.info("Starting Application with PID {}, active profile: {}", (Object)Utils.pid(), (Object)this.getProfile());
        this.ep().fire(new EC("sys.inited", (Object)this));
        this.ep().fire(new EC("sys.starting", (Object)this).completeFn(ec -> {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            this.sourceMap.forEach((s, o) -> this.inject(o));
            log.info("Started Application '{}' in {} seconds (JVM running for {})", new Object[]{this.name() + ":" + this.id(), (double)(System.currentTimeMillis() - this.startup.getTime()) / 1000.0, (double)ManagementFactory.getRuntimeMXBean().getUptime() / 1000.0});
            this.ep().fire(new EC("sys.started", (Object)this).completeFn(ec1 -> {
                String[] arr = this.getAttr("heartbeat", String.class, "30~180").split("~");
                Integer min = Integer.valueOf(arr[0]);
                Integer max = Integer.valueOf(arr[1]);
                final Supplier<Duration> next = () -> Duration.ofSeconds(new Random().nextInt(max - min) + min);
                new Runnable(){

                    @Override
                    public void run() {
                        AppContext.this.ep().fire(new EC("sys.heartbeat", (Object)this));
                        AppContext.this.ep().fire("sched.after", new Object[]{next.get(), this});
                    }
                }.run();
            }));
        }));
        return this;
    }

    public AppContext addSource(Object source, String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Param name required");
        }
        if (source == null) {
            throw new IllegalArgumentException("Param source required");
        }
        if ("sys".equalsIgnoreCase(name) || "env".equalsIgnoreCase(name) || "log".equalsIgnoreCase(name) || "bean".equalsIgnoreCase(name)) {
            log.error("Name not allowed [sys, env, log, bean]. source: {}", source);
            return this;
        }
        if (this.sourceMap.containsKey(name)) {
            log.error("Already exist bean '{}': {}", (Object)name, this.sourceMap.get(name));
            return this;
        }
        this.sourceMap.put(name, source);
        this.inject(source);
        this.ep().addListenerSource(source);
        return this;
    }

    public AppContext addSource(Object ... sources) {
        for (Object source : sources) {
            this.addSource(source, source instanceof ServerTpl ? ((ServerTpl)source).name : (source.getClass().getName().contains("$") ? source.getClass().getName() : source.getClass().getSimpleName()));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Devourer queue(String qName, Runnable fn) {
        if (qName == null || qName.isEmpty()) {
            throw new IllegalArgumentException("Param qName required");
        }
        Devourer devourer = this.queues.get(qName);
        if (devourer == null) {
            Map<String, Devourer> map = this.queues;
            synchronized (map) {
                devourer = this.queues.get(qName);
                if (devourer == null) {
                    devourer = new Devourer(qName, this.exec());
                    this.queues.put(qName, devourer);
                }
            }
        }
        if (fn != null) {
            devourer.offer(fn);
        }
        return devourer;
    }

    @EL(name={"inject"})
    public void inject(Object source) {
        Utils.iterateField(source.getClass(), field -> {
            Inject inject = field.getAnnotation(Inject.class);
            if (inject == null) {
                return;
            }
            try {
                field.setAccessible(true);
                Object v = field.get(source);
                if (v != null) {
                    return;
                }
                if (EP.class.isAssignableFrom(field.getType())) {
                    v = this.wrapEpForSource(source);
                } else if (inject.name().isEmpty()) {
                    v = this.bean(field.getType(), field.getName());
                    if (v == null) {
                        v = this.bean(field.getType(), null);
                    }
                } else {
                    v = this.bean(field.getType(), inject.name());
                }
                if (v == null) {
                    return;
                }
                field.set(source, v);
                log.trace("Inject field '{}' for object '{}'", (Object)field.getName(), source);
            }
            catch (Exception ex) {
                log.error("Inject field '" + field.getName() + "' error!", (Throwable)ex);
            }
        });
    }

    public <T> T bean(Class<T> type) {
        return this.bean(type, null);
    }

    public <T> T bean(Class<T> type, String name) {
        return (T)this.ep().fire(new EC("bean.get", (Object)this).sync().args(new Object[]{type, name}));
    }

    public Iterator<Map.Entry<String, Object>> beans() {
        return this.sourceMap.entrySet().iterator();
    }

    @EL(name={"bean.get", "sys.bean.get"}, order=-1.0f)
    protected <T> T localBean(EC ec, Class<T> bType, String bName) {
        Object bean;
        block11: {
            block10: {
                bean = null;
                if (bName == null || bType == null) break block10;
                bean = this.sourceMap.get(bName);
                if (bean == null || bType.isAssignableFrom(bean.getClass())) break block11;
                bean = null;
                break block11;
            }
            if (bName != null && bType == null) {
                bean = this.sourceMap.get(bName);
            } else if (bName == null && bType != null) {
                if (Executor.class.isAssignableFrom(bType)) {
                    bean = this.wrapExecForSource(ec.source());
                } else if (AppContext.class.isAssignableFrom(bType)) {
                    bean = this;
                } else if (EP.class.isAssignableFrom(bType)) {
                    bean = this.wrapEpForSource(ec.source());
                } else {
                    for (Map.Entry<String, Object> e : this.sourceMap.entrySet()) {
                        if (!bType.isAssignableFrom(e.getValue().getClass())) continue;
                        bean = e.getValue();
                        break;
                    }
                }
            }
        }
        return (T)bean;
    }

    protected Executor wrapExecForSource(Object source) {
        return new ExecutorService(){

            @Override
            public void shutdown() {
            }

            @Override
            public List<Runnable> shutdownNow() {
                return Collections.emptyList();
            }

            @Override
            public boolean isShutdown() {
                return AppContext.this._exec.get().isShutdown();
            }

            @Override
            public boolean isTerminated() {
                return AppContext.this._exec.get().isTerminated();
            }

            @Override
            public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
                return AppContext.this._exec.get().awaitTermination(timeout, unit);
            }

            @Override
            public <T> Future<T> submit(Callable<T> task) {
                return AppContext.this._exec.get().submit(task);
            }

            @Override
            public <T> Future<T> submit(Runnable task, T result) {
                return AppContext.this._exec.get().submit(task, result);
            }

            @Override
            public Future<?> submit(Runnable task) {
                return AppContext.this._exec.get().submit(task);
            }

            @Override
            public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
                return AppContext.this._exec.get().invokeAll(tasks);
            }

            @Override
            public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
                return AppContext.this._exec.get().invokeAll(tasks, timeout, unit);
            }

            @Override
            public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
                return AppContext.this._exec.get().invokeAny(tasks);
            }

            @Override
            public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return AppContext.this._exec.get().invokeAny(tasks, timeout, unit);
            }

            @Override
            public void execute(Runnable cmd) {
                AppContext.this._exec.get().execute(cmd);
            }

            public int getCorePoolSize() {
                return AppContext.this._exec.done() ? AppContext.this._exec.get().getCorePoolSize() : 0;
            }

            public int getMaximumPoolSize() {
                return AppContext.this._exec.done() ? AppContext.this._exec.get().getMaximumPoolSize() : 0;
            }

            public int getWaitingCount() {
                return AppContext.this._exec.done() ? AppContext.this._exec.get().getQueue().size() : 0;
            }

            public String toString() {
                return AppContext.this._exec.done() ? AppContext.this._exec.get().toString() : "uninitialized";
            }
        };
    }

    protected EP wrapEpForSource(final Object source) {
        return new EP(){

            protected void init(Executor exec, Logger log) {
            }

            public EP addTrackEvent(String ... eNames) {
                AppContext.this.ep().addTrackEvent(eNames);
                return this;
            }

            public EP delTrackEvent(String ... eNames) {
                AppContext.this.ep().delTrackEvent(eNames);
                return this;
            }

            public EP removeEvent(String eName, Object s) {
                if (source != null && s != null && source != s) {
                    throw new UnsupportedOperationException("Only allow remove event of this source: " + source);
                }
                AppContext.this.ep().removeEvent(eName, s);
                return this;
            }

            public EP addListenerSource(Object s) {
                AppContext.this.ep().addListenerSource(s);
                return this;
            }

            public EP listen(String eName, boolean async, float order, int limit, Runnable fn) {
                return AppContext.this.ep().listen(eName, async, order, limit, fn);
            }

            public EP listen(String eName, boolean async, float order, int limit, Function fn) {
                return AppContext.this.ep().listen(eName, async, order, limit, fn);
            }

            public EP listen(String eName, boolean async, float order, int limit, BiFunction fn) {
                return AppContext.this.ep().listen(eName, async, order, limit, fn);
            }

            public boolean exist(String ... eNames) {
                return AppContext.this.ep().exist(eNames);
            }

            public Object fire(EC ec) {
                return AppContext.this.ep().fire(ec);
            }

            public Object fire(EC ec, List<Listener> ls) {
                if (ec.source() == null) {
                    ec.source(source);
                }
                return AppContext.this.ep().fire(ec, ls);
            }

            public String toString() {
                return "wrappedCoreEp: " + source;
            }
        };
    }

    protected void customEnv(Map<String, Object> already) {
    }

    public Map<String, Object> attrs(String key) {
        ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.env().entrySet()) {
            if (!entry.getKey().startsWith(key + ".")) continue;
            result.put(entry.getKey().replace(key + ".", ""), entry.getValue());
        }
        return result;
    }

    public <T> T getAttr(String key, Class<T> type, T defaultValue) {
        T v = Utils.to(this.env().get(key), type);
        if (v == null) {
            return defaultValue;
        }
        return v;
    }

    public String getProfile() {
        return (String)this.env().get("profile");
    }

    public String name() {
        return this._name.get();
    }

    public String id() {
        return this._id.get();
    }
}

