/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.app.util;

import cn.xnatural.app.Utils;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Httper {
    protected static final Logger log = LoggerFactory.getLogger(Httper.class);
    protected String urlStr;
    protected String contentType;
    protected String method;
    protected String bodyStr;
    protected Map<String, Object> params;
    protected Map<String, Map<String, Object>> fileStreams;
    protected Map<String, Object> cookies;
    protected Map<String, String> headers;
    protected int connectTimeout = 5000;
    protected int readTimeout = 15000;
    protected int respCode;
    protected Consumer<HttpURLConnection> preFn;
    protected boolean debug;
    protected String tlsVersion = "TLSv1.2";
    protected Charset charset = Charset.forName("utf-8");

    public Httper get(String url) {
        this.urlStr = url;
        this.method = "GET";
        return this;
    }

    public Httper post(String url) {
        this.urlStr = url;
        this.method = "POST";
        return this;
    }

    public Httper put(String url) {
        this.urlStr = url;
        this.method = "PUT";
        return this;
    }

    public Httper delete(String url) {
        this.urlStr = url;
        this.method = "DELETE";
        return this;
    }

    public Httper contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public Httper jsonBody(String jsonStr) {
        this.bodyStr = jsonStr;
        if (this.contentType == null) {
            this.contentType = "application/json";
        }
        return this;
    }

    public Httper textBody(String bodyStr) {
        this.bodyStr = bodyStr;
        if (this.contentType == null) {
            this.contentType = "text/plain";
        }
        return this;
    }

    public Httper readTimeout(int timeout) {
        this.readTimeout = timeout;
        return this;
    }

    public Httper connectTimeout(int timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    public Httper preConnect(Consumer<HttpURLConnection> preConnect) {
        this.preFn = preConnect;
        return this;
    }

    public Httper debug() {
        this.debug = true;
        return this;
    }

    public Httper charset(String charset) {
        this.charset = Charset.forName(charset);
        return this;
    }

    public Httper tlsVersion(String tlsVersion) {
        this.tlsVersion = tlsVersion;
        return this;
    }

    public Httper param(String name, Object value) {
        if (this.params == null) {
            this.params = new LinkedHashMap<String, Object>();
        }
        this.params.put(name, value);
        if (value instanceof File) {
            this.contentType = "multipart/form-data";
        }
        return this;
    }

    public Httper fileStream(String pName, String filename, InputStream fileStream) {
        if (pName == null) {
            throw new NullPointerException("pName == null");
        }
        if (fileStream == null) {
            throw new NullPointerException("fileStream == null");
        }
        if (filename == null) {
            throw new NullPointerException("filename == null");
        }
        if (this.fileStreams == null) {
            this.fileStreams = new LinkedHashMap<String, Map<String, Object>>();
        }
        this.contentType = "multipart/form-data";
        Map entry = this.fileStreams.computeIfAbsent(pName, s -> new HashMap(2));
        entry.put("filename", filename);
        entry.put("fileStream", fileStream);
        return this;
    }

    public Httper header(String name, String value) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, String>(7);
        }
        this.headers.put(name, value);
        return this;
    }

    public Httper cookie(String name, Object value) {
        if (this.cookies == null) {
            this.cookies = new LinkedHashMap<String, Object>(7);
        }
        this.cookies.put(name, value);
        return this;
    }

    public Map<String, Object> cookies() {
        return this.cookies;
    }

    public int getResponseCode() {
        return this.respCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String execute() {
        Exception ex;
        String ret;
        block97: {
            HttpURLConnection conn;
            block94: {
                String twoHyphens;
                String end;
                DataOutputStream dataOutputStream;
                String boundary;
                block95: {
                    Iterator<Map.Entry<String, Object>> iterator;
                    block96: {
                        ret = null;
                        conn = null;
                        boolean isMulti = false;
                        ex = null;
                        try {
                            Object object;
                            URL url = null;
                            if (this.urlStr == null || this.urlStr.isEmpty()) {
                                throw new IllegalArgumentException("url\u4e0d\u80fd\u4e3a\u7a7a");
                            }
                            url = "GET".equals(this.method) ? new URL(Utils.buildUrl(this.urlStr, this.params)) : new URL(this.urlStr);
                            conn = (HttpURLConnection)url.openConnection();
                            if (conn instanceof HttpsURLConnection) {
                                SSLContext sc = SSLContext.getInstance(this.tlsVersion);
                                sc.init(null, new TrustManager[]{new X509TrustManager(){

                                    @Override
                                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                                    }

                                    @Override
                                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                                    }

                                    @Override
                                    public X509Certificate[] getAcceptedIssuers() {
                                        return null;
                                    }
                                }}, new SecureRandom());
                                ((HttpsURLConnection)conn).setHostnameVerifier((s, sslSession) -> true);
                                ((HttpsURLConnection)conn).setSSLSocketFactory(sc.getSocketFactory());
                            }
                            conn.setRequestMethod(this.method);
                            conn.setConnectTimeout(this.connectTimeout);
                            conn.setReadTimeout(this.readTimeout);
                            conn.setUseCaches(false);
                            conn.setRequestProperty("Accept", "*/*");
                            conn.setRequestProperty("Charset", this.charset.toString());
                            conn.setRequestProperty("Accept-Charset", this.charset.toString());
                            if (this.contentType != null) {
                                conn.setRequestProperty("Content-Type", this.contentType + ";charset=" + this.charset);
                            }
                            if (this.headers != null) {
                                for (Map.Entry entry : this.headers.entrySet()) {
                                    conn.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                                }
                            }
                            boundary = null;
                            if ("POST".equals(this.method)) {
                                conn.setDoOutput(true);
                                if ("multipart/form-data".equalsIgnoreCase(this.contentType)) {
                                    isMulti = true;
                                    boundary = "----CustomFormBoundary" + UUID.randomUUID().toString().replace("-", "");
                                    this.contentType = "multipart/form-data;boundary=" + boundary;
                                    conn.setRequestProperty("Content-Type", this.contentType + ";charset=" + this.charset);
                                }
                            }
                            if (this.cookies != null && !this.cookies.isEmpty()) {
                                StringBuilder stringBuilder = new StringBuilder();
                                for (Map.Entry<String, Object> entry : this.cookies.entrySet()) {
                                    if (entry.getValue() == null) continue;
                                    stringBuilder.append(entry.getKey()).append("=").append(entry.getValue()).append(";");
                                }
                                conn.setRequestProperty("Cookie", stringBuilder.toString());
                            }
                            if (this.preFn != null) {
                                this.preFn.accept(conn);
                            }
                            conn.connect();
                            if ("POST".equals(this.method)) {
                                dataOutputStream = new DataOutputStream(conn.getOutputStream());
                                object = null;
                                try {
                                    if (("application/json".equals(this.contentType) || "text/plain".equals(this.contentType)) && this.bodyStr != null) {
                                        dataOutputStream.write(this.bodyStr.getBytes(this.charset));
                                        break block94;
                                    }
                                    if (isMulti) {
                                        end = "\r\n";
                                        twoHyphens = "--";
                                        if (this.params == null) break block95;
                                        iterator = this.params.entrySet().iterator();
                                        break block96;
                                    }
                                    if (this.params != null && !this.params.isEmpty()) {
                                        StringBuilder sb = new StringBuilder();
                                        for (Map.Entry entry : this.params.entrySet()) {
                                            if (entry.getValue() == null) continue;
                                            sb.append((String)entry.getKey() + "=" + URLEncoder.encode(entry.getValue().toString(), this.charset.toString()) + "&");
                                        }
                                        dataOutputStream.write(sb.toString().getBytes(this.charset));
                                    }
                                    break block94;
                                }
                                catch (Throwable throwable) {
                                    object = throwable;
                                    throw throwable;
                                }
                                finally {
                                    if (dataOutputStream != null) {
                                        if (object != null) {
                                            try {
                                                dataOutputStream.close();
                                            }
                                            catch (Throwable throwable) {
                                                ((Throwable)object).addSuppressed(throwable);
                                            }
                                        } else {
                                            dataOutputStream.close();
                                        }
                                    }
                                }
                            }
                            if (!"GET".equals(this.method) || this.bodyStr == null || this.bodyStr.isEmpty()) break block94;
                            DataOutputStream dataOutputStream2 = new DataOutputStream(conn.getOutputStream());
                            object = null;
                            try {
                                dataOutputStream2.write(this.bodyStr.getBytes(this.charset));
                                break block94;
                            }
                            catch (Throwable throwable) {
                                object = throwable;
                                throw throwable;
                            }
                            finally {
                                if (dataOutputStream2 != null) {
                                    if (object != null) {
                                        try {
                                            dataOutputStream2.close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)object).addSuppressed(throwable);
                                        }
                                    } else {
                                        dataOutputStream2.close();
                                    }
                                }
                            }
                        }
                        catch (Exception e2) {
                            ex = e2;
                            break block97;
                        }
                    }
                    while (iterator.hasNext()) {
                        Map.Entry<String, Object> entry = iterator.next();
                        dataOutputStream.writeBytes((String)twoHyphens + boundary + end);
                        if (entry.getValue() instanceof File) {
                            String s2 = "Content-Disposition: form-data; name=\"" + entry.getKey() + "\"; filename=\"" + ((File)entry.getValue()).getName() + "\"" + end;
                            dataOutputStream.write(s2.getBytes(this.charset));
                            dataOutputStream.writeBytes(end);
                            try (FileInputStream is = new FileInputStream((File)entry.getValue());){
                                int n;
                                byte[] bs = new byte[Math.min(is.available(), 4028)];
                                while (-1 != (n = is.read(bs))) {
                                    dataOutputStream.write(bs, 0, n);
                                }
                            }
                        } else {
                            dataOutputStream.write(("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"" + end).getBytes(this.charset));
                            dataOutputStream.writeBytes(end);
                            dataOutputStream.write(entry.getValue() == null ? "".getBytes(this.charset) : entry.getValue().toString().getBytes(this.charset));
                        }
                        dataOutputStream.writeBytes(end);
                    }
                }
                if (this.fileStreams != null) {
                    for (Map.Entry<String, Map<String, Object>> entry : this.fileStreams.entrySet()) {
                        dataOutputStream.writeBytes((String)twoHyphens + boundary + end);
                        Map<String, Object> fileInfo = entry.getValue();
                        String s3 = "Content-Disposition: form-data; name=\"" + entry.getKey() + "\"; filename=\"" + fileInfo.get("filename") + "\"" + end;
                        dataOutputStream.write(s3.getBytes(this.charset));
                        dataOutputStream.writeBytes(end);
                        try (InputStream is = (InputStream)fileInfo.get("fileStream");){
                            int n;
                            byte[] bs = new byte[Math.min(is.available(), 4028)];
                            while (-1 != (n = is.read(bs))) {
                                dataOutputStream.write(bs, 0, n);
                            }
                        }
                        dataOutputStream.writeBytes(end);
                    }
                }
                dataOutputStream.writeBytes((String)twoHyphens + boundary + (String)twoHyphens + end);
            }
            this.respCode = conn.getResponseCode();
            if (conn.getHeaderFields() != null) {
                conn.getHeaderFields().entrySet().stream().filter(e -> "Set-Cookie".equalsIgnoreCase((String)e.getKey())).map(Map.Entry::getValue).findFirst().ifPresent(cs -> {
                    for (String c : cs) {
                        String[] arr = c.split(";")[0].split("=");
                        this.cookie(arr[0], arr[1]);
                    }
                });
            }
            StringBuilder stringBuilder = new StringBuilder();
            try (InputStreamReader reader = new InputStreamReader(conn.getInputStream(), this.charset);){
                int n;
                char[] buf = new char[1024];
                boolean bl = false;
                while ((n = reader.read(buf)) != -1) {
                    stringBuilder.append(buf, 0, n);
                }
            }
            ret = stringBuilder.toString();
            break block97;
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        if (this.debug) {
            String logMsg = "Send http: (" + this.method + ")" + this.urlStr + ", params: " + this.params + ", bodyStr: " + this.bodyStr + ", result: " + ret;
            if (ex == null) {
                log.info(logMsg);
            } else {
                log.error(logMsg, (Throwable)ex);
            }
        }
        if (ex != null) {
            throw new RuntimeException(ex);
        }
        return ret;
    }
}

