/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.app.util;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.sql.DataSource;

public class DB
implements AutoCloseable {
    protected static final AtomicInteger count = new AtomicInteger();
    public final String name = "DB-" + count.getAndIncrement();
    protected volatile DataSource dataSource;
    protected Integer maxRows = 5000;
    protected final Map<String, Object> dsAttr = new HashMap<String, Object>();
    protected static final ThreadLocal<Connection> txConn = new ThreadLocal();

    public DB(DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("Param dataSource required");
        }
        this.dataSource = dataSource;
    }

    public DB(Map<String, Object> dsAttr) {
        if (dsAttr == null) {
            throw new IllegalArgumentException("Param dsAttr required");
        }
        this.dsAttr.putAll(dsAttr);
    }

    public DB(String jdbcUrl) {
        this(jdbcUrl, null, null, 1, 8);
    }

    public DB(String jdbcUrl, String username, String password) {
        this(jdbcUrl, username, password, null, null);
    }

    public DB(String jdbcUrl, Integer minIdle, Integer maxActive) {
        this(jdbcUrl, null, null, minIdle, maxActive);
    }

    public DB(String jdbcUrl, String username, String password, Integer minIdle, Integer maxActive) {
        if (jdbcUrl == null || jdbcUrl.isEmpty()) {
            throw new IllegalArgumentException("Param jdbcUrl required");
        }
        if (minIdle == null || minIdle < 0) {
            throw new IllegalArgumentException("Param minIdle must >= 0");
        }
        if (maxActive == null || maxActive <= 0) {
            throw new IllegalArgumentException("Param maxActive must > 0");
        }
        this.dsAttr.put("url", jdbcUrl);
        this.dsAttr.put("jdbcUrl", jdbcUrl);
        if (username != null) {
            this.dsAttr.put("username", username);
        }
        if (password != null) {
            this.dsAttr.put("password", password);
        }
        this.dsAttr.put("minIdle", minIdle);
        this.dsAttr.put("minimumIdle", minIdle);
        this.dsAttr.put("maxActive", maxActive);
        this.dsAttr.put("maximumPoolSize", maxActive);
    }

    public DB dsAttr(String attrName, Object attrValue) {
        if (this.dataSource != null) {
            throw new RuntimeException("dataSource already created");
        }
        this.dsAttr.put(attrName, attrValue);
        return this;
    }

    public DB setMaxRows(int maxRows) {
        if (maxRows < 1) {
            throw new IllegalArgumentException("Param maxRows must > 0");
        }
        this.maxRows = maxRows;
        return this;
    }

    public <T> T withConn(Function<Connection, T> fn) {
        this.init();
        Connection conn = null;
        try {
            conn = txConn.get() == null ? this.dataSource.getConnection() : txConn.get();
            T t = fn.apply(conn);
            return t;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (txConn.get() == null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    public <T> T trans(Supplier<T> fn) {
        return (T)this.withConn(conn -> {
            try {
                boolean ac = conn.getAutoCommit();
                try {
                    txConn.set((Connection)conn);
                    conn.setAutoCommit(false);
                    Object t = fn.get();
                    conn.commit();
                    Object t2 = t;
                    return t2;
                }
                catch (Exception ex) {
                    conn.rollback();
                    throw ex;
                }
                finally {
                    txConn.set(null);
                    conn.setAutoCommit(ac);
                    conn.close();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public int execute(String sql, Object ... params) {
        return this.withConn(conn -> {
            try (PreparedStatement pst = conn.prepareStatement(sql);){
                this.fillParam(pst, params);
                Integer n = pst.executeUpdate();
                return n;
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public int call(String sql, Object ... params) {
        return this.withConn(conn -> {
            try (CallableStatement cst = conn.prepareCall(sql);){
                this.fillParam(cst, params);
                Integer n = cst.executeUpdate();
                return n;
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public Object insertWithGeneratedKey(String sql, Object ... params) {
        return this.withConn(conn -> {
            try (PreparedStatement pst = conn.prepareStatement(sql, 1);){
                this.fillParam(pst, params);
                pst.executeUpdate();
                try (ResultSet rs = pst.getGeneratedKeys();){
                    if (!rs.next()) return null;
                    Object object = rs.getObject(1);
                    return object;
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public List<Map<String, Object>> rows(String sql, Object ... params) {
        LinkedList result = new LinkedList();
        return this.withConn(conn -> {
            try (PreparedStatement pst = conn.prepareStatement(sql);){
                this.fillParam(pst, params);
                try (ResultSet rs = pst.executeQuery();){
                    while (rs.next()) {
                        ResultSetMetaData metadata = rs.getMetaData();
                        LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>(metadata.getColumnCount(), 1.0f);
                        result.add(row);
                        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                            row.put(metadata.getColumnLabel(i), rs.getObject(i));
                        }
                    }
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            return result;
        });
    }

    public Map<String, Object> row(String sql, Object ... params) {
        LinkedHashMap result = new LinkedHashMap();
        return this.withConn(conn -> {
            try (PreparedStatement pst = conn.prepareStatement(sql);){
                this.fillParam(pst, params);
                try (ResultSet rs = pst.executeQuery();){
                    if (rs.next()) {
                        ResultSetMetaData metadata = rs.getMetaData();
                        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                            result.put(metadata.getColumnLabel(i), rs.getObject(i));
                        }
                    }
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            return result;
        });
    }

    public <T> T single(String sql, Class<T> retType, Object ... params) {
        return (T)this.withConn(conn -> {
            try (PreparedStatement pst = conn.prepareStatement(sql);){
                this.fillParam(pst, params);
                try (ResultSet rs = pst.executeQuery();){
                    if (!rs.next()) return null;
                    if (String.class.equals((Object)retType)) {
                        String string = rs.getString(1);
                        return string;
                    }
                    if (Integer.class.equals((Object)retType)) {
                        Integer n = rs.getInt(1);
                        return n;
                    }
                    if (Long.class.equals((Object)retType)) {
                        Long l = rs.getLong(1);
                        return l;
                    }
                    if (Double.class.equals((Object)retType)) {
                        Double d = rs.getDouble(1);
                        return d;
                    }
                    if (BigDecimal.class.equals((Object)retType)) {
                        BigDecimal bigDecimal = rs.getBigDecimal(1);
                        return bigDecimal;
                    }
                    if (Boolean.class.equals((Object)retType)) {
                        Boolean bl = rs.getBoolean(1);
                        return bl;
                    }
                    if (java.util.Date.class.equals((Object)retType)) {
                        Date date = rs.getDate(1);
                        return date;
                    }
                    Object object = rs.getObject(1);
                    return object;
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    protected void fillParam(PreparedStatement pst, Object ... params) throws SQLException {
        ParameterMetaData metaData = pst.getParameterMetaData();
        if (metaData != null && params != null) {
            for (int i = 0; i < params.length; ++i) {
                Object v = params[i];
                if (v instanceof java.util.Date) {
                    v = new Date(((java.util.Date)v).getTime());
                }
                pst.setObject(i + 1, v);
            }
        }
        pst.setMaxRows(this.maxRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DB init() {
        if (this.dataSource == null) {
            DB dB = this;
            synchronized (dB) {
                if (this.dataSource == null) {
                    this.dataSource = DB.createDataSource(this.dsAttr);
                }
            }
        }
        return this;
    }

    @Override
    public void close() throws Exception {
        try {
            this.dataSource.getClass().getMethod("close", new Class[0]).invoke((Object)this.dataSource, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getJdbcUrl() {
        if (this.dataSource == null) {
            this.init();
        }
        try {
            Class<?> c = this.dataSource.getClass();
            do {
                for (Field f : c.getDeclaredFields()) {
                    if (!"jdbcUrl".equals(f.getName()) && !"url".equals(f.getName())) continue;
                    f.setAccessible(true);
                    return (String)f.get(this.dataSource);
                }
            } while ((c = c.getSuperclass()) != null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        return "DB{name='" + this.name + '\'' + "jdbcUrl='" + this.getJdbcUrl() + '\'' + '}';
    }

    public static DataSource createDataSource(Map<String, Object> dsAttr) {
        Map<String, String> props2;
        DataSource ds = null;
        try {
            props2 = new HashMap<String, String>();
            dsAttr.forEach((s, o) -> props2.put((String)s, Objects.toString(o, "")));
            if (!props2.containsKey("filters")) {
                props2.put("filters", "stat");
            }
            if (!props2.containsKey("connectionProperties")) {
                props2.put("connectionProperties", "druid.stat.logSlowSql=true;druid.stat.slowSqlMillis=5000");
            }
            ds = (DataSource)Class.forName("com.alibaba.druid.pool.DruidDataSourceFactory").getMethod("createDataSource", Map.class).invoke(null, props2);
        }
        catch (ClassNotFoundException props2) {
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (ds != null) {
            return ds;
        }
        try {
            Class<?> clz = Class.forName("com.zaxxer.hikari.HikariDataSource");
            ds = (DataSource)clz.newInstance();
            for (PropertyDescriptor pd : Introspector.getBeanInfo(clz).getPropertyDescriptors()) {
                Object v = dsAttr.get(pd.getName());
                if (v == null) continue;
                if (Integer.class.equals(pd.getPropertyType()) || Integer.TYPE.equals(pd.getPropertyType())) {
                    pd.getWriteMethod().invoke((Object)ds, Integer.valueOf(v.toString()));
                    continue;
                }
                if (Long.class.equals(pd.getPropertyType()) || Long.TYPE.equals(pd.getPropertyType())) {
                    pd.getWriteMethod().invoke((Object)ds, Long.valueOf(v.toString()));
                    continue;
                }
                if (Boolean.class.equals(pd.getPropertyType()) || Boolean.TYPE.equals(pd.getPropertyType())) {
                    pd.getWriteMethod().invoke((Object)ds, Boolean.valueOf(v.toString()));
                    continue;
                }
                pd.getWriteMethod().invoke((Object)ds, v);
            }
        }
        catch (ClassNotFoundException clz) {
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (ds != null) {
            return ds;
        }
        try {
            props2 = new Properties();
            dsAttr.forEach((s, o) -> props2.put(s, Objects.toString(o, "")));
            ds = (DataSource)Class.forName("org.apache.commons.dbcp2.BasicDataSourceFactory").getMethod("createDataSource", Properties.class).invoke(null, props2);
        }
        catch (ClassNotFoundException props3) {
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (ds == null) {
            throw new RuntimeException("No found DataSource impl class");
        }
        return ds;
    }
}

