/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.app.util;

import cn.xnatural.app.Utils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class Copier<S, T> {
    protected final S src;
    protected final T target;
    protected boolean ignoreNull = false;
    protected Map<String, BiFunction<S, T, Object>> valueGetter;
    protected Map<String, Function> valueConverter;
    protected Map<String, String> mapProps;
    protected final Set<String> ignore = new HashSet<String>(Arrays.asList("class"));

    public Copier(S src, T target) {
        this.src = src;
        this.target = target;
    }

    public Copier<S, T> ignore(String ... propNames) {
        if (propNames == null) {
            return this;
        }
        for (String name : propNames) {
            this.ignore.add(name);
        }
        return this;
    }

    public Copier<S, T> showClassProp() {
        this.ignore.remove("class");
        return this;
    }

    public Copier<S, T> mapProp(String srcPropName, String targetPropName) {
        if (targetPropName == null || targetPropName.isEmpty()) {
            throw new IllegalArgumentException("Param targetPropName required");
        }
        if (srcPropName == null || srcPropName.isEmpty()) {
            throw new IllegalArgumentException("Param srcPropName required");
        }
        if (this.mapProps == null) {
            this.mapProps = new HashMap<String, String>(7);
        }
        this.mapProps.put(targetPropName, srcPropName);
        this.mapProps.put(srcPropName, targetPropName);
        return this;
    }

    public Copier<S, T> ignoreNull(boolean ignoreNull) {
        this.ignoreNull = ignoreNull;
        return this;
    }

    public Copier<S, T> add(String srcPropName, Supplier<Object> valuer) {
        if (valuer == null) {
            throw new IllegalArgumentException("Param valuer required");
        }
        return this.add(srcPropName, (S s, T t) -> valuer.get());
    }

    public Copier<S, T> add(String srcPropName, BiFunction<S, T, Object> valuer) {
        if (srcPropName == null || srcPropName.isEmpty()) {
            throw new IllegalArgumentException("Param srcPropName required");
        }
        if (valuer == null) {
            throw new IllegalArgumentException("Param valuer required");
        }
        if (this.valueGetter == null) {
            this.valueGetter = new HashMap<String, BiFunction<S, T, Object>>(7);
        }
        this.valueGetter.put(srcPropName, valuer);
        return this;
    }

    public Copier<S, T> addConverter(String srcPropName, Function converter) {
        if (srcPropName == null || srcPropName.isEmpty()) {
            throw new IllegalArgumentException("Param srcPropName required");
        }
        if (converter == null) {
            throw new IllegalArgumentException("Param converter required");
        }
        if (this.valueConverter == null) {
            this.valueConverter = new HashMap<String, Function>(7);
        }
        this.valueConverter.put(srcPropName, converter);
        return this;
    }

    public T build() {
        if (this.target == null || this.src == null) {
            return this.target;
        }
        if (this.src instanceof Map && this.target instanceof Map) {
            Consumer<String> setFn = srcPropName -> {
                if (srcPropName == null || this.ignore.contains(srcPropName)) {
                    return;
                }
                try {
                    String targetPropName;
                    String string = targetPropName = this.mapProps != null && this.mapProps.containsKey(srcPropName) ? this.mapProps.get(srcPropName) : srcPropName;
                    if (this.ignore.contains(targetPropName)) {
                        return;
                    }
                    Object v = this.get((String)srcPropName);
                    if (this.ignoreNull && v == null) {
                        return;
                    }
                    ((Map)this.target).put(targetPropName, v);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            };
            for (Map.Entry entry : ((Map)this.src).entrySet()) {
                setFn.accept(entry.getKey().toString());
            }
            if (this.valueGetter != null) {
                this.valueGetter.forEach((propName, getter) -> setFn.accept((String)propName));
            }
        } else if (this.target instanceof Map) {
            this.javabeanToMap();
        } else {
            this.toJavabean();
        }
        return this.target;
    }

    protected void javabeanToMap() {
        HashSet alreadyNames = new HashSet();
        Consumer<String> setFn = srcPropName -> {
            if (srcPropName == null || this.ignore.contains(srcPropName) || alreadyNames.contains(srcPropName)) {
                return;
            }
            alreadyNames.add(srcPropName);
            try {
                String targetPropName;
                String string = targetPropName = this.mapProps != null && this.mapProps.containsKey(srcPropName) ? this.mapProps.get(srcPropName) : srcPropName;
                if (this.ignore.contains(targetPropName)) {
                    return;
                }
                Object v = this.get((String)srcPropName);
                if (this.ignoreNull && v == null) {
                    return;
                }
                ((Map)this.target).put(targetPropName, v);
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
        Utils.iterateMethod(this.src.getClass(), method -> setFn.accept(this.getGetterName((Method)method)));
        Utils.iterateField(this.src.getClass(), field -> setFn.accept(this.getPropFieldName((Field)field)));
        if (this.valueGetter != null) {
            this.valueGetter.forEach((propName, getter) -> setFn.accept((String)propName));
        }
    }

    protected void toJavabean() {
        HashSet alreadyNames = new HashSet();
        BiConsumer<String, Consumer> setFn = (targetPropName, fn) -> {
            if (targetPropName == null || this.ignore.contains(targetPropName) || alreadyNames.contains(targetPropName)) {
                return;
            }
            alreadyNames.add(targetPropName);
            try {
                String srcPropName;
                String string = srcPropName = this.mapProps != null && this.mapProps.containsKey(targetPropName) ? this.mapProps.get(targetPropName) : targetPropName;
                if (this.ignore.contains(srcPropName)) {
                    return;
                }
                Object v = this.get(srcPropName);
                if (this.ignoreNull && v == null) {
                    return;
                }
                fn.accept(v);
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
        Utils.iterateMethod(this.target.getClass(), method -> setFn.accept(this.getSetterName((Method)method), v -> {
            try {
                method.setAccessible(true);
                method.invoke(this.target, v);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
        Utils.iterateField(this.target.getClass(), field -> setFn.accept(this.getPropFieldName((Field)field), v -> {
            try {
                field.setAccessible(true);
                field.set(this.target, v);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
    }

    protected Object get(String srcPropName) throws Exception {
        Object v = null;
        if (this.valueGetter != null && this.valueGetter.containsKey(srcPropName)) {
            v = this.valueGetter.get(srcPropName).apply(this.src, this.target);
        } else if (this.src instanceof Map) {
            v = ((Map)this.src).get(srcPropName);
        } else {
            Class<?> c = this.src.getClass();
            block0: do {
                for (Method method : c.getDeclaredMethods()) {
                    if (!Objects.equals(this.getGetterName(method), srcPropName)) continue;
                    method.setAccessible(true);
                    v = method.invoke(this.src, new Object[0]);
                    break block0;
                }
                for (AccessibleObject accessibleObject : c.getDeclaredFields()) {
                    if (!Objects.equals(this.getPropFieldName((Field)accessibleObject), srcPropName)) continue;
                    ((Field)accessibleObject).setAccessible(true);
                    v = ((Field)accessibleObject).get(this.src);
                    break block0;
                }
            } while ((c = c.getSuperclass()) != null);
        }
        if (this.valueConverter != null && this.valueConverter.containsKey(srcPropName)) {
            v = this.valueConverter.get(srcPropName).apply(v);
        }
        return v;
    }

    protected String getSetterName(Method method) {
        boolean isSetter;
        boolean bl = isSetter = method.getName().startsWith("set") && method.getName().length() > 3 && method.getParameterCount() == 1 && Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers());
        if (isSetter) {
            String tmp = method.getName().replace("set", "");
            if (tmp.length() == 1) {
                return tmp.toUpperCase();
            }
            return Character.toLowerCase(tmp.charAt(0)) + tmp.substring(1);
        }
        return null;
    }

    protected String getGetterName(Method method) {
        boolean isGetter;
        boolean bl = isGetter = method.getName().startsWith("get") && method.getName().length() > 3 && method.getParameterCount() == 0 && !Void.TYPE.equals(method.getReturnType()) && Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers());
        if (isGetter) {
            String tmp = method.getName().replace("get", "");
            if (tmp.length() == 1) {
                return tmp.toUpperCase();
            }
            return Character.toLowerCase(tmp.charAt(0)) + tmp.substring(1);
        }
        return null;
    }

    protected String getPropFieldName(Field field) {
        if (!Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
            return null;
        }
        return field.getName();
    }
}

