/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.app;

import cn.xnatural.app.util.Copier;
import cn.xnatural.app.util.Httper;
import cn.xnatural.app.util.Tailer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    protected static final Logger log = LoggerFactory.getLogger(Utils.class);
    public static final char[] CS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    public static final SecureRandom SR = new SecureRandom();

    public static String pid() {
        return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase(Locale.UK).trim().startsWith("linux");
    }

    public static File baseDir(String child) {
        File p = new File(System.getProperty("user.dir"));
        if (child != null) {
            return new File(p, child);
        }
        return p;
    }

    public static String ipv4() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface current = en.nextElement();
                if (!current.isUp() || current.isLoopback() || current.isVirtual()) continue;
                Enumeration<InetAddress> addresses = current.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (addr.isLoopbackAddress() || !(addr instanceof Inet4Address)) continue;
                    return addr.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static byte[] sha1(byte[] bs) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(bs);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String md5Hex(byte[] bs) {
        try {
            byte[] secretBytes = MessageDigest.getInstance("md5").digest(bs);
            String md5code = new BigInteger(1, secretBytes).toString(16);
            for (int i = 0; i < 32 - md5code.length(); ++i) {
                md5code = "0" + md5code;
            }
            return md5code;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String nanoId() {
        return Utils.nanoId(21);
    }

    public static String nanoId(int length) {
        if (length < 1) {
            throw new IllegalArgumentException("Param length must >= 1");
        }
        int mask = (2 << (int)Math.floor(Math.log(CS.length - 1) / Math.log(2.0))) - 1;
        int step = (int)Math.ceil(1.6 * (double)mask * (double)length / (double)CS.length);
        StringBuilder sb = new StringBuilder();
        block0: while (true) {
            byte[] bytes = new byte[step];
            SR.nextBytes(bytes);
            int i = 0;
            while (true) {
                if (i >= step) continue block0;
                int alphabetIndex = bytes[i] & mask;
                if (alphabetIndex < CS.length) {
                    sb.append(CS[alphabetIndex]);
                    if (sb.length() == length) {
                        return sb.toString();
                    }
                }
                ++i;
            }
            break;
        }
    }

    public static <T> T to(Object v, Class<T> type) {
        if (type == null) {
            return (T)v;
        }
        if (v == null) {
            if (Boolean.TYPE.equals(type)) {
                return (T)Boolean.FALSE;
            }
            if (Short.TYPE.equals(type)) {
                return (T)Short.valueOf("0");
            }
            if (Byte.TYPE.equals(type)) {
                return (T)Byte.valueOf("0");
            }
            if (Integer.TYPE.equals(type)) {
                return (T)Integer.valueOf(0);
            }
            if (Long.TYPE.equals(type)) {
                return (T)Long.valueOf(0L);
            }
            if (Double.TYPE.equals(type)) {
                return (T)Double.valueOf(0.0);
            }
            if (Float.TYPE.equals(type)) {
                return (T)Float.valueOf(0.0f);
            }
            if (Character.TYPE.equals(type)) {
                return (T)Character.valueOf('\u0000');
            }
            return null;
        }
        if (type.isAssignableFrom(v.getClass())) {
            return (T)v;
        }
        if (String.class.equals(type)) {
            return (T)v.toString();
        }
        if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            return (T)Boolean.valueOf(v.toString());
        }
        if (Short.class.equals(type) || Short.TYPE.equals(type)) {
            return (T)Short.valueOf(v.toString());
        }
        if (Byte.class.equals(type) || Byte.TYPE.equals(type)) {
            return (T)Byte.valueOf(v.toString());
        }
        if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
            return (T)Integer.valueOf(v.toString());
        }
        if (BigInteger.class.equals(type)) {
            return (T)new BigInteger(v.toString());
        }
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            return (T)Long.valueOf(v.toString());
        }
        if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            return (T)Double.valueOf(v.toString());
        }
        if (Float.class.equals(type) || Float.TYPE.equals(type)) {
            return (T)Float.valueOf(v.toString());
        }
        if (BigDecimal.class.equals(type)) {
            return (T)new BigDecimal(v.toString());
        }
        if (URI.class.equals(type)) {
            return (T)URI.create(v.toString());
        }
        if (type.isEnum()) {
            return Arrays.stream(type.getEnumConstants()).filter(o -> v.equals(((Enum)o).name())).findFirst().orElse(null);
        }
        return (T)v;
    }

    public static void iterateMethod(Class clz, Consumer<Method> fn) {
        if (fn == null) {
            return;
        }
        Class c = clz;
        do {
            for (Method m : c.getDeclaredMethods()) {
                fn.accept(m);
            }
        } while ((c = c.getSuperclass()) != null);
    }

    public static void iterateField(Class clz, Consumer<Field> fn) {
        if (fn == null) {
            return;
        }
        Class c = clz;
        do {
            for (Field f : c.getDeclaredFields()) {
                fn.accept(f);
            }
        } while ((c = c.getSuperclass()) != null);
    }

    public static Httper http() {
        return new Httper();
    }

    public static String buildUrl(String urlStr, Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return urlStr;
        }
        String queryStr = params.entrySet().stream().map(e -> {
            try {
                return (String)e.getKey() + "=" + URLEncoder.encode(e.getValue().toString(), "utf-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }).collect(Collectors.joining("&"));
        urlStr = urlStr.endsWith("?") || urlStr.endsWith("&") ? urlStr + queryStr : (urlStr.contains("?") ? urlStr + "&" + queryStr : urlStr + "?" + queryStr);
        return urlStr;
    }

    public static Tailer tailer() {
        return new Tailer();
    }

    public static <S, T> Copier<S, T> copier(S src, T target) {
        return new Copier<S, T>(src, target);
    }

    public static long ioCopy(InputStream is, OutputStream os, Integer bufSize) throws IOException {
        byte[] buf = new byte[bufSize == null || bufSize < 1 ? 1024 : bufSize];
        long count = 0L;
        int n = 0;
        while (-1 != (n = is.read(buf))) {
            os.write(buf, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long ioCopy(InputStream is, OutputStream os) throws IOException {
        return Utils.ioCopy(is, os, 4096);
    }
}

