/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.app;

import cn.xnatural.app.AppContext;
import cn.xnatural.app.Devourer;
import cn.xnatural.app.Inject;
import cn.xnatural.app.Lazier;
import cn.xnatural.app.Utils;
import cn.xnatural.enet.event.EC;
import cn.xnatural.enet.event.EL;
import cn.xnatural.enet.event.EP;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerTpl {
    protected final Logger log = LoggerFactory.getLogger(this.getClass().getName().contains("$") ? this.getClass().getSuperclass() : this.getClass());
    protected final String name;
    @Inject
    protected EP ep;
    private final Lazier<AppContext> _app = new Lazier<AppContext>(() -> this.bean(AppContext.class));
    private final Lazier<ExecutorService> _exec = new Lazier<ExecutorService>(() -> this.bean(ExecutorService.class));
    protected Map<String, Object> beanCtx;

    public ServerTpl(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Param name required");
        }
        this.name = name;
    }

    public ServerTpl() {
        String n = this.getClass().getName().contains("$") ? this.getClass().getName() : this.getClass().getSimpleName();
        this.name = Character.toLowerCase(n.charAt(0)) + (n.length() > 1 ? n.substring(1) : "");
    }

    @EL(name={"bean.get", "{name}.bean.get"})
    protected <T> T localBean(EC ec, Class<T> bType, String bName) {
        Object bean;
        block8: {
            block7: {
                if (this.beanCtx == null) {
                    return null;
                }
                bean = null;
                if (bName == null || bType == null) break block7;
                bean = this.beanCtx.get(bName);
                if (bean == null || bType.isAssignableFrom(bean.getClass())) break block8;
                bean = null;
                break block8;
            }
            if (bName != null && bType == null) {
                bean = this.beanCtx.get(bName);
            } else if (bName == null && bType != null) {
                if (bType.isAssignableFrom(this.getClass())) {
                    bean = this;
                } else {
                    for (Map.Entry<String, Object> e : this.beanCtx.entrySet()) {
                        if (!bType.isAssignableFrom(e.getValue().getClass())) continue;
                        bean = e.getValue();
                        break;
                    }
                }
            }
        }
        return (T)bean;
    }

    protected <T> T localBean(Class<T> bType, String bName) {
        return this.localBean(null, bType, bName);
    }

    protected <T> T localBean(Class<T> bType) {
        return this.localBean(null, bType, null);
    }

    protected <T> T bean(Class<T> type, String name) {
        return (T)(this.ep == null ? null : this.ep.fire(new EC("bean.get", (Object)this).sync().args(new Object[]{type, name})));
    }

    protected <T> T bean(Class<T> type) {
        return this.bean(type, null);
    }

    public ServerTpl async(Runnable fn, Consumer<Throwable> exFn) {
        this._exec.get().execute(() -> {
            try {
                fn.run();
            }
            catch (Throwable ex) {
                if (exFn != null) {
                    exFn.accept(ex);
                }
                this.log.error("", ex);
            }
        });
        return this;
    }

    public ServerTpl async(Runnable fn) {
        return this.async(fn, null);
    }

    public Devourer queue(String qName, Runnable fn) {
        return this._app.get().queue(qName, fn);
    }

    public Devourer queue(String qName) {
        return this._app.get().queue(qName, null);
    }

    public Devourer queue(Runnable fn) {
        return this._app.get().queue(this.name, fn);
    }

    protected ServerTpl exposeBean(Object bean, String ... names) {
        if (bean == null) {
            return this;
        }
        if (this.beanCtx == null) {
            this.beanCtx = new HashMap<String, Object>(7);
        }
        if (names == null || names.length < 1) {
            String n = bean.getClass().getName().contains("$") ? bean.getClass().getName() : bean.getClass().getSimpleName();
            names = new String[]{Character.toLowerCase(n.charAt(0)) + (n.length() > 1 ? n.substring(1) : "")};
        }
        for (String n : names) {
            if (this.beanCtx.get(n) != null) {
                this.log.warn("Override exist bean name '{}'", (Object)n);
            }
            this.beanCtx.put(n, bean);
        }
        this.ep.addListenerSource(bean);
        this._app.get().inject(bean);
        return this;
    }

    public AppContext app() {
        return this._app.get();
    }

    protected ExecutorService exec() {
        return this._exec.get();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> attrs() {
        return this.app().attrs(this.name);
    }

    public ServerTpl setAttr(String aName, Object aValue) {
        this.app().env().put(this.name + "." + aName, aValue);
        return this;
    }

    public <T> T getAttr(String key, Class<T> type, T defaultValue) {
        T v;
        Object obj = null;
        for (Map.Entry<String, Object> entry : this.app().env().entrySet()) {
            if (!(this.name + "." + key).equals(entry.getKey())) continue;
            obj = entry.getValue();
            break;
        }
        if ((v = Utils.to(obj, type)) == null) {
            return defaultValue;
        }
        return v;
    }

    protected Long getLong(String key, Long defaultValue) {
        return this.getAttr(key, Long.class, defaultValue);
    }

    protected Integer getInteger(String key, Integer defaultValue) {
        return this.getAttr(key, Integer.class, defaultValue);
    }

    protected Double getDouble(String key, Double defaultValue) {
        return this.getAttr(key, Double.class, defaultValue);
    }

    protected Float getFloat(String key, Float defaultValue) {
        return this.getAttr(key, Float.class, defaultValue);
    }

    protected String getStr(String key, String defaultValue) {
        return this.getAttr(key, String.class, defaultValue);
    }

    protected Boolean getBoolean(String key, Boolean defaultValue) {
        return this.getAttr(key, Boolean.class, defaultValue);
    }
}

