/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.jpa;

import cn.xnatural.jpa.CriteriaSpec;
import cn.xnatural.jpa.ECreatable;
import cn.xnatural.jpa.ECreator;
import cn.xnatural.jpa.EDeleting;
import cn.xnatural.jpa.EUpdatable;
import cn.xnatural.jpa.EUpdater;
import cn.xnatural.jpa.EVersioning;
import cn.xnatural.jpa.IEntity;
import cn.xnatural.jpa.ImplicitNaming;
import cn.xnatural.jpa.OpHistory;
import cn.xnatural.jpa.Page;
import cn.xnatural.jpa.PhysicalNaming;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.sql.DataSource;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.metamodel.internal.MetamodelImpl;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.property.access.internal.PropertyAccessStrategyBasicImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyChainedImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyFieldImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyMapImpl;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.query.Query;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.transform.BasicTransformerAdapter;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Repo
implements AutoCloseable {
    protected static final Logger log = LoggerFactory.getLogger(Repo.class);
    protected final Map<String, Object> attrs;
    protected SessionFactory sf;
    protected DataSource datasource;
    protected final List<Class<?>> annotatedClass = new LinkedList();
    protected static final ThreadLocal<Boolean> txFlag = ThreadLocal.withInitial(() -> false);

    public Repo() {
        this((Map<String, Object>)null);
    }

    public Repo(String jdbcUrl) {
        this((Map<String, Object>)Stream.of(Collections.singletonMap("jdbcUrl", jdbcUrl)).collect(Collectors.toConcurrentMap(m -> (String)m.keySet().iterator().next(), m -> (String)m.values().iterator().next())));
    }

    public Repo(String jdbcUrl, String username, String password, Integer minIdle, Integer maxActive) {
        this((Map<String, Object>)Stream.of(Collections.singletonMap("jdbcUrl", jdbcUrl), Collections.singletonMap("minimumIdle", minIdle), Collections.singletonMap("maximumPoolSize", maxActive), Collections.singletonMap("username", username), Collections.singletonMap("password", password)).collect(Collectors.toConcurrentMap(m -> (String)m.keySet().iterator().next(), m -> (Serializable)m.values().iterator().next())));
    }

    public Repo(String jdbcUrl, String username, String password) {
        this(jdbcUrl, username, password, 1, 8);
    }

    public Repo(Map<String, Object> attrs) {
        this.attrs = attrs == null ? new ConcurrentHashMap() : attrs;
    }

    public Repo init() {
        if (this.sf != null) {
            throw new RuntimeException("Already inited");
        }
        if (this.datasource != null) {
            throw new RuntimeException("DataSource already exist");
        }
        this.datasource = Repo.createDataSource(this.attrs);
        this.sf = Repo.createSessionFactory(this.attrs, this.datasource, this.annotatedClass);
        return this;
    }

    @Override
    public void close() {
        try {
            this.sf.close();
            this.sf = null;
            this.datasource.getClass().getMethod("close", new Class[0]).invoke((Object)this.datasource, new Object[0]);
            this.datasource = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Repo setAttr(String key, Object value) {
        this.attrs.put(key, value);
        return this;
    }

    public Object getAttr(String key) {
        return this.attrs.get(key);
    }

    public Repo entities(Class<?> ... clzs) {
        if (this.sf != null) {
            throw new RuntimeException("Already inited");
        }
        if (clzs == null) {
            return this;
        }
        for (Class<?> clz : clzs) {
            if (!this.annotatedClass.stream().noneMatch(c -> c.equals(clz))) continue;
            this.annotatedClass.add(clz);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T trans(Function<Session, T> fn, Runnable okFn, Consumer<Throwable> failFn) {
        Session t;
        if (this.sf == null) {
            throw new RuntimeException("Please init first");
        }
        Session session = this.sf.getCurrentSession();
        if (txFlag.get().booleanValue()) {
            return (T)fn.apply(session);
        }
        Transaction tx = session.getTransaction();
        tx.begin();
        txFlag.set(true);
        Throwable ex = null;
        try {
            Session r = fn.apply(session);
            tx.commit();
            txFlag.set(false);
            session.close();
            t = r;
            if (ex != null) {
                if (failFn == null) return (T)t;
                failFn.accept(ex);
                return (T)t;
            }
            if (okFn == null) return (T)t;
            okFn.run();
        }
        catch (Throwable t2) {
            try {
                tx.rollback();
                txFlag.set(false);
                ex = t2;
                session.close();
                if (failFn == null) {
                    throw t2;
                }
                if (ex != null) {
                    if (failFn == null) return null;
                    failFn.accept(ex);
                    return null;
                } else {
                    if (okFn == null) return null;
                    okFn.run();
                }
                return null;
            }
            catch (Throwable throwable) {
                if (ex != null) {
                    if (failFn == null) throw throwable;
                    failFn.accept(ex);
                    throw throwable;
                } else {
                    if (okFn == null) throw throwable;
                    okFn.run();
                }
                throw throwable;
            }
        }
        return (T)t;
    }

    public <T> T trans(Function<Session, T> fn) {
        return this.trans(fn, null, null);
    }

    public <T> T doSession(Function<Session, T> fn) {
        if (txFlag.get().booleanValue()) {
            return fn.apply(this.sf.getCurrentSession());
        }
        try (Session se = this.sf.openSession();){
            T t = fn.apply(se);
            return t;
        }
    }

    public <E extends IEntity> String tbName(Class<E> eType) {
        if (this.sf == null) {
            throw new RuntimeException("Please init first");
        }
        return ((AbstractEntityPersister)((MetamodelImpl)this.sf.getMetamodel()).locateEntityPersister(eType)).getRootTableName().replace("`", "");
    }

    public String getDbName() {
        if (this.sf == null) {
            throw new RuntimeException("Please init first");
        }
        return ((SessionFactoryImpl)this.sf).getJdbcServices().getJdbcEnvironment().getCurrentCatalog().getText();
    }

    public Dialect getDialect() {
        if (this.sf == null) {
            throw new RuntimeException("Please init first");
        }
        return ((SessionFactoryImpl)this.sf).getJdbcServices().getDialect();
    }

    public String getDBVersion() {
        if (this.sf == null) {
            throw new RuntimeException("Please init first");
        }
        String dialect = this.getDialect().getClass().getSimpleName();
        if ((dialect = dialect.toLowerCase()).contains("mysql") || dialect.contains("maria")) {
            return this.row("select version()", String.class, new Object[0]);
        }
        if (dialect.contains("h2")) {
            return this.row("select H2VERSION()", String.class, new Object[0]);
        }
        return null;
    }

    public String getJdbcUrl() {
        if (this.sf == null) {
            throw new RuntimeException("Please init first");
        }
        try {
            for (PropertyDescriptor pd : Introspector.getBeanInfo(this.datasource.getClass()).getPropertyDescriptors()) {
                if (pd.getName().equals("jdbcUrl")) {
                    return (String)pd.getReadMethod().invoke((Object)this.datasource, new Object[0]);
                }
                if (!pd.getName().equals("url")) continue;
                return (String)pd.getReadMethod().invoke((Object)this.datasource, new Object[0]);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return null;
    }

    public <E extends IEntity> E saveOrUpdate(E e) {
        if (e == null) {
            throw new IllegalArgumentException("Param e required");
        }
        Date d = new Date();
        if (e instanceof ECreatable && ((ECreatable)((Object)e)).getCreateTime() == null) {
            ((ECreatable)((Object)e)).setCreateTime(d);
        }
        if (e instanceof EUpdatable) {
            ((EUpdatable)((Object)e)).setUpdateTime(d);
        }
        if (e instanceof EVersioning) {
            EVersioning v;
            v.setVersion((v = (EVersioning)((Object)e)).getVersion() == null ? 1 : v.getVersion() + 1);
        }
        return (E)this.trans(se -> {
            if (e.getId() == null) {
                se.persist((Object)e);
            } else {
                se.merge((Object)e);
            }
            if (e instanceof EVersioning) {
                EVersioning v = (EVersioning)((Object)e);
                OpHistory op = new OpHistory(e.getClass().getSimpleName(), Objects.toString(e.getId(), null), v.getVersion());
                op.setOperator(e instanceof EUpdater ? (((EUpdater)((Object)e)).getUpdater() == null ? (e instanceof ECreator ? ((ECreator)((Object)e)).getCreator() : null) : ((EUpdater)((Object)e)).getUpdater()) : null);
                op.setCreateTime(d);
                op.setContent(v.content());
                se.persist((Object)op);
            }
            return e;
        });
    }

    public <E extends IEntity> E byId(Class<E> eType, Serializable id) {
        if (eType == null) {
            throw new IllegalArgumentException("Param eType required");
        }
        return (E)this.doSession(se -> (IEntity)se.get(eType, id));
    }

    public <E extends IEntity> E byAttr(Class<E> eType, String attrName, Object attrValue) {
        if (eType == null) {
            throw new IllegalArgumentException("Param eType required");
        }
        if (attrName == null || attrName.isEmpty()) {
            throw new IllegalArgumentException("Param attrName required");
        }
        return this.row(eType, (Root<E> root, CriteriaQuery<E> query, CriteriaBuilder cb) -> {
            if (attrValue == null) {
                return cb.isNull((Expression)root.get(attrName));
            }
            return cb.equal((Expression)root.get(attrName), attrValue);
        });
    }

    public <E extends IEntity> E byAttr(Class<E> eType, String attrName1, Object attrValue1, String attrName2, Object attrValue2) {
        if (eType == null) {
            throw new IllegalArgumentException("Param eType required");
        }
        if (attrName1 == null || attrName1.isEmpty()) {
            throw new IllegalArgumentException("Param attrName1 required");
        }
        if (attrName2 == null || attrName2.isEmpty()) {
            throw new IllegalArgumentException("Param attrName2 required");
        }
        return this.row(eType, (Root<E> root, CriteriaQuery<E> query, CriteriaBuilder cb) -> cb.and((Expression)(attrValue1 == null ? cb.isNull((Expression)root.get(attrName1)) : cb.equal((Expression)root.get(attrName1), attrValue1)), (Expression)(attrValue2 == null ? cb.isNull((Expression)root.get(attrName2)) : cb.equal((Expression)root.get(attrName2), attrValue2))));
    }

    public <E extends IEntity> E row(Class<E> eType, CriteriaSpec<E, E> spec) {
        if (eType == null) {
            throw new IllegalArgumentException("Param eType required");
        }
        return (E)this.doSession(session -> {
            Object p;
            CriteriaBuilder cb = session.getCriteriaBuilder();
            CriteriaQuery query = cb.createQuery(eType);
            Root root = query.from(eType);
            Object object = p = spec == null ? null : spec.toPredicate(root, query, cb);
            if (p instanceof Predicate) {
                query.where((Expression)((Predicate)p));
            }
            return (IEntity)session.createQuery(query).setMaxResults(1).uniqueResult();
        });
    }

    public <E extends IEntity> void delete(E e) {
        if (e == null) {
            throw new IllegalArgumentException("Param e required");
        }
        this.trans(se -> {
            if (e instanceof EDeleting && e.getId() != null) {
                OpHistory history = new OpHistory(e.getClass().getSimpleName(), e.getId().toString());
                history.setOperator(e instanceof EUpdater ? (((EUpdater)((Object)e)).getUpdater() == null ? (e instanceof ECreator ? ((ECreator)((Object)e)).getCreator() : null) : ((EUpdater)((Object)e)).getUpdater()) : null);
                Date date = new Date();
                history.setCreateTime(date);
                history.setContent(((EDeleting)((Object)e)).content());
                se.persist((Object)history);
            }
            se.remove((Object)e);
            return null;
        });
    }

    public <E extends IEntity> int delete(Class<E> eType, Serializable id) {
        if (eType == null) {
            throw new IllegalArgumentException("Param eType required");
        }
        if (id == null) {
            throw new IllegalArgumentException("Param id required");
        }
        if (EDeleting.class.isAssignableFrom(eType)) {
            this.delete(this.byId(eType, id));
            return 1;
        }
        return this.trans(session -> session.createQuery("delete from " + eType.getSimpleName() + " where id=:id").setParameter("id", (Object)id).executeUpdate());
    }

    public int execute(String sql, Object ... params) {
        if (sql == null || sql.isEmpty()) {
            throw new IllegalArgumentException("Param sql required");
        }
        return this.trans(session -> this.fillParam((Query)session.createNativeQuery(sql), params).executeUpdate());
    }

    public Map<String, Object> row(String sql, Object ... params) {
        return this.row(sql, Map.class, params);
    }

    public <R> R row(String sql, Class<R> wrap, Object ... params) {
        if (sql == null || sql.isEmpty()) {
            throw new IllegalArgumentException("Param sql required");
        }
        if (wrap == null) {
            throw new IllegalArgumentException("Param warp required");
        }
        return (R)this.doSession(ses -> this.fillParam(ses.createNativeQuery(sql).setResultTransformer(this.warpTransformer(wrap)), params).setMaxResults(1).uniqueResult());
    }

    public List<Map> rows(String sql, Object ... params) {
        return this.rows(sql, Map.class, params);
    }

    public <R> List<R> rows(String sql, Class<R> wrap, Object ... params) {
        if (sql == null || sql.isEmpty()) {
            throw new IllegalArgumentException("Param sql required");
        }
        if (wrap == null) {
            throw new IllegalArgumentException("Param warp required");
        }
        return this.doSession(ses -> this.fillParam(ses.createNativeQuery(sql).setResultTransformer(this.warpTransformer(wrap)), params).list());
    }

    public Page<Map> paging(String sql, Integer page, Integer limit, Object ... params) {
        return this.paging(sql, page, limit, Map.class, params);
    }

    public <T> Page<T> paging(String sql, Integer page, Integer limit, Class<T> wrap, Object ... params) {
        if (sql == null || sql.isEmpty()) {
            throw new IllegalArgumentException("Param sql required");
        }
        if (wrap == null) {
            throw new IllegalArgumentException("Param warp required");
        }
        if (page == null || page < 1) {
            throw new IllegalArgumentException("Param page >=1");
        }
        if (limit == null || limit < 1) {
            throw new IllegalArgumentException("Param limit >=1");
        }
        return this.doSession(session -> {
            Query listQuery = this.fillParam(session.createNativeQuery(sql).setResultTransformer(this.warpTransformer(wrap)), params);
            Query countQuery = this.fillParam((Query)session.createNativeQuery("select count(1) from (" + sql + ") t1"), params);
            return new Page().setPage(page).setPageSize(limit).setList(listQuery.setFirstResult((page - 1) * limit).setMaxResults(limit.intValue()).list()).setTotalRow(((Number)countQuery.uniqueResult()).longValue());
        });
    }

    protected <T> Query<T> fillParam(Query<T> query, Object[] params) {
        if (params == null || params.length < 1) {
            return query;
        }
        if (query.getParameterMetadata().getNamedParameterNames() != null && query.getParameterMetadata().getNamedParameterNames().size() > 0) {
            for (String pName : query.getParameterMetadata().getNamedParameterNames()) {
                Object v = params[query.getParameterMetadata().getQueryParameter(pName).getPosition()];
                if (v == null) continue;
                if (v instanceof Collection) {
                    query.setParameterList(pName, (Collection)v);
                    continue;
                }
                if (v.getClass().isArray()) {
                    query.setParameterList(pName, (Object[])v);
                    continue;
                }
                query.setParameter(pName, v);
            }
        } else {
            for (int i = 0; i < params.length; ++i) {
                Object v = params[i];
                if (v == null) continue;
                if (v instanceof Collection) {
                    query.setParameterList(i + 1, (Collection)v);
                    continue;
                }
                if (v.getClass().isArray()) {
                    query.setParameterList(i + 1, (Object[])v);
                    continue;
                }
                query.setParameter(i + 1, v);
            }
        }
        return query;
    }

    protected <T> ResultTransformer warpTransformer(final Class<T> wrap) {
        if (Map.class.isAssignableFrom(wrap)) {
            return Transformers.ALIAS_TO_ENTITY_MAP;
        }
        if (wrap.getName().startsWith("java.")) {
            return new BasicTransformerAdapter(){

                public Object transformTuple(Object[] tuple, String[] aliases) {
                    if (tuple.length < 1) {
                        return null;
                    }
                    String v = tuple[0].toString();
                    if (Long.class == wrap || Long.TYPE == wrap) {
                        return Long.parseLong(v);
                    }
                    if (Integer.class == wrap || Integer.TYPE == wrap) {
                        return Integer.parseInt(v);
                    }
                    if (String.class == wrap) {
                        return v;
                    }
                    if (Boolean.class == wrap || Boolean.TYPE == wrap) {
                        return Boolean.parseBoolean(v);
                    }
                    if (Date.class == wrap) {
                        if (tuple[0] instanceof Timestamp) {
                            return new Date(((Timestamp)tuple[0]).getTime());
                        }
                        return tuple[0];
                    }
                    if (BigDecimal.class == wrap) {
                        return new BigDecimal(v);
                    }
                    if (Double.class == wrap || Double.TYPE == wrap) {
                        return Double.parseDouble(v);
                    }
                    if (Float.class == wrap || Float.TYPE == wrap) {
                        return Float.valueOf(Float.parseFloat(v));
                    }
                    if (Short.class == wrap || Short.TYPE == wrap) {
                        return Short.parseShort(v);
                    }
                    return super.transformTuple(tuple, aliases);
                }

                public List transformList(List list) {
                    return super.transformList(list);
                }
            };
        }
        return new BasicTransformerAdapter(){
            T t;
            final PropertyAccessStrategyChainedImpl pas = new PropertyAccessStrategyChainedImpl(new PropertyAccessStrategy[]{PropertyAccessStrategyBasicImpl.INSTANCE, PropertyAccessStrategyFieldImpl.INSTANCE, PropertyAccessStrategyMapImpl.INSTANCE});

            public Object transformTuple(Object[] tuple, String[] aliases) {
                try {
                    this.t = wrap.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                for (int i = 0; i < tuple.length; ++i) {
                    String alias = aliases[i];
                    if (alias == null) continue;
                    try {
                        this.pas.buildPropertyAccess(wrap, alias).getSetter().set(this.t, tuple[i], null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String aName = "";
                    for (String s : alias.split("_")) {
                        aName = aName + s.substring(0, 1).toUpperCase() + s.substring(1);
                    }
                    aName = aName.substring(0, 1).toLowerCase() + aName.substring(1);
                    try {
                        this.pas.buildPropertyAccess(wrap, aName).getSetter().set(this.t, tuple[i], null);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return this.t;
            }
        };
    }

    public <E extends IEntity> List<E> all(Class<E> eType) {
        return this.rows(eType, null, null, null);
    }

    public <E extends IEntity> List<E> rows(Class<E> eType, CriteriaSpec<E, E> spec) {
        return this.rows(eType, null, null, spec);
    }

    public <E extends IEntity> List<E> rows(Class<E> eType, String attrName, Object attrValue) {
        if (eType == null) {
            throw new IllegalArgumentException("Param eType required");
        }
        if (attrName == null || attrName.isEmpty()) {
            throw new IllegalArgumentException("Param attrName required");
        }
        return this.rows(eType, (Root<E> root, CriteriaQuery<E> query, CriteriaBuilder cb) -> {
            if (attrValue == null) {
                return cb.isNull((Expression)root.get(attrName));
            }
            return cb.equal((Expression)root.get(attrName), attrValue);
        });
    }

    public <E extends IEntity> List<E> rows(Class<E> eType, String attrName1, Object attrValue1, String attrName2, Object attrValue2) {
        if (eType == null) {
            throw new IllegalArgumentException("Param eType required");
        }
        if (attrName1 == null || attrName1.isEmpty()) {
            throw new IllegalArgumentException("Param attrName1 required");
        }
        if (attrName2 == null || attrName2.isEmpty()) {
            throw new IllegalArgumentException("Param attrName2 required");
        }
        return this.rows(eType, (Root<E> root, CriteriaQuery<E> query, CriteriaBuilder cb) -> cb.and((Expression)(attrValue1 == null ? cb.isNull((Expression)root.get(attrName1)) : cb.equal((Expression)root.get(attrName1), attrValue1)), (Expression)(attrValue2 == null ? cb.isNull((Expression)root.get(attrName2)) : cb.equal((Expression)root.get(attrName2), attrValue2))));
    }

    public <E extends IEntity> List<E> rows(Class<E> eType, Integer start, Integer limit) {
        return this.rows(eType, start, limit, null);
    }

    public <E extends IEntity> List<E> rows(Class<E> eType, Integer start, Integer limit, CriteriaSpec<E, E> spec) {
        if (eType == null) {
            throw new IllegalArgumentException("Param eType required");
        }
        if (start != null && start < 0) {
            throw new IllegalArgumentException("Param start >= 0 or not give");
        }
        if (limit != null && limit <= 0) {
            throw new IllegalArgumentException("Param limit must > 0 or not give");
        }
        return this.doSession(session -> {
            Object p;
            CriteriaBuilder cb = session.getCriteriaBuilder();
            CriteriaQuery cQuery = cb.createQuery(eType);
            Root root = cQuery.from(eType);
            Object object = p = spec == null ? null : spec.toPredicate(root, cQuery, cb);
            if (p instanceof Predicate) {
                cQuery.where((Expression)((Predicate)p));
            }
            Query query = session.createQuery(cQuery);
            if (start != null) {
                query.setFirstResult(start.intValue());
            }
            if (limit != null) {
                query.setMaxResults(limit.intValue());
            }
            return query.list();
        });
    }

    public <E extends IEntity> Page<E> paging(Class<E> eType, Integer page, Integer limit) {
        return this.paging(eType, page, limit, null);
    }

    public <E extends IEntity> Page<E> paging(Class<E> eType, Integer page, Integer limit, CriteriaSpec<E, E> listSpec) {
        return this.paging(eType, page, limit, listSpec, null);
    }

    public <E extends IEntity> Page<E> paging(Class<E> eType, Integer page, Integer limit, CriteriaSpec<E, E> listSpec, CriteriaSpec<E, Long> countSpec) {
        if (eType == null) {
            throw new IllegalArgumentException("Param eType required");
        }
        if (page == null || page < 1) {
            throw new IllegalArgumentException("Param page >=1");
        }
        if (limit == null || limit < 1) {
            throw new IllegalArgumentException("Param limit >=1");
        }
        return this.trans(session -> {
            Object p;
            CriteriaBuilder cb = session.getCriteriaBuilder();
            CriteriaQuery query = cb.createQuery(eType);
            Root root = query.from(eType);
            Object object = p = listSpec == null ? null : listSpec.toPredicate(root, query, cb);
            if (p instanceof Predicate) {
                query.where((Expression)((Predicate)p));
            }
            return new Page().setPage(page).setPageSize(limit).setList(session.createQuery(query).setFirstResult((page - 1) * limit).setMaxResults(limit.intValue()).list()).setTotalRow(this.count(eType, countSpec == null ? listSpec : countSpec));
        });
    }

    public <E extends IEntity> long count(Class<E> eType) {
        return this.count(eType, null);
    }

    public <E extends IEntity> long count(Class<E> eType, CriteriaSpec<E, Long> spec) {
        if (eType == null) {
            throw new IllegalArgumentException("Param eType required");
        }
        return this.doSession(session -> {
            Object p;
            CriteriaBuilder cb = session.getCriteriaBuilder();
            CriteriaQuery query = cb.createQuery(Long.class);
            Root root = query.from(eType);
            Object object = p = spec == null ? null : spec.toPredicate(root, query, cb);
            if (query.isDistinct()) {
                query.select((Selection)cb.countDistinct((Expression)root));
            } else {
                query.select((Selection)cb.count((Expression)root));
            }
            if (p instanceof Predicate) {
                query.where((Expression)((Predicate)p));
            }
            query.orderBy(Collections.emptyList());
            return (Long)session.createQuery(query).uniqueResult();
        });
    }

    public <E extends IEntity> long count(Class<E> eType, String attrName, Object attrValue) {
        if (eType == null) {
            throw new IllegalArgumentException("Param eType required");
        }
        if (attrName == null || attrName.isEmpty()) {
            throw new IllegalArgumentException("Param attrName required");
        }
        return this.doSession(session -> {
            CriteriaBuilder cb = session.getCriteriaBuilder();
            CriteriaQuery query = cb.createQuery(Long.class);
            Root root = query.from(eType);
            query.select((Selection)cb.count((Expression)root));
            query.where((Expression)(attrValue == null ? cb.isNull((Expression)root.get(attrName)) : cb.equal((Expression)root.get(attrName), attrValue)));
            return (Long)session.createQuery(query).uniqueResult();
        });
    }

    public <E extends IEntity> long count(Class<E> eType, String attrName1, Object attrValue1, String attrName2, Object attrValue2) {
        if (eType == null) {
            throw new IllegalArgumentException("Param eType required");
        }
        if (attrName1 == null || attrName1.isEmpty()) {
            throw new IllegalArgumentException("Param attrName1 required");
        }
        if (attrName2 == null || attrName2.isEmpty()) {
            throw new IllegalArgumentException("Param attrName2 required");
        }
        return this.doSession(session -> {
            CriteriaBuilder cb = session.getCriteriaBuilder();
            CriteriaQuery query = cb.createQuery(Long.class);
            Root root = query.from(eType);
            query.select((Selection)cb.count((Expression)root));
            query.where((Expression)cb.and((Expression)(attrValue1 == null ? cb.isNull((Expression)root.get(attrName1)) : cb.equal((Expression)root.get(attrName1), attrValue1)), (Expression)(attrValue2 == null ? cb.isNull((Expression)root.get(attrName2)) : cb.equal((Expression)root.get(attrName2), attrValue2))));
            return (Long)session.createQuery(query).uniqueResult();
        });
    }

    public <E extends IEntity> boolean exist(Class<E> eType, CriteriaSpec<E, Long> spec) {
        return this.count(eType, spec) > 0L;
    }

    public <E extends IEntity> boolean exist(Class<E> eType) {
        return this.count(eType, null) > 0L;
    }

    public <E extends IEntity> boolean exist(Class<E> eType, String attrName, Object attrValue) {
        return this.count(eType, attrName, attrValue) > 0L;
    }

    public <E extends IEntity> boolean exist(Class<E> eType, String attrName1, Object attrValue1, String attrName2, Object attrValue2) {
        return this.count(eType, attrName1, attrValue1, attrName2, attrValue2) > 0L;
    }

    public SessionFactory getSessionFactory() {
        return this.sf;
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    public List<Class<?>> entities() {
        return new LinkedList(this.annotatedClass);
    }

    public static SessionFactory createSessionFactory(Map<String, Object> attrs, final DataSource datasource, List<Class<?>> annotatedClass) {
        HashMap<String, Object> props = new HashMap<String, Object>(attrs);
        props.putIfAbsent("hibernate.physical_naming_strategy", PhysicalNaming.class);
        props.putIfAbsent("hibernate.implicit_naming_strategy", ImplicitNaming.class);
        props.putIfAbsent("hibernate.current_session_context_class", "thread");
        props.putIfAbsent("hibernate.temp.use_jdbc_metadata_defaults", "true");
        MetadataSources ms = new MetadataSources((ServiceRegistry)new StandardServiceRegistryBuilder().addService(ConnectionProvider.class, (Service)new ConnectionProvider(){

            public Connection getConnection() throws SQLException {
                return datasource.getConnection();
            }

            public void closeConnection(Connection conn) throws SQLException {
                conn.close();
            }

            public boolean supportsAggressiveRelease() {
                return true;
            }

            public boolean isUnwrappableAs(Class unwrapType) {
                return ConnectionProvider.class.equals((Object)unwrapType) || DataSource.class.isAssignableFrom(unwrapType);
            }

            public <T> T unwrap(Class<T> unwrapType) {
                if (ConnectionProvider.class.equals(unwrapType)) {
                    return (T)this;
                }
                if (DataSource.class.isAssignableFrom(unwrapType)) {
                    return (T)datasource;
                }
                throw new UnknownUnwrapTypeException(unwrapType);
            }
        }).applySettings(props).build());
        boolean hasVersioning = false;
        boolean hasDeleting = false;
        for (Class<?> clz : annotatedClass) {
            if (EVersioning.class.isAssignableFrom(clz)) {
                hasVersioning = true;
            }
            if (EDeleting.class.isAssignableFrom(clz)) {
                hasDeleting = true;
            }
            ms.addAnnotatedClass(clz);
        }
        if (hasVersioning || hasDeleting) {
            ms.addAnnotatedClass(OpHistory.class);
        }
        return ms.buildMetadata().buildSessionFactory();
    }

    public static DataSource createDataSource(Map<String, Object> dsAttr) {
        DataSource ds = null;
        try {
            Properties props = new Properties();
            dsAttr.forEach((k, v) -> {
                if (k.startsWith("hibernate")) {
                    return;
                }
                if ("url".equals(k)) {
                    props.put("jdbcUrl", v);
                } else if ("minIdle".equals(k)) {
                    props.put("minimumIdle", v);
                } else if ("maxActive".equals(k)) {
                    props.put("maximumPoolSize", v);
                } else {
                    props.put(k, v);
                }
            });
            Class<?> cfgClz = Class.forName("com.zaxxer.hikari.HikariConfig");
            ds = (DataSource)Class.forName("com.zaxxer.hikari.HikariDataSource").getConstructor(cfgClz).newInstance(cfgClz.getConstructor(Properties.class).newInstance(props));
            return ds;
        }
        catch (ClassNotFoundException props) {
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try {
            HashMap<String, String> props = new HashMap<String, String>();
            dsAttr.forEach((k, v) -> {
                if (k.startsWith("hibernate")) {
                    return;
                }
                v = Objects.toString(v, "");
                if ("jdbcUrl".equals(k)) {
                    props.put("url", (String)v);
                } else if ("minimumIdle".equals(k)) {
                    props.put("minIdle", (String)v);
                } else if ("maximumPoolSize".equals(k)) {
                    props.put("maxActive", (String)v);
                } else {
                    props.put((String)k, (String)v);
                }
            });
            if (!props.containsKey("filters")) {
                props.put("filters", "stat");
            }
            if (!props.containsKey("connectionProperties")) {
                props.put("connectionProperties", "druid.stat.logSlowSql=true;druid.stat.slowSqlMillis=5000");
            }
            if (!props.containsKey("druid.timeBetweenEvictionRunsMillis")) {
                props.put("druid.timeBetweenEvictionRunsMillis", "1800000");
            }
            ds = (DataSource)Class.forName("com.alibaba.druid.pool.DruidDataSourceFactory").getMethod("createDataSource", Map.class).invoke(null, props);
            Object v2 = props.get("druid.breakAfterAcquireFailure");
            if (v2 != null) {
                Method m = ds.getClass().getMethod("setBreakAfterAcquireFailure", Boolean.TYPE);
                m.invoke((Object)ds, Boolean.parseBoolean(v2.toString()));
            }
            return ds;
        }
        catch (ClassNotFoundException props) {
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try {
            Properties props = new Properties();
            dsAttr.forEach((k, v) -> {
                if (k.startsWith("hibernate")) {
                    return;
                }
                props.put(k, Objects.toString(v, ""));
            });
            ds = (DataSource)Class.forName("org.apache.commons.dbcp2.BasicDataSourceFactory").getMethod("createDataSource", Properties.class).invoke(null, props);
            return ds;
        }
        catch (ClassNotFoundException props) {
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        throw new RuntimeException("No found DataSource impl class");
    }
}

