/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.jpa;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Page<E> {
    private Integer page;
    private Integer pageSize;
    private Long totalRow;
    private Integer totalPage;
    private Collection<E> list;

    public static <E> Page<E> empty() {
        return new Page<E>().setPage(1).setPageSize(1).setTotalRow(0L).setList(Collections.emptyList());
    }

    public static <T, E> Page<T> of(Page<E> p1, Function<E, T> fn) {
        return new Page<E>().setPage(p1.page).setPageSize(p1.pageSize).setTotalRow(p1.totalRow).setList(p1.list.stream().map(fn::apply).collect(Collectors.toList()));
    }

    public <T> Page<T> to(Function<E, T> fn) {
        return new Page<E>().setPage(this.page).setPageSize(this.pageSize).setTotalRow(this.totalRow).setList(this.list.stream().map(fn::apply).collect(Collectors.toList()));
    }

    public Page<E> setTotalRow(Long totalRow) {
        this.totalRow = totalRow;
        if (totalRow != null) {
            this.totalPage = (int)Math.ceil((double)totalRow.longValue() / Double.valueOf(this.pageSize.intValue()));
        }
        return this;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Page<E> setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public Long getTotalRow() {
        return this.totalRow;
    }

    public Integer getTotalPage() {
        return this.totalPage;
    }

    public Page<E> setTotalPage(Integer totalPage) {
        this.totalPage = totalPage;
        return this;
    }

    public Collection<E> getList() {
        return this.list;
    }

    public Page<E> setList(Collection<E> list) {
        this.list = list;
        return this;
    }

    public Integer getPage() {
        return this.page;
    }

    public Page<E> setPage(Integer page) {
        this.page = page;
        return this;
    }

    public String toString() {
        return "Page@" + Integer.toHexString(this.hashCode()) + "{page=" + this.page + ", pageSize=" + this.pageSize + ", totalRow=" + this.totalRow + ", totalPage=" + this.totalPage + ", list=" + this.list + '}';
    }
}

