/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.jpa;

import java.io.Serializable;
import java.security.SecureRandom;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;

public class NanoIDGenerator
implements IdentifierGenerator {
    public static final int length = 21;
    public static final char[] CS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    protected static final SecureRandom SR = new SecureRandom();

    public Serializable generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        return NanoIDGenerator.nanoId(21);
    }

    public static String nanoId() {
        return NanoIDGenerator.nanoId(21, CS);
    }

    public static String nanoId(int len) {
        return NanoIDGenerator.nanoId(len, CS);
    }

    public static String nanoId(int len, char[] CS) {
        if (len < 1) {
            throw new IllegalArgumentException("Param len must >= 1");
        }
        if (CS == null || CS.length < 1) {
            throw new IllegalArgumentException("Param CS required");
        }
        int mask = (2 << (int)Math.floor(Math.log(CS.length - 1) / Math.log(2.0))) - 1;
        int step = (int)Math.ceil(1.6 * (double)mask * (double)len / (double)CS.length);
        StringBuilder sb = new StringBuilder();
        block0: while (true) {
            byte[] bytes = new byte[step];
            SR.nextBytes(bytes);
            int i = 0;
            while (true) {
                if (i >= step) continue block0;
                int idx = bytes[i] & mask;
                if (idx < CS.length) {
                    sb.append(CS[idx]);
                    if (sb.length() == len) {
                        return sb.toString();
                    }
                }
                ++i;
            }
            break;
        }
    }
}

