package cn.xnatural.jpa;


import javax.persistence.*;
import java.util.Date;

/**
 * 记录实体的变更历史
 */
@Entity
@Table(indexes = {@Index(name = "idx_createTime", columnList = "createTime")})
public class OpHistory implements IEntity, ECreator, ECreatable {
    public OpHistory() {}

    public OpHistory(String type) {
        this.type = type;
    }

    public OpHistory(Long id, String type) {
        this.id = id;
        this.type = type;
    }

    public OpHistory(Long id, String type, String dataId) {
        this.id = id;
        this.type = type;
        this.dataId = dataId;
    }

    public OpHistory(String type, String dataId) {
        this.type = type;
        this.dataId = dataId;
    }

    public OpHistory(Long id, String type, String dataId, Integer version) {
        this.id = id;
        this.type = type;
        this.dataId = dataId;
        this.version = version;
    }

    public OpHistory(String type, String dataId, Integer version) {
        this.type = type;
        this.dataId = dataId;
        this.version = version;
    }

    public OpHistory(Long id, String type, String dataId, Integer version, String operator, Date createTime) {
        this.id = id;
        this.type = type;
        this.dataId = dataId;
        this.version = version;
        this.operator = operator;
        this.createTime = createTime;
    }

    public OpHistory(String type, String dataId, Integer version, String operator) {
        this.type = type;
        this.dataId = dataId;
        this.version = version;
        this.operator = operator;
    }


    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 实体类名 {@link Class#getName()}
     */
    @Column(nullable = false)
    protected String type;
    /**
     * 数据id
     */
    @Column(nullable = false, length = 50)
    protected String dataId;
    /**
     * 版本
     */
    protected Integer version;
    /**
     * 操作员
     */
    @Column(length = 50)
    protected String operator;
    /**
     * 保存各个当前版本的数据(字段的值)
     */
    @Lob
    @Column(length = 2097151) // 2mb
    protected String content;
    /**
     * 创建时间
     */
    @Column(nullable = false)
    protected Date createTime;

    public String getType() {
        return type;
    }

    public OpHistory setType(String type) {
        this.type = type;
        return this;
    }

    public String getDataId() {
        return dataId;
    }

    public OpHistory setDataId(String dataId) {
        this.dataId = dataId;
        return this;
    }

    public Integer getVersion() {
        return version;
    }

    public OpHistory setVersion(Integer version) {
        this.version = version;
        return this;
    }

    public String getOperator() {
        return operator;
    }

    public OpHistory setOperator(String operator) {
        this.operator = operator;
        return this;
    }

    public String getContent() {
        return content;
    }

    public OpHistory setContent(String content) {
        this.content = content;
        return this;
    }

    @Override
    public Long getId() {
        return id;
    }

    public OpHistory setId(Long id) {
        this.id = id;
        return this;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String getCreator() {
        return operator;
    }
}
