package cn.xnatural.jpa;


import org.hibernate.annotations.GenericGenerator;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * nanoid 为主键的实体
 */
@MappedSuperclass
public class NanoIDEntity extends BaseEntity {
    @Id
    @GeneratedValue(generator = "nanoid")
    @GenericGenerator(name = "nanoid", strategy = "cn.xnatural.jpa.NanoIDGenerator")
    @Column(length = NanoIDGenerator.length)
    private String id;


    public String getId() { return id; }


    public NanoIDEntity setId(String id) {
        this.id = id;
        return this;
    }
}
