package cn.xnatural.jpa;

import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import java.util.Date;

/**
 * 基本实体用来被继承
 */
@MappedSuperclass
@DynamicUpdate
public abstract class BaseEntity implements IEntity, ECreatable, EUpdatable {
    /**
     * 创建时间
     */
    @Column(nullable = false)
    protected Date createTime;
    /**
     * 更新时间
     */
    @Column(nullable = false)
    protected Date updateTime;


    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}
