/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.http;

import cn.xnatural.http.WebSocket;
import java.nio.ByteBuffer;

public class WsDecoder {
    final WebSocket ws;
    protected WsMsg curMsg;

    WsDecoder(WebSocket ws) {
        this.ws = ws;
    }

    public void decode(ByteBuffer buf) throws Exception {
        if (this.curMsg == null) {
            this.curMsg = new WsMsg();
        }
        if (!this.curMsg.headComplete) {
            this.curMsg.headComplete = this.head(buf);
        }
        if (!this.curMsg.headComplete) {
            return;
        }
        if (buf.remaining() < this.curMsg.payloadLength) {
            return;
        }
        byte[] msgBs = new byte[this.curMsg.payloadLength];
        buf.get(msgBs);
        if (this.curMsg.hasMask) {
            for (int i = 0; i < msgBs.length; ++i) {
                msgBs[i] = (byte)(msgBs[i] ^ this.curMsg.mask[i % 4]);
            }
        }
        WsMsg msg = this.curMsg;
        this.curMsg = null;
        if (msg.opCode == 1) {
            if (this.ws.listener != null) {
                this.ws.listener.onText(new String(msgBs, this.ws.session.server.getCharset()));
            }
        } else if (msg.opCode == 2 && this.ws.listener != null) {
            this.ws.listener.onBinary(msgBs);
        }
        if (buf.hasRemaining()) {
            this.decode(buf);
        }
    }

    protected boolean head(ByteBuffer buf) {
        int initPosition = buf.position();
        this.curMsg.readableLength = buf.limit() - initPosition;
        this.curMsg.headLength = 2;
        if (this.curMsg.readableLength < this.curMsg.headLength + 12) {
            return false;
        }
        byte first = buf.get();
        boolean fin = (first & 0x80) > 0;
        int rsv = (first & 0x70) >>> 4;
        this.curMsg.opCode = (byte)(first & 0xF);
        if (this.curMsg.opCode != 0 && this.curMsg.opCode != 1 && this.curMsg.opCode != 2) {
            if (this.curMsg.opCode == 8) {
                this.ws.close();
                return true;
            }
            if (this.curMsg.opCode == 9 || this.curMsg.opCode == 10) {
                // empty if block
            }
        }
        this.curMsg.second = buf.get();
        boolean bl = this.curMsg.hasMask = (this.curMsg.second & 0xFF) >> 7 == 1;
        if (this.curMsg.hasMask) {
            this.curMsg.headLength += 4;
        }
        this.curMsg.payloadLength = this.curMsg.second & 0x7F;
        if (this.curMsg.payloadLength == 126) {
            this.curMsg.headLength += 2;
            if (this.curMsg.readableLength < this.curMsg.headLength) {
                return false;
            }
            this.curMsg.payloadLength = (buf.get() & 0xFF) << 8;
            this.curMsg.payloadLength |= buf.get() & 0xFF;
        } else if (this.curMsg.payloadLength == 127) {
            this.curMsg.headLength += 8;
            if (this.curMsg.readableLength < this.curMsg.headLength) {
                return false;
            }
            this.curMsg.payloadLength = (int)buf.getLong();
        }
        if (this.curMsg.payloadLength < 0 || this.curMsg.payloadLength > 524288) {
            throw new RuntimeException("body length(" + this.curMsg.payloadLength + ") is not right");
        }
        if (this.curMsg.hasMask) {
            this.curMsg.mask = new byte[4];
            buf.get(this.curMsg.mask);
        }
        this.curMsg.headComplete = true;
        return true;
    }

    protected class WsMsg {
        byte first;
        byte second;
        int headLength;
        int readableLength;
        byte opCode;
        boolean hasMask;
        byte[] mask;
        int payloadLength;
        boolean headComplete;

        protected WsMsg() {
        }
    }
}

