/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.http;

import cn.xnatural.http.HttpAioSession;
import cn.xnatural.http.WsDecoder;
import cn.xnatural.http.WsListener;
import java.nio.ByteBuffer;

public class WebSocket {
    protected HttpAioSession session;
    protected WsListener listener;
    public final WsDecoder decoder = new WsDecoder(this);

    public WebSocket(HttpAioSession session) {
        this.session = session;
    }

    public synchronized void send(String msg) {
        this.session.write(this.encode(msg));
    }

    public void close() {
        HttpAioSession se = this.session;
        this.session = null;
        se.close();
        if (this.listener != null) {
            this.listener.onClose(this);
        }
    }

    public WebSocket listen(WsListener listener) {
        this.listener = listener;
        return this;
    }

    protected ByteBuffer encode(String msg) {
        return WebSocket.encode(msg.getBytes(this.session.server.getCharset()), (byte)1);
    }

    public static ByteBuffer encode(byte[] body, byte opCode) {
        ByteBuffer buf;
        byte header0 = (byte)(0x8F & (opCode | 0xF0));
        if (body.length < 126) {
            buf = ByteBuffer.allocate(2 + body.length);
            buf.put(header0);
            buf.put((byte)body.length);
        } else if (body.length < 65535) {
            buf = ByteBuffer.allocate(4 + body.length);
            buf.put(header0);
            buf.put((byte)126);
            buf.put((byte)(body.length >>> 8));
            buf.put((byte)(body.length & 0xFF));
        } else {
            buf = ByteBuffer.allocate(10 + body.length);
            buf.put(header0);
            buf.put((byte)127);
            buf.position(buf.position() + 4);
            buf.put((byte)(body.length >>> 24));
            buf.put((byte)(body.length >>> 16));
            buf.put((byte)(body.length >>> 8));
            buf.put((byte)(body.length & 0xFF));
        }
        buf.put(body);
        buf.flip();
        return buf;
    }

    public HttpAioSession getSession() {
        return this.session;
    }
}

