/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.http;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Piece {
    final String piece;
    Pattern pattern;
    final List<String> parts = new LinkedList<String>();
    final List<String> varNames = new LinkedList<String>();

    public Piece(String piece) {
        this.piece = piece;
        this.init();
    }

    protected void init() {
        if (this.piece.contains("{") && this.piece.contains("}")) {
            StringBuilder part = new StringBuilder();
            for (int j = 0; j < this.piece.length(); ++j) {
                char c = this.piece.charAt(j);
                if ('{' == c) {
                    if (j <= 0) continue;
                    this.parts.add(part.toString());
                    part = new StringBuilder();
                    continue;
                }
                if ('}' == this.piece.charAt(j)) {
                    this.parts.add(null);
                    this.varNames.add(part.toString());
                    part = new StringBuilder();
                    continue;
                }
                part.append(c);
            }
            if (part.length() > 0) {
                this.parts.add(part.toString());
            }
        } else if (this.piece.startsWith(":")) {
            int index = this.piece.indexOf(46);
            if (index == -1) {
                this.parts.add(null);
                this.varNames.add(this.piece.substring(1));
            } else {
                this.parts.add(null);
                this.varNames.add(this.piece.substring(1, index));
                this.parts.add(this.piece.substring(index));
            }
        }
        StringBuilder reg = new StringBuilder();
        for (int i = 0; i < this.parts.size(); ++i) {
            String s = this.parts.get(i);
            if (s == null) {
                reg.append("(.*)");
                continue;
            }
            if (i == 0) {
                reg.append("^").append(s);
                continue;
            }
            if (i + 1 == this.parts.size()) {
                reg.append(s).append("$");
                continue;
            }
            reg.append(s);
        }
        if (reg.length() > 0) {
            this.pattern = Pattern.compile(reg.toString());
        }
    }

    boolean match(String str, Map<String, Object> pathTokens) {
        if (this.pattern == null) {
            if (Objects.equals(this.piece, str)) {
                return true;
            }
        } else {
            Matcher m = this.pattern.matcher(str);
            if (m.find()) {
                for (int j = 0; j < m.groupCount(); ++j) {
                    pathTokens.put(this.varNames.get(j), m.group(j + 1));
                }
                return true;
            }
        }
        return false;
    }
}

