/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.http;

import cn.xnatural.http.FilterHandler;
import cn.xnatural.http.Handler;
import cn.xnatural.http.HttpContext;
import cn.xnatural.http.Lazies;
import cn.xnatural.http.Piece;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

abstract class PathHandler
implements Handler {
    protected final Lazies<Map<String, Piece>> _pieceMap = new Lazies<Map>(() -> {
        String p = this.path();
        if (p == null) {
            throw new IllegalArgumentException("PathHandler path must not be null");
        }
        LinkedHashMap<String, Piece> result = new LinkedHashMap<String, Piece>();
        String[] pieces = null;
        pieces = "/".equals(p) ? new String[]{"/"} : Handler.extract(p).split("/");
        for (String piece : pieces) {
            result.computeIfAbsent(piece, Piece::new);
        }
        return result;
    });

    PathHandler() {
    }

    abstract String path();

    @Override
    public int compareTo(Handler h) {
        if (h instanceof FilterHandler) {
            return -1;
        }
        if (h instanceof PathHandler) {
            PathHandler other = (PathHandler)h;
            int c = this._pieceMap.get().size() - other._pieceMap.get().size();
            if (c > 0) {
                return 1;
            }
            if (c < 0) {
                return -1;
            }
            Iterator<Map.Entry<String, Piece>> it1 = this._pieceMap.get().entrySet().iterator();
            Iterator<Map.Entry<String, Piece>> it2 = other._pieceMap.get().entrySet().iterator();
            while (it1.hasNext()) {
                int constCount2;
                Map.Entry<String, Piece> e1 = it1.next();
                Map.Entry<String, Piece> e2 = it2.next();
                if (e1.getValue().pattern == null && e2.getValue().pattern != null) {
                    return 1;
                }
                if (e1.getValue().pattern != null && e2.getValue().pattern == null) {
                    return -1;
                }
                if (e1.getValue().pattern == null || e2.getValue().pattern == null) continue;
                int constCount1 = e1.getValue().parts.size() - e1.getValue().varNames.size();
                if (constCount1 > (constCount2 = e2.getValue().parts.size() - e2.getValue().varNames.size())) {
                    return 1;
                }
                if (constCount1 < constCount2) {
                    return -1;
                }
                if (e1.getValue().varNames.size() > e2.getValue().varNames.size()) {
                    return 1;
                }
                if (e1.getValue().varNames.size() >= e2.getValue().varNames.size()) continue;
                return -1;
            }
        }
        return 0;
    }

    @Override
    public String getType() {
        return PathHandler.class.getSimpleName();
    }

    @Override
    public boolean match(HttpContext hCtx) {
        if (hCtx.pieces.size() < this._pieceMap.get().size()) {
            return false;
        }
        int i = 0;
        Iterator<Map.Entry<String, Piece>> it = this._pieceMap.get().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Piece> e = it.next();
            boolean match = !it.hasNext() && hCtx.pieces.size() > this._pieceMap.get().size() ? e.getValue().match(hCtx.pieces.stream().skip(i).collect(Collectors.joining("/")), hCtx.pathToken) : e.getValue().match(hCtx.pieces.get(i), hCtx.pathToken);
            if (!match) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return this.getType() + "{" + this.path() + "}";
    }
}

