/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.http;

import java.util.function.Supplier;

class Lazies<T>
implements Supplier<T> {
    private final Supplier<T> supplier;
    private boolean once = false;
    private T result;

    public Lazies(Supplier<T> supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier is null");
        }
        this.supplier = supplier;
    }

    public void clear() {
        this.once = false;
        this.result = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (!this.once) {
            Lazies lazies = this;
            synchronized (lazies) {
                if (!this.once) {
                    this.result = this.supplier.get();
                    if (this.result != null) {
                        this.once = true;
                    }
                }
            }
        }
        return this.result;
    }

    public boolean done() {
        return this.once;
    }

    public String toString() {
        return this.result == null ? null : this.result.toString();
    }
}

