/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.http;

import cn.xnatural.http.ApiResp;
import cn.xnatural.http.Chain;
import cn.xnatural.http.ConvergeInputStream;
import cn.xnatural.http.Ctrl;
import cn.xnatural.http.FileData;
import cn.xnatural.http.Filter;
import cn.xnatural.http.HttpAioSession;
import cn.xnatural.http.HttpContext;
import cn.xnatural.http.HttpRequest;
import cn.xnatural.http.Lazies;
import cn.xnatural.http.Path;
import cn.xnatural.http.WS;
import cn.xnatural.http.WebSocket;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.charset.Charset;
import java.security.AccessControlException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServer {
    protected static final Logger log = LoggerFactory.getLogger(HttpServer.class);
    protected AsynchronousServerSocketChannel ssc;
    protected final CompletionHandler<AsynchronousSocketChannel, HttpServer> handler = new AcceptHandler();
    protected final Lazies<String> _hpCfg = new Lazies<String>(() -> this.getStr("hp", ":7070"));
    protected final Lazies<Integer> _port = new Lazies<Integer>(() -> Integer.valueOf(this._hpCfg.get().split(":")[1]));
    protected final Lazies<Charset> _charset = new Lazies<Charset>(() -> Charset.forName(this.getStr("charset", "utf-8")));
    protected final Lazies<Long> _fileMaxLength = new Lazies<Long>(() -> this.getLong("fileMaxLength", 0xC800000L));
    protected final Chain chain = new Chain(this);
    protected final List ctrls = new LinkedList();
    public boolean enabled = false;
    protected final Queue<HttpAioSession> connections = new ConcurrentLinkedQueue<HttpAioSession>();
    protected final Counter counter = new Counter();
    protected final Lazies<Set<String>> _ignoreLogSuffix = new Lazies<Set>(() -> {
        HashSet<String> set = new HashSet<String>(Arrays.asList(".js", ".css", ".html", ".vue", ".png", ".jpg", ".jpeg", ".ttf", ".woff", ".woff2", ".ico", ".map"));
        for (String suffix : this.getStr("ignoreLogUrlSuffix", "").split(",")) {
            if (suffix == null || suffix.trim().isEmpty()) continue;
            set.add(suffix.trim());
        }
        return set;
    });
    protected final Map<String, Object> attrs;
    protected final ExecutorService exec;
    protected final Map<String, FileData> pieceUploadMap = new ConcurrentHashMap<String, FileData>();

    public HttpServer(Map<String, Object> attrs, ExecutorService exec) {
        this.attrs = attrs == null ? new ConcurrentHashMap() : attrs;
        this.exec = exec == null ? new ThreadPoolExecutor(4, 8, 4L, TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            AtomicInteger i = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "http-" + this.i.getAndIncrement());
            }
        }) : exec;
    }

    public HttpServer() {
        this(null, null);
    }

    public HttpServer start() {
        if (this.ssc != null) {
            throw new RuntimeException("HttpServer is already running");
        }
        try {
            AsynchronousChannelGroup cg = AsynchronousChannelGroup.withThreadPool(this.exec);
            this.ssc = AsynchronousServerSocketChannel.open(cg);
            this.ssc.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            String host = this._hpCfg.get().split(":")[0];
            InetSocketAddress addr = host != null && !host.isEmpty() ? new InetSocketAddress(host, (int)this.getPort()) : new InetSocketAddress(this.getPort());
            this.ssc.bind(addr, this.getInteger("backlog", 128));
            this.initChain();
            this.enabled = true;
            this.exec.execute(() -> this.accept());
            log.info("Start listen HTTP(AIO) {}", (Object)this._hpCfg.get());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public void stop() {
        this.enabled = false;
        try {
            if (this.connections.size() > 2) {
                Thread.sleep(1000L);
            }
            this.ssc.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.exec.shutdown();
    }

    protected void receive(HttpRequest request) {
        block8: {
            HttpContext hCtx = null;
            try {
                this.counter.increment();
                if (this._ignoreLogSuffix.get().stream().noneMatch(suffix -> request.getPath().endsWith((String)suffix))) {
                    log.info("Start Request '{}': ({}){}. from: " + request.session.getRemoteAddress(), new Object[]{request.getId(), request.method, request.rowUrl});
                }
                hCtx = new HttpContext(request, this, this::sessionDelegate);
                if (this.enabled) {
                    if (this.connections.size() > this.getInteger("maxConnection", 128)) {
                        hCtx.response.status(503);
                        hCtx.render(ApiResp.fail("server busy, please wait..."));
                        hCtx.close();
                        return;
                    }
                    String uploadId = hCtx.request.getHeader("x-pieceupload-id");
                    try {
                        if (uploadId == null) {
                            this.chain.handle(hCtx);
                            break block8;
                        }
                        this.pieceUpload(hCtx, uploadId);
                    }
                    catch (Exception ex) {
                        this.errHandle(ex, hCtx);
                    }
                    break block8;
                }
                hCtx.response.status(503);
                hCtx.render(ApiResp.fail("server busy, please wait..."));
                hCtx.close();
            }
            catch (Exception ex) {
                log.error("Handle request error. " + request.getId(), (Throwable)ex);
                if (hCtx == null) break block8;
                hCtx.response.status(500);
                hCtx.render();
                hCtx.close();
            }
        }
    }

    protected void pieceUpload(HttpContext hCtx, String uploadId) throws Exception {
        if (uploadId == null) {
            return;
        }
        FileData convergeFd = this.pieceUploadMap.get(uploadId);
        ConvergeInputStream convergeStream = convergeFd == null ? null : (ConvergeInputStream)convergeFd.getInputStream();
        String progress = hCtx.request.getHeader("x-pieceupload-progress");
        if ("get".equalsIgnoreCase(progress)) {
            hCtx.render(ApiResp.ok().attr("uploadId", uploadId).attr("isEnd", convergeStream == null || convergeStream.isEnd()).attr("left", convergeStream == null ? 0 : convergeStream.left()));
            return;
        }
        String endStr = hCtx.request.getHeader("x-pieceupload-end");
        Boolean end = endStr != null && Boolean.valueOf(endStr) != false;
        List fds = hCtx.request.getFormParams().values().stream().filter(o -> o instanceof FileData).map(o -> (FileData)o).collect(Collectors.toList());
        if (fds.isEmpty()) {
            hCtx.render(ApiResp.fail("First upload piece is empty"));
            return;
        }
        if (convergeFd == null) {
            convergeFd = (FileData)fds.get(0);
            convergeStream = new ConvergeInputStream();
            this.pieceUploadMap.put(uploadId, convergeFd);
            convergeStream.addStream(convergeFd.getInputStream());
            convergeFd.setInputStream(convergeStream);
            convergeFd.setOriginName(hCtx.request.getHeader("x-pieceupload-filename"));
            for (int i = 1; i < fds.size(); ++i) {
                convergeStream.addStream(((FileData)fds.get(i)).getInputStream());
                convergeFd.setSize(convergeFd.getSize() == null ? 0L : convergeFd.getSize() + ((FileData)fds.get(i)).getSize());
                if (convergeFd.getSize() <= this._fileMaxLength.get()) continue;
                throw new RuntimeException("File too large");
            }
            if (end.booleanValue()) {
                convergeStream.enEnd();
            }
            hCtx.render(ApiResp.ok().attr("uploadId", uploadId).attr("fileId", convergeFd.getFinalName()).attr("isEnd", convergeStream.isEnd()).attr("left", convergeStream.left()));
            long expire = Duration.ofMinutes(this.getLong("pieceUpload.expire", 180L)).toMillis();
            Iterator<Map.Entry<String, FileData>> it = this.pieceUploadMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, FileData> e = it.next();
                ConvergeInputStream stream = (ConvergeInputStream)e.getValue().getInputStream();
                if (!stream.isEnd() && System.currentTimeMillis() - stream.createTime <= expire) continue;
                it.remove();
            }
            this.exec.execute(() -> this.chain.handle(new HttpContext(hCtx.request, this, this::sessionDelegate){

                @Override
                public void render(Object body) {
                }
            }));
        } else {
            for (FileData fd : fds) {
                if (convergeFd.getSize() > this._fileMaxLength.get()) {
                    convergeStream.ex = new RuntimeException("File too large " + this._fileMaxLength.get());
                    convergeStream.enEnd();
                    hCtx.render(ApiResp.fail(convergeStream.ex.getMessage()));
                    return;
                }
                convergeStream.addStream(fd.getInputStream());
                convergeFd.setSize(convergeFd.getSize() == null ? 0L : convergeFd.getSize() + fd.getSize());
            }
            if (end.booleanValue()) {
                convergeStream.enEnd();
            }
            hCtx.render(ApiResp.ok().attr("uploadId", uploadId).attr("fileId", convergeFd.getFinalName()).attr("isEnd", convergeStream.isEnd()).attr("left", convergeStream.left()));
        }
    }

    protected Map<String, Object> sessionDelegate(HttpContext hCtx) {
        return null;
    }

    public HttpServer ctrls(Class ... clzs) {
        if (clzs == null || clzs.length < 1) {
            return this;
        }
        try {
            for (Class clz : clzs) {
                this.ctrls.add(clz.newInstance());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Create object error.", e);
        }
        return this;
    }

    protected void initChain() {
        for (Object ctrl : this.ctrls) {
            Ctrl aCtrl = ctrl.getClass().getAnnotation(Ctrl.class);
            if (aCtrl != null) {
                if (aCtrl.prefix().isEmpty()) {
                    this.parseCtrl(ctrl, this.chain);
                    continue;
                }
                this.chain.prefix(aCtrl.prefix(), ch -> this.parseCtrl(ctrl, (Chain)ch));
                continue;
            }
            log.warn("@Ctrl Not Fund in: " + ctrl.getClass().getName());
        }
        log.trace("{}", (Object)this.chain);
    }

    protected void parseCtrl(Object ctrl, Chain chain) {
        Ctrl aCtrl = ctrl.getClass().getAnnotation(Ctrl.class);
        Consumer<Method> parser = method -> {
            Path aPath = method.getAnnotation(Path.class);
            if (aPath != null) {
                if (aPath.path().length < 1) {
                    log.error("@Path path must not be empty. {}#{}", ctrl.getClass(), (Object)method.getName());
                    return;
                }
                Parameter[] ps = method.getParameters();
                method.setAccessible(true);
                for (String path : aPath.path()) {
                    if (path == null || path.isEmpty()) {
                        log.error("@Path path must not be empty. {}#{}", (Object)ctrl.getClass().getName(), (Object)method.getName());
                        continue;
                    }
                    log.info("Request mapping{}: {}", (Object)("(" + aPath.method().toUpperCase() + ")").replace("()", ""), (Object)("/" + aCtrl.prefix() + "/" + path).replaceAll("[/]+", "/"));
                    chain.method(aPath.method(), path, aPath.consumer(), aPath.produce(), hCtx -> {
                        try {
                            Object result = method.invoke(ctrl, Arrays.stream(ps).map(p -> hCtx.param(p.getName(), p.getType())).toArray());
                            if (!Void.TYPE.isAssignableFrom(method.getReturnType())) {
                                log.debug("Invoke Handler '{}#{}', result: {}, requestId: {}", new Object[]{ctrl.getClass().getName(), method.getName(), result, hCtx.request.getId()});
                                hCtx.render(result);
                            }
                        }
                        catch (InvocationTargetException ex) {
                            throw ex.getCause();
                        }
                    });
                }
                return;
            }
            Filter aFilter = method.getAnnotation(Filter.class);
            if (aFilter != null) {
                if (!Void.TYPE.isAssignableFrom(method.getReturnType())) {
                    log.error("@Filter return type must be void. {}#{}", (Object)ctrl.getClass().getName(), (Object)method.getName());
                    return;
                }
                log.info("Request filter: {}. {}#{}", new Object[]{("/" + aCtrl.prefix()).replaceAll("[/]+", "/"), ctrl.getClass().getName(), method.getName()});
                Parameter[] ps = method.getParameters();
                method.setAccessible(true);
                chain.filter(hCtx -> {
                    try {
                        method.invoke(ctrl, Arrays.stream(ps).map(p -> hCtx.param(p.getName(), p.getType())).toArray());
                    }
                    catch (InvocationTargetException ex) {
                        throw ex.getCause();
                    }
                }, aFilter.order());
                return;
            }
            WS aWS = method.getAnnotation(WS.class);
            if (aWS != null) {
                if (!Void.TYPE.isAssignableFrom(method.getReturnType())) {
                    log.error("@WS return type must be void. {}#{}", (Object)ctrl.getClass().getName(), (Object)method.getName());
                    return;
                }
                if (method.getParameterCount() != 1 || !WebSocket.class.equals(method.getParameters()[0].getType())) {
                    log.error("@WS parameter must be WebSocket. {}#{}", (Object)ctrl.getClass().getName(), (Object)method.getName());
                    return;
                }
                method.setAccessible(true);
                log.info("WebSocket: {}", (Object)("/" + aWS.path() + "/" + aWS.path()).replaceAll("[/]+", "/"));
                chain.ws(aWS.path(), hCtx -> {
                    try {
                        hCtx.response.status(101);
                        hCtx.response.header("Upgrade", "websocket");
                        hCtx.response.header("Connection", "Upgrade");
                        byte[] bs1 = hCtx.request.getHeader("Sec-WebSocket-Key").getBytes(this.getCharset());
                        byte[] bs2 = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes(this.getCharset());
                        byte[] bs = new byte[bs1.length + bs2.length];
                        System.arraycopy(bs1, 0, bs, 0, bs1.length);
                        System.arraycopy(bs2, 0, bs, bs1.length, bs2.length);
                        hCtx.response.header("Sec-WebSocket-Accept", Base64.getEncoder().encodeToString(HttpServer.sha1(bs)));
                        hCtx.response.header("Sec-WebSocket-Location", "ws://" + this.getHp() + "/" + aCtrl.prefix() + "/" + aWS.path());
                        hCtx.render(null);
                        method.invoke(ctrl, hCtx.aioStream.ws);
                    }
                    catch (InvocationTargetException ex) {
                        log.error("", ex.getCause());
                        hCtx.close();
                    }
                });
                return;
            }
        };
        Class<?> c = ctrl.getClass();
        do {
            for (Method m : c.getDeclaredMethods()) {
                parser.accept(m);
            }
        } while ((c = c.getSuperclass()) != null);
    }

    public HttpServer buildChain(Consumer<Chain> buildFn) {
        buildFn.accept(this.chain);
        return this;
    }

    protected void errHandle(Throwable ex, HttpContext hCtx) {
        if (ex instanceof AccessControlException) {
            log.error("Request Error '" + hCtx.request.getId() + "', url: " + hCtx.request.getRowUrl() + ", " + ex.getMessage());
            hCtx.render(ApiResp.of(hCtx.response.status + "", ex.getMessage()));
            return;
        }
        log.error("Request Error '" + hCtx.request.getId() + "', url: " + hCtx.request.getRowUrl(), ex);
        hCtx.render(ApiResp.fail(ex.getClass().getSimpleName() + (ex.getMessage() != null ? ": " + ex.getMessage() : "")));
    }

    protected void accept() {
        this.ssc.accept(this, this.handler);
    }

    protected void doAccept(AsynchronousSocketChannel channel) {
        this.exec.execute(() -> {
            HttpAioSession se = null;
            try {
                channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
                channel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
                channel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
                se = new HttpAioSession(channel, this){

                    @Override
                    protected void doClose(HttpAioSession session) {
                        HttpServer.this.connections.remove(session);
                    }
                };
                this.connections.offer(se);
                log.debug("New HTTP(AIO) Connection from: " + se.getRemoteAddress() + ", connected: " + this.connections.size());
                se.start();
                if (this.connections.size() > 10) {
                    this.clean();
                }
            }
            catch (IOException e) {
                if (se != null) {
                    se.close();
                } else {
                    try {
                        channel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                log.error("Create HttpAioSession error", (Throwable)e);
            }
        });
        this.accept();
    }

    public void clean() {
        if (this.connections.isEmpty()) {
            return;
        }
        int size = this.connections.size();
        long httpExpire = Duration.ofSeconds(this.getInteger("connection.maxIdle", ((Supplier<Integer>)() -> {
            if (size > 80) {
                return 60;
            }
            if (size > 50) {
                return 120;
            }
            if (size > 30) {
                return 180;
            }
            if (size > 20) {
                return 300;
            }
            if (size > 10) {
                return 400;
            }
            return 600;
        }).get()).intValue()).toMillis();
        long wsExpire = Duration.ofSeconds(this.getInteger("wsConnection.maxIdle", ((Supplier<Integer>)() -> {
            if (size > 60) {
                return 300;
            }
            if (size > 40) {
                return 600;
            }
            if (size > 20) {
                return 1200;
            }
            return 1800;
        }).get()).intValue()).toMillis();
        int limit = ((Supplier<Integer>)() -> {
            if (size > 80) {
                return 8;
            }
            if (size > 50) {
                return 5;
            }
            if (size > 30) {
                return 3;
            }
            return 2;
        }).get();
        Iterator itt = this.connections.iterator();
        while (itt.hasNext() && limit > 0) {
            HttpAioSession se = (HttpAioSession)itt.next();
            if (se == null) {
                itt.remove();
                break;
            }
            if (!se.channel.isOpen()) {
                itt.remove();
                se.close();
                log.info("Cleaned unavailable {}: " + se + ", connected: " + this.connections.size(), (Object)(se.ws != null ? "WsAioSession" : "HttpAioSession"));
                continue;
            }
            if (se.ws != null && System.currentTimeMillis() - se.lastUsed > wsExpire) {
                --limit;
                itt.remove();
                se.ws.close();
                log.debug("Closed expired WsAioSession: " + se + ", connected: " + this.connections.size());
                continue;
            }
            if (System.currentTimeMillis() - se.lastUsed <= httpExpire) continue;
            --limit;
            itt.remove();
            se.close();
            log.debug("Closed expired HttpAioSession: " + se + ", connected: " + this.connections.size());
        }
    }

    protected String responseToJsonStr(Object resp) {
        return JSON.toJSONString((Object)resp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    protected Map<String, Object> requestJsonToMap(String jsonBody) {
        if (jsonBody == null || jsonBody.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            return Collections.unmodifiableMap(JSON.parseObject((String)jsonBody, (Feature[])new Feature[]{Feature.AllowComment, Feature.AllowSingleQuotes, Feature.OrderedField}));
        }
        catch (JSONException ex) {
            log.error("Request body is not a JSON: " + jsonBody);
            return Collections.emptyMap();
        }
    }

    protected int chunkedSize(HttpContext hCtx, int size, Class type) {
        int chunkedSize = -1;
        if (File.class.equals((Object)type)) {
            if (size > 0x100000) {
                chunkedSize = 0x100000;
            } else if (size > 81920) {
                chunkedSize = 20480;
            }
        } else if (byte[].class.equals((Object)type)) {
            if (size > 0x100000) {
                chunkedSize = 0x100000;
            } else if (size > 81920) {
                chunkedSize = 20480;
            }
        } else if (size > 0xA00000) {
            throw new RuntimeException("body too large, > 10485760");
        }
        return chunkedSize;
    }

    protected boolean auth(HttpContext hCtx, String ... permissions) {
        if (permissions == null || permissions.length < 1) {
            throw new IllegalArgumentException("Param permissions not empty");
        }
        if (!this.hasAuth(hCtx, permissions)) {
            hCtx.response.status(403);
            throw new AccessControlException("Permission denied");
        }
        return true;
    }

    protected boolean hasAuth(HttpContext hCtx, String ... permissions) {
        if (permissions == null || permissions.length < 1) {
            return false;
        }
        Set pIds = hCtx.getAttr("permissions", Set.class);
        if (pIds == null) {
            Object ps = hCtx.getSessionAttr("permissions");
            if (ps == null) {
                return false;
            }
            pIds = Arrays.stream(ps.toString().split(",")).collect(Collectors.toSet());
            hCtx.setAttr("permissions", pIds);
        }
        for (String permission : permissions) {
            if (!pIds.contains(permission)) continue;
            return true;
        }
        return false;
    }

    protected String ipv4() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface current = en.nextElement();
                if (!current.isUp() || current.isLoopback() || current.isVirtual()) continue;
                Enumeration<InetAddress> addresses = current.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (addr.isLoopbackAddress() || !(addr instanceof Inet4Address)) continue;
                    return addr.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            log.error("", (Throwable)e);
        }
        return null;
    }

    public String getHp() {
        String ip = this._hpCfg.get().split(":")[0];
        if (ip == null || ip.isEmpty() || "localhost".equals(ip)) {
            ip = this.ipv4();
        }
        return ip + ":" + this._port.get();
    }

    public Integer getPort() {
        return this._port.get();
    }

    public Charset getCharset() {
        return this._charset.get();
    }

    public List getCtrls() {
        return new LinkedList(this.ctrls);
    }

    public Object getAttr(String key) {
        return this.attrs.get(key);
    }

    public String getStr(String key, String defaultValue) {
        Object r = this.getAttr(key);
        if (r == null) {
            return defaultValue;
        }
        return r.toString();
    }

    public Integer getInteger(String key, Integer defaultValue) {
        Object r = this.getAttr(key);
        if (r == null) {
            return defaultValue;
        }
        if (r instanceof Number) {
            return ((Number)r).intValue();
        }
        return Integer.valueOf(r.toString());
    }

    public Long getLong(String key, Long defaultValue) {
        Object r = this.getAttr(key);
        if (r == null) {
            return defaultValue;
        }
        if (r instanceof Number) {
            return ((Number)r).longValue();
        }
        return Long.valueOf(r.toString());
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        Object r = this.getAttr(key);
        if (r == null) {
            return defaultValue;
        }
        if (r instanceof Boolean) {
            return (Boolean)r;
        }
        return Boolean.valueOf(r.toString());
    }

    public static byte[] sha1(byte[] bs) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(bs);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    protected void countByHour(String hour, LongAdder count) {
        log.info("{} total receive http request: {}", (Object)hour, (Object)count);
    }

    protected class Counter {
        protected Integer maxKeep = 1;
        protected final Map<String, LongAdder> hourCount = new ConcurrentHashMap<String, LongAdder>(this.maxKeep + 1);

        protected Counter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void increment() {
            SimpleDateFormat sdf = new SimpleDateFormat("MM-dd HH");
            boolean isNew = false;
            String hStr = sdf.format(new Date());
            LongAdder count = this.hourCount.get(hStr);
            if (count == null) {
                Map<String, LongAdder> map = this.hourCount;
                synchronized (map) {
                    count = this.hourCount.get(hStr);
                    if (count == null) {
                        count = new LongAdder();
                        this.hourCount.put(hStr, count);
                        isNew = true;
                    }
                }
            }
            count.increment();
            int i = 1;
            while (isNew && this.hourCount.size() > this.maxKeep) {
                Calendar cal = Calendar.getInstance();
                cal.add(11, -i);
                String lastHour = sdf.format(cal.getTime());
                LongAdder c = this.hourCount.remove(lastHour);
                if (c != null) {
                    HttpServer.this.countByHour(lastHour, c);
                }
                ++i;
            }
        }
    }

    protected class AcceptHandler
    implements CompletionHandler<AsynchronousSocketChannel, HttpServer> {
        protected AcceptHandler() {
        }

        @Override
        public void completed(AsynchronousSocketChannel channel, HttpServer srv) {
            HttpServer.this.doAccept(channel);
        }

        @Override
        public void failed(Throwable ex, HttpServer srv) {
            if (!(ex instanceof ClosedChannelException)) {
                log.error(ex.getMessage() == null ? ex.getClass().getSimpleName() : ex.getMessage(), ex);
            }
        }
    }
}

