/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.http;

import cn.xnatural.http.HttpAioSession;
import cn.xnatural.http.HttpDecoder;
import cn.xnatural.http.Lazies;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequest {
    protected static final Logger log = LoggerFactory.getLogger(HttpRequest.class);
    final Date createTime = new Date();
    protected String protocol;
    protected String method;
    protected String rowUrl;
    protected String version;
    protected String bodyStr;
    protected final Map<String, String> headers = new HashMap<String, String>();
    protected final HttpDecoder decoder = new HttpDecoder(this);
    protected HttpAioSession session;
    private final Lazies<String> _id = new Lazies<String>(() -> {
        String id = this.getHeader("X-Request-ID");
        if (id != null && !id.isEmpty()) {
            return id;
        }
        return UUID.randomUUID().toString().replace("-", "");
    });
    private final Lazies<Map<String, String>> _cookies = new Lazies<Map>(() -> {
        String cookieStr = this.getHeader("Cookie");
        if (cookieStr == null) {
            return null;
        }
        HashMap<String, String> cookies = new HashMap<String, String>();
        for (String entry : cookieStr.split(";")) {
            if (entry == null || (entry = entry.trim()).isEmpty()) continue;
            String[] arr = entry.split("=");
            cookies.put(arr[0], arr.length > 1 ? arr[1] : null);
        }
        return Collections.unmodifiableMap(cookies);
    });
    private final Lazies<String> _queryStr = new Lazies<String>(() -> {
        int i = this.rowUrl.indexOf("?");
        return i == -1 ? null : this.rowUrl.substring(i + 1);
    });
    private final Lazies<Map<String, Object>> _queryParams = new Lazies<Map>(() -> {
        if (this.getQueryStr() != null) {
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
            for (String s : this.getQueryStr().split("&")) {
                String[] arr = s.split("=");
                if (arr.length < 1) continue;
                String name = null;
                try {
                    String value;
                    name = URLDecoder.decode(arr[0], this.session.server.getCharset().toString());
                    String string = value = arr.length > 1 ? URLDecoder.decode(arr[1], this.session.server.getCharset().toString()) : null;
                    if (data.containsKey(name)) {
                        Object v = data.get(name);
                        if (v instanceof List) {
                            ((List)v).add(value);
                            continue;
                        }
                        data.put(name, new LinkedList<Object>(Arrays.asList(v, value)));
                        continue;
                    }
                    data.put(name, value);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            return Collections.unmodifiableMap(data);
        }
        return Collections.emptyMap();
    });
    private final Lazies<String> _path = new Lazies<String>(() -> {
        int i = this.rowUrl.indexOf("?");
        return i == -1 ? this.rowUrl : this.rowUrl.substring(0, i);
    });
    private final Lazies<Map<String, Object>> _formParams = new Lazies<Map>(() -> {
        String ct = this.getContentType();
        if (this.bodyStr != null && !this.bodyStr.isEmpty() && ct != null && ct.contains("application/x-www-form-urlencoded")) {
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
            for (String s : this.bodyStr.split("&")) {
                String[] arr = s.split("=");
                if (arr.length < 1) continue;
                try {
                    String value;
                    String name = URLDecoder.decode(arr[0], this.session.server.getCharset().toString());
                    String string = value = arr.length > 1 ? URLDecoder.decode(arr[1], this.session.server.getCharset().toString()) : null;
                    if (data.containsKey(name)) {
                        Object v = data.get(name);
                        if (v instanceof List) {
                            ((List)v).add(value);
                            continue;
                        }
                        data.put(name, new LinkedList<Object>(Arrays.asList(v, value)));
                        continue;
                    }
                    data.put(name, value);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            return Collections.unmodifiableMap(data);
        }
        if (ct != null && ct.contains("multipart/form-data") && this.decoder.multiForm != null) {
            return Collections.unmodifiableMap(this.decoder.multiForm);
        }
        return Collections.emptyMap();
    });
    private final Lazies<Map<String, Object>> _jsonParams = new Lazies<Map>(() -> {
        String ct = this.getContentType();
        if (this.bodyStr != null && !this.bodyStr.isEmpty() && ct != null && ct.contains("application/json")) {
            return this.session.server.requestJsonToMap(this.bodyStr);
        }
        return Collections.emptyMap();
    });

    HttpRequest(HttpAioSession session) {
        this.session = session;
    }

    public String getId() {
        return this._id.get();
    }

    public Map<String, String> getCookies() {
        return this._cookies.get();
    }

    public String getQueryStr() {
        return this._queryStr.get();
    }

    public Map<String, Object> getQueryParams() {
        return this._queryParams.get();
    }

    public String getPath() {
        return this._path.get();
    }

    public Map<String, Object> getFormParams() {
        return this._formParams.get();
    }

    public Map<String, Object> getJsonParams() {
        return this._jsonParams.get();
    }

    public String getContentType() {
        return this.getHeader("content-type");
    }

    public String getAccept() {
        return this.getHeader("Accept");
    }

    public String getAcceptEncoding() {
        return this.getHeader("Accept-Encoding");
    }

    public String getConnection() {
        return this.getHeader("Connection");
    }

    public String getHost() {
        return this.getHeader("Host");
    }

    public String getUserAgent() {
        return this.getHeader("User-Agent");
    }

    public String getUpgrade() {
        return this.getHeader("Upgrade");
    }

    public String getHeader(String hName) {
        return this.headers.get(hName.toLowerCase());
    }

    public String getCookie(String cName) {
        if (this.getCookies() == null) {
            return null;
        }
        return this.getCookies().get(cName);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getMethod() {
        return this.method;
    }

    public String getRowUrl() {
        return this.rowUrl;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBodyStr() {
        return this.bodyStr;
    }
}

