/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.http;

import cn.xnatural.http.FileData;
import cn.xnatural.http.HttpRequest;
import cn.xnatural.http.Lazies;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class HttpDecoder {
    protected HttpRequest request;
    protected long bodySize;
    protected long headerSize;
    protected boolean complete;
    protected boolean startLineComplete;
    protected boolean headerComplete;
    protected boolean bodyComplete;
    protected Part curPart;
    protected int decodeCount;
    protected boolean websocket;
    protected Map<String, Object> multiForm;
    protected final Queue<byte[]> textBodyContent = new ConcurrentLinkedQueue<byte[]>();
    protected final Lazies<String> boundary = new Lazies<String>(() -> {
        if (this.request == null) {
            return null;
        }
        String ct = this.request.getContentType();
        if (ct == null) {
            return null;
        }
        if (ct.toLowerCase().contains("multipart/form-data")) {
            return ct.split(";")[1].split("=")[1];
        }
        return null;
    });
    protected Lazies<Integer> _textBodyMaxLength = new Lazies<Integer>(() -> this.request.session.server.getInteger("textBodyMaxLength", 0xA00000));
    protected Lazies<Integer> _textPartValueMaxLength = new Lazies<Integer>(() -> this.request.session.server.getInteger("textPartValueMaxLength", 0x500000));
    protected Lazies<Integer> _filePartValueMaxLength = new Lazies<Integer>(() -> this.request.session.server.getInteger("filePartValueMaxLength", 0x1400000));

    HttpDecoder(HttpRequest request) {
        this.request = request;
    }

    protected void decode(ByteBuffer buf) throws Exception {
        ++this.decodeCount;
        if (!this.startLineComplete) {
            this.startLineComplete = this.startLine(buf);
        }
        if (this.startLineComplete && !this.headerComplete) {
            this.headerComplete = this.header(buf);
            if (this.headerComplete && "Upgrade".equalsIgnoreCase(this.request.getConnection()) && "websocket".equalsIgnoreCase(this.request.getUpgrade())) {
                this.websocket = true;
                this.bodyComplete = true;
            }
        }
        if (this.headerComplete && !this.bodyComplete) {
            this.bodyComplete = this.body(buf);
        }
        this.complete = this.bodyComplete && this.headerComplete && this.startLineComplete;
    }

    protected boolean startLine(ByteBuffer buf) throws Exception {
        String firstLine = this.readLine(buf);
        if (firstLine == null) {
            if (this.decodeCount > 1) {
                throw new Exception("HTTP start line too large");
            }
            return false;
        }
        try {
            String[] arr = firstLine.split(" ");
            this.request.method = arr[0];
            this.request.rowUrl = arr[1];
            this.request.protocol = arr[2].split("/")[0];
            this.request.version = arr[2].split("/")[1].replace("\r", "");
        }
        catch (Exception ex) {
            throw new Exception("Error http data: " + firstLine, ex);
        }
        return true;
    }

    protected boolean header(ByteBuffer buf) throws Exception {
        Long headerSizeLimit = this.request.session.server.getLong("headerSizeLimit", 0x200000L);
        while (true) {
            if (this.headerSize > headerSizeLimit) {
                throw new Exception("HTTP header too large");
            }
            int p = buf.position();
            String headerLine = this.readLine(buf);
            if (headerLine == null) {
                if (buf.remaining() != buf.limit()) break;
                throw new Exception("HTTP header item too large");
            }
            this.headerSize += (long)(buf.position() - p);
            if ("\r".equals(headerLine)) {
                return true;
            }
            int index = headerLine.indexOf(":");
            this.request.headers.put(headerLine.substring(0, index).toLowerCase(), headerLine.substring(index + 1).trim());
        }
        return false;
    }

    protected boolean body(ByteBuffer buf) throws Exception {
        String ct = this.request.getContentType();
        if (ct == null || ct.isEmpty()) {
            return true;
        }
        ct = ct.toLowerCase();
        int position = buf.position();
        if (ct.contains("application/json") || ct.contains("application/x-www-form-urlencoded") || ct.contains("text/plain")) {
            String lengthStr = this.request.getHeader("Content-Length");
            if (lengthStr != null) {
                int length = Integer.valueOf(lengthStr);
                if (length > this._textBodyMaxLength.get()) {
                    throw new Exception("text body too large");
                }
                byte[] bs = new byte[buf.remaining()];
                buf.get(bs);
                this.textBodyContent.offer(bs);
                if (this.textBodyContent.stream().mapToInt(b -> ((byte[])b).length).sum() < length) {
                    return false;
                }
                this.request.bodyStr = this.text(this.textBodyContent);
            }
            this.bodySize += (long)(buf.position() - position);
            return true;
        }
        if (ct.contains("multipart/form-data")) {
            if (this.multiForm == null) {
                this.multiForm = new HashMap<String, Object>();
            }
            boolean f = this.readMultipart(buf);
            this.bodySize += (long)(buf.position() - position);
            return f;
        }
        return false;
    }

    protected boolean readMultipart(ByteBuffer buf) throws Exception {
        boolean f;
        String boundary = "--" + this.boundary.get();
        String endLine = boundary + "--";
        if (this.curPart == null) {
            while (true) {
                String line;
                if ((line = this.readLine(buf)) == null) {
                    return false;
                }
                if ("\r".equals(line)) continue;
                if (line.equals(endLine) || line.equals(endLine + "\r")) {
                    return true;
                }
                this.curPart = new Part();
                this.curPart.boundary = line;
                boolean f2 = this.readMultipartHeader(buf);
                if (!f2) {
                    return false;
                }
                f2 = this.readMultipartValue(buf);
                if (!f2) break;
                this.curPart = null;
            }
            return false;
        }
        if (!this.curPart.headerComplete) {
            boolean f3 = this.readMultipartHeader(buf);
            if (f3) {
                return this.readMultipart(buf);
            }
        } else if (!this.curPart.valueComplete && (f = this.readMultipartValue(buf))) {
            this.curPart = null;
            f = this.readMultipart(buf);
            if (f) {
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean readMultipartHeader(ByteBuffer buf) throws Exception {
        block0: while (true) {
            if (null == (line = this.readLine(buf))) {
                if (buf.remaining() == buf.limit()) {
                    throw new Exception("HTTP multipart header item too large");
                }
                return false;
            }
            if ("\r".equals(line)) {
                this.curPart.headerComplete = true;
                return true;
            }
            if (!line.toLowerCase().contains("content-disposition")) continue;
            var3_3 = line.split(":")[1].split(";");
            var4_4 = var3_3.length;
            var5_5 = 0;
            while (true) {
                if (var5_5 < var4_4) ** break;
                continue block0;
                entry = var3_3[var5_5];
                arr = entry.split("=");
                if (arr.length > 1) {
                    if ("name".equals(arr[0].trim())) {
                        this.curPart.name = arr[1].replace("\"", "").replace("\r", "");
                    } else if ("filename".equals(arr[0].trim())) {
                        this.curPart.fileData = new FileData().setOriginName(arr[1].replace("\"", "").replace("\r", "")).setInputStream(this.curPart.valueInputStream);
                        if (this.multiForm.containsKey(this.curPart.name)) {
                            v = this.multiForm.get(this.curPart.name);
                            if (v instanceof List) {
                                ((List)v).add(this.curPart.fileData);
                            } else {
                                this.multiForm.put(this.curPart.name, new LinkedList<Object>(Arrays.asList(new Object[]{v, this.curPart.fileData})));
                            }
                        } else {
                            this.multiForm.put(this.curPart.name, this.curPart.fileData);
                        }
                    }
                }
                ++var5_5;
            }
            break;
        }
    }

    protected boolean readMultipartValue(ByteBuffer buf) throws Exception {
        int index = this.indexOf(buf, ("\r\n--" + this.boundary.get()).getBytes(this.request.session.server.getCharset()));
        if (this.curPart.fileData != null) {
            if (index == -1) {
                byte[] bs = new byte[buf.remaining()];
                buf.get(bs);
                this.curPart.addValueContent(bs);
                if (this.curPart.fileData.getSize() > (long)this._filePartValueMaxLength.get().intValue()) {
                    throw new RuntimeException("file'" + this.curPart.name + "' too large");
                }
                return false;
            }
            int length = index - buf.position();
            if (length == 0 && this.curPart.fileData.getOriginName().isEmpty()) {
                Object v = this.multiForm.remove(this.curPart.name);
                if (v instanceof List) {
                    ((List)v).remove(this.curPart.fileData);
                } else {
                    this.multiForm.put(this.curPart.name, null);
                }
            } else {
                byte[] bs = new byte[length];
                buf.get(bs);
                this.curPart.addValueContent(bs);
            }
            if (this.curPart.fileData.getSize() > (long)this._filePartValueMaxLength.get().intValue()) {
                throw new RuntimeException("file'" + this.curPart.name + "' too large");
            }
            this.curPart.valueComplete = true;
            return true;
        }
        if (index == -1) {
            byte[] bs = new byte[buf.remaining()];
            buf.get(bs);
            this.curPart.addValueContent(bs);
            if (this.curPart.valueLength() > this._textPartValueMaxLength.get()) {
                throw new RuntimeException("part '" + this.curPart.name + "' value too large");
            }
            return false;
        }
        int length = index - buf.position();
        if (length > 0) {
            byte[] bs = new byte[length];
            buf.get(bs);
            this.curPart.addValueContent(bs);
        }
        if (this.curPart.valueLength() > this._textPartValueMaxLength.get()) {
            throw new RuntimeException("part '" + this.curPart.name + "' value too large");
        }
        this.curPart.valueComplete = true;
        String value = this.curPart._textValue.get();
        if (this.multiForm.containsKey(this.curPart.name)) {
            Object v = this.multiForm.get(this.curPart.name);
            if (v instanceof List) {
                ((List)v).add(value);
            } else {
                this.multiForm.put(this.curPart.name, new LinkedList<Object>(Arrays.asList(v, value)));
            }
        } else {
            this.multiForm.put(this.curPart.name, value);
        }
        return true;
    }

    protected String readLine(ByteBuffer buf) throws Exception {
        byte[] lineDelimiter = "\n".getBytes(this.request.session.server.getCharset());
        int index = this.indexOf(buf, lineDelimiter);
        if (index == -1) {
            return null;
        }
        int readableLength = index - buf.position();
        byte[] bs = new byte[readableLength];
        buf.get(bs);
        this.bodySize += (long)readableLength;
        for (int i = 0; i < lineDelimiter.length; ++i) {
            buf.get();
        }
        this.bodySize += (long)lineDelimiter.length;
        return new String(bs, this.request.session.server.getCharset());
    }

    protected int indexOf(ByteBuffer buf, byte[] delim) {
        byte[] hb = buf.array();
        int delimIndex = -1;
        int size = buf.limit();
        for (int i = buf.position(); i < size; ++i) {
            boolean match = true;
            for (int j = 0; j < delim.length; ++j) {
                match = match && i + j < size && delim[j] == hb[i + j];
            }
            if (!match) continue;
            delimIndex = i;
            break;
        }
        return delimIndex;
    }

    protected String text(Queue<byte[]> content) {
        byte[] resultBs;
        if (content.isEmpty()) {
            return null;
        }
        if (content.size() == 1) {
            resultBs = content.poll();
        } else {
            resultBs = new byte[content.stream().mapToInt(b -> ((byte[])b).length).sum()];
            int i = 0;
            while (!content.isEmpty()) {
                byte[] bs;
                byte[] byArray = bs = content.poll();
                int n = byArray.length;
                for (int j = 0; j < n; ++j) {
                    byte b2;
                    resultBs[i] = b2 = byArray[j];
                    ++i;
                }
            }
        }
        return new String(resultBs, this.request.session.server.getCharset());
    }

    protected class Part {
        String name;
        String boundary;
        boolean headerComplete;
        boolean valueComplete;
        final Queue<byte[]> valueContent = new ConcurrentLinkedQueue<byte[]>();
        FileData fileData;
        final Lazies<String> _textValue = new Lazies<String>(() -> HttpDecoder.this.text(this.valueContent));
        final InputStream valueInputStream = new InputStream(){
            protected InputStream currentStream;

            @Override
            public int available() throws IOException {
                return this.currentStream == null ? 0 : this.currentStream.available() + Part.this.valueContent.stream().mapToInt(b -> ((byte[])b).length).sum();
            }

            @Override
            public int read() throws IOException {
                int result;
                if (this.currentStream == null) {
                    if (Part.this.valueContent.isEmpty()) {
                        return -1;
                    }
                    this.currentStream = new ByteArrayInputStream(Part.this.valueContent.poll());
                }
                if ((result = this.currentStream.read()) == -1) {
                    this.currentStream = null;
                    return this.read();
                }
                return result;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (this.currentStream != null && this.currentStream.available() >= len) {
                    return this.currentStream.read(b, off, len);
                }
                return super.read(b, off, len);
            }
        };

        protected Part() {
        }

        void addValueContent(byte[] contentPart) {
            this.valueContent.offer(contentPart);
            if (this.fileData != null) {
                this.fileData.setSize(this.fileData.getSize() == null ? 0L : this.fileData.getSize() + (long)contentPart.length);
            }
        }

        int valueLength() {
            return this.valueContent.stream().mapToInt(b -> ((byte[])b).length).sum();
        }
    }
}

