/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.http;

import cn.xnatural.http.ApiResp;
import cn.xnatural.http.FileData;
import cn.xnatural.http.Handler;
import cn.xnatural.http.HttpAioSession;
import cn.xnatural.http.HttpRequest;
import cn.xnatural.http.HttpResponse;
import cn.xnatural.http.HttpServer;
import cn.xnatural.http.Lazies;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;

public class HttpContext {
    public final HttpRequest request;
    public final HttpResponse response = new HttpResponse();
    protected final HttpAioSession aioStream;
    protected final HttpServer server;
    protected final Map<String, Object> pathToken = new LinkedHashMap<String, Object>(7);
    public final LinkedList<String> pieces = new LinkedList();
    protected final AtomicBoolean closed = new AtomicBoolean(false);
    protected final Map<String, Object> attrs = new ConcurrentHashMap<String, Object>();
    protected final Lazies<Map<String, Object>> sessionSupplier;
    protected final List<Handler> passedHandler = new LinkedList<Handler>();
    protected final List<Runnable> finishedFns = new LinkedList<Runnable>();

    HttpContext(HttpRequest request, HttpServer server, Function<HttpContext, Map<String, Object>> sessionDelegate) {
        if (request == null) {
            throw new NullPointerException("Param request required");
        }
        this.request = request;
        this.aioStream = request.session;
        this.server = server;
        this.sessionSupplier = new Lazies<Map>(() -> (Map)sessionDelegate.apply(this));
        if ("/".equals(request.getPath())) {
            this.pieces.add("/");
        } else {
            for (String piece : Handler.extract(request.getPath()).split("/")) {
                this.pieces.add(piece);
            }
            if (request.getPath().endsWith("/")) {
                this.pieces.add("/");
            }
        }
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.aioStream.close();
        }
    }

    public String getSessionId() {
        Map<String, Object> data = this.sessionSupplier.get();
        if (data == null) {
            return null;
        }
        return (String)data.get("id");
    }

    public HttpContext setAttr(String key, Object value) {
        this.attrs.put(key, value);
        return this;
    }

    public <T> HttpContext setAttr(String key, Supplier<T> supplier) {
        this.attrs.put(key, supplier);
        return this;
    }

    public <T> T getAttr(String aName, Class<T> aType) {
        Object v = this.attrs.get(aName);
        if (v instanceof Supplier) {
            v = ((Supplier)v).get();
        }
        if (aType != null) {
            return aType.cast(v);
        }
        return (T)v;
    }

    public HttpContext setSessionAttr(String aName, Object value) {
        if (this.sessionSupplier.get() == null) {
            return this;
        }
        if (value == null) {
            this.sessionSupplier.get().remove(aName);
        } else {
            this.sessionSupplier.get().put(aName, value);
        }
        return this;
    }

    public <T> HttpContext setSessionAttr(String aName, Supplier<T> value) {
        if (this.sessionSupplier.get() == null) {
            return this;
        }
        if (value == null) {
            this.sessionSupplier.get().remove(aName);
        } else {
            this.sessionSupplier.get().put(aName, value);
        }
        return this;
    }

    public Object removeSessionAttr(String aName) {
        if (this.sessionSupplier.get() == null) {
            return null;
        }
        return this.sessionSupplier.get().remove(aName);
    }

    public Object getSessionAttr(String aName) {
        if (this.sessionSupplier.get() == null) {
            return null;
        }
        Object v = this.sessionSupplier.get().get(aName);
        return v instanceof Supplier ? ((Supplier)v).get() : v;
    }

    public HttpContext regFinishedFn(Runnable fn) {
        this.finishedFns.add(fn);
        return this;
    }

    public boolean auth(String ... permissions) {
        return this.server.auth(this, permissions);
    }

    public boolean hasAuth(String ... permissions) {
        return this.server.hasAuth(this, permissions);
    }

    public void render() {
        this.render(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void render(Object body) {
        if (!this.response.commit.compareAndSet(false, true)) {
            throw new RuntimeException("Already submit response");
        }
        long spend = System.currentTimeMillis() - this.request.createTime.getTime();
        if (spend > (long)this.server.getInteger("logWarnTimeout", 5000).intValue()) {
            HttpServer.log.warn("Request timeout '" + this.request.getId() + "', path: " + this.request.getPath() + " , spend: " + spend + "ms");
        }
        try {
            if (body == null) {
                this.response.statusIfNotSet(204);
                this.response.contentLengthIfNotSet(0);
                this.aioStream.write(ByteBuffer.wrap(this.preRespBytes()));
                return;
            }
            this.response.statusIfNotSet(200);
            if (body instanceof String) {
                this.response.contentTypeIfNotSet("text/plain;charset=" + this.server.getCharset());
                this.renderBytes(((String)body).getBytes(this.server.getCharset()));
            } else if (body instanceof ApiResp) {
                this.response.contentTypeIfNotSet("application/json;charset=" + this.server.getCharset());
                ((ApiResp)body).setMark((String)this.param("mark"));
                ((ApiResp)body).setId(this.request.getId());
                this.renderBytes(this.server.responseToJsonStr(body).getBytes(this.server.getCharset()));
            } else if (body instanceof byte[]) {
                this.renderBytes((byte[])body);
            } else if (body instanceof File) {
                this.renderFile((File)body);
            } else {
                if (this.response.getContentType() == null) throw new Exception("Not support response type: " + body.getClass().getName());
                String ct = this.response.getContentType();
                if (ct.contains("application/json")) {
                    this.renderBytes(this.server.responseToJsonStr(body).getBytes(this.server.getCharset()));
                } else {
                    if (!ct.contains("text/plain")) throw new Exception("Not support response Content-Type: " + (String)ct);
                    this.renderBytes(body.toString().getBytes(this.server.getCharset()));
                }
            }
            this.determineClose();
        }
        catch (Exception ex) {
            HttpServer.log.error("Http response error", (Throwable)ex);
            this.close();
        }
        finally {
            for (Runnable fn : this.finishedFns) {
                fn.run();
            }
            return;
        }
        for (Runnable fn : this.finishedFns) {
            fn.run();
        }
        return;
    }

    protected void renderBytes(byte[] bodyBs) throws Exception {
        int chunkedSize = this.server.chunkedSize(this, bodyBs.length, byte[].class);
        if (chunkedSize < 0) {
            this.response.contentLengthIfNotSet(bodyBs.length);
            this.aioStream.write(ByteBuffer.wrap(this.preRespBytes()));
            this.aioStream.write(ByteBuffer.wrap(bodyBs));
        } else {
            this.response.transferEncoding("chunked");
            this.aioStream.write(ByteBuffer.wrap(this.preRespBytes()));
            try (ByteArrayInputStream is = new ByteArrayInputStream(bodyBs);){
                this.chunked(chunkedSize, is);
            }
        }
    }

    protected void renderFile(File file) throws Exception {
        if (!file.exists()) {
            this.response.status(404);
            HttpServer.log.warn("Request {}({}). id: {}, url: {}", new Object[]{HttpResponse.statusMsg.get(this.response.status), this.response.status, this.request.getId(), this.request.getRowUrl()});
            this.response.contentLengthIfNotSet(0);
            this.aioStream.write(ByteBuffer.wrap(this.preRespBytes()));
            this.close();
            return;
        }
        if (file.getName().endsWith(".html")) {
            this.response.contentTypeIfNotSet("text/html");
        } else if (file.getName().endsWith(".css")) {
            this.response.contentTypeIfNotSet("text/css");
        } else if (file.getName().endsWith(".js")) {
            this.response.contentTypeIfNotSet("application/javascript");
        }
        int chunkedSize = this.server.chunkedSize(this, (int)file.length(), File.class);
        if (chunkedSize < 0) {
            byte[] content = new byte[(int)file.length()];
            try (FileInputStream fis = new FileInputStream(file);){
                ((InputStream)fis).read(content);
            }
            this.response.contentLengthIfNotSet(content.length);
            this.aioStream.write(ByteBuffer.wrap(this.preRespBytes()));
            this.aioStream.write(ByteBuffer.wrap(content));
        } else {
            this.response.transferEncoding("chunked");
            this.response.contentTypeIfNotSet("application/octet-stream");
            this.aioStream.write(ByteBuffer.wrap(this.preRespBytes()));
            try (FileInputStream fis = new FileInputStream(file);){
                this.chunked(chunkedSize, fis);
            }
        }
    }

    protected void chunked(int chunkedSize, InputStream is) throws Exception {
        boolean end;
        byte[] buf = new byte[chunkedSize];
        do {
            int length;
            boolean bl = end = (length = is.read(buf)) < chunkedSize;
            if (length <= 0) continue;
            this.aioStream.write(ByteBuffer.wrap((Integer.toHexString(length) + "\r\n").getBytes(this.server.getCharset())));
            this.aioStream.write(ByteBuffer.wrap(buf, 0, length));
            this.aioStream.write(ByteBuffer.wrap("\r\n".getBytes(this.server.getCharset())));
        } while (!end);
        this.aioStream.write(ByteBuffer.wrap("0\r\n\r\n".getBytes(this.server.getCharset())));
    }

    protected byte[] preRespBytes() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("HTTP/").append(this.request.getVersion()).append(" ").append(this.response.status).append(" ").append(HttpResponse.statusMsg.get(this.response.status)).append("\r\n");
        this.response.headers.forEach((key, value) -> sb.append((String)key).append(": ").append((String)value).append("\r\n"));
        this.response.cookies.forEach((key, value) -> sb.append("Set-Cookie: ").append((String)key).append("=").append((String)value).append("\r\n"));
        return sb.append("\r\n").toString().getBytes(this.server.getCharset());
    }

    protected void determineClose() {
        String connection = this.request.getConnection();
        if (connection != null && connection.toLowerCase().contains("close")) {
            this.close();
        }
    }

    public Map<String, Object> params() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.putAll(this.request.getJsonParams());
        params.putAll(this.request.getFormParams());
        params.putAll(this.request.getQueryParams());
        params.putAll(this.pathToken);
        return params;
    }

    public Object param(String pName) {
        return this.param(pName, null);
    }

    public <T> T param(String pName, Class<T> type) {
        if (type != null && HttpContext.class.isAssignableFrom(type)) {
            return (T)this;
        }
        if (type != null && HttpServer.class.isAssignableFrom(type)) {
            return (T)this.server;
        }
        Object v = this.pathToken.get(pName);
        if (v == null) {
            v = this.request.getQueryParams().get(pName);
        }
        if (v == null) {
            v = this.request.getFormParams().get(pName);
        }
        if (v == null) {
            v = this.request.getJsonParams().get(pName);
        }
        if (v == null && type != null && type.isArray()) {
            v = this.pathToken.get(pName = pName + "[]");
            if (v == null) {
                v = this.request.getQueryParams().get(pName);
            }
            if (v == null) {
                v = this.request.getFormParams().get(pName);
            }
            if (v == null) {
                v = this.request.getJsonParams().get(pName);
            }
        }
        if (type == null) {
            return (T)v;
        }
        if (v == null) {
            return null;
        }
        if (FileData.class.isAssignableFrom(type)) {
            return (T)(v instanceof List ? ((List)v).get(0) : v);
        }
        if (FileData[].class.equals(type)) {
            Object[] objectArray;
            if (v instanceof List) {
                objectArray = ((List)v).toArray();
            } else {
                FileData[] fileDataArray = new FileData[1];
                objectArray = fileDataArray;
                fileDataArray[0] = (FileData)v;
            }
            return (T)objectArray;
        }
        if (type.isArray()) {
            LinkedList ls = new LinkedList();
            if (v instanceof List) {
                for (Object o : (List)v) {
                    ls.add(HttpContext.to(o, type.getComponentType()));
                }
                return (T)ls.toArray((Object[])Array.newInstance(type.getComponentType(), ((List)v).size()));
            }
            ls.add(HttpContext.to(v, type.getComponentType()));
            return (T)ls.toArray((Object[])Array.newInstance(type.getComponentType(), 1));
        }
        return HttpContext.to(v, type);
    }

    public static <T> T to(Object v, Class<T> type) {
        if (type == null) {
            return (T)v;
        }
        if (v == null) {
            return null;
        }
        if (type.isAssignableFrom(v.getClass())) {
            return (T)v;
        }
        if (String.class.equals(type)) {
            return (T)v.toString();
        }
        if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            return (T)Boolean.valueOf(v.toString());
        }
        if (Short.class.equals(type) || Short.TYPE.equals(type)) {
            return (T)Short.valueOf(v.toString());
        }
        if (Byte.class.equals(type) || Byte.TYPE.equals(type)) {
            return (T)Byte.valueOf(v.toString());
        }
        if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
            return (T)Integer.valueOf(v.toString());
        }
        if (BigInteger.class.equals(type)) {
            return (T)new BigInteger(v.toString());
        }
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            return (T)Long.valueOf(v.toString());
        }
        if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            return (T)Double.valueOf(v.toString());
        }
        if (Float.class.equals(type) || Float.TYPE.equals(type)) {
            return (T)Float.valueOf(v.toString());
        }
        if (BigDecimal.class.equals(type)) {
            return (T)new BigDecimal(v.toString());
        }
        if (URI.class.equals(type)) {
            return (T)URI.create(v.toString());
        }
        if (URL.class.equals(type)) {
            try {
                return (T)URI.create(v.toString()).toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        if (type.isEnum()) {
            return Arrays.stream(type.getEnumConstants()).filter(o -> v.equals(((Enum)o).name())).findFirst().orElse(null);
        }
        return (T)v;
    }
}

