/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.http;

import cn.xnatural.http.HttpRequest;
import cn.xnatural.http.HttpServer;
import cn.xnatural.http.Lazies;
import cn.xnatural.http.WebSocket;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class HttpAioSession {
    protected final AsynchronousSocketChannel channel;
    protected final ReadHandler readHandler = new ReadHandler();
    public HttpServer server;
    protected Long lastUsed = System.currentTimeMillis();
    protected final AtomicBoolean closed = new AtomicBoolean(false);
    protected final Lazies<ByteBuffer> _buf = new Lazies<ByteBuffer>(() -> ByteBuffer.allocate(this.server.getInteger("receiveMsgBufferSize", 0x100000)));
    protected WebSocket ws;
    protected HttpRequest request;
    protected final List<File> tmpFiles = new LinkedList<File>();

    HttpAioSession(AsynchronousSocketChannel channel, HttpServer server) {
        if (channel == null) {
            throw new NullPointerException("channel must not be null");
        }
        if (server == null) {
            throw new NullPointerException("server must not be null");
        }
        this.channel = channel;
        this.server = server;
    }

    void start() {
        this.read();
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.channel.shutdownOutput();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.channel.shutdownInput();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.channel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._buf.clear();
            this.tmpFiles.forEach(f -> {
                try {
                    f.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            this.doClose(this);
        }
    }

    protected void doClose(HttpAioSession session) {
    }

    public void write(ByteBuffer buf) {
        if (this.closed.get() || buf == null) {
            return;
        }
        this.lastUsed = System.currentTimeMillis();
        try {
            this.channel.write(buf).get();
        }
        catch (Exception ex) {
            if (!(ex instanceof ClosedChannelException)) {
                try {
                    HttpServer.log.error(ex.getClass().getName() + " " + this.channel.getRemoteAddress().toString() + " ->" + this.channel.getLocalAddress().toString(), (Throwable)ex);
                }
                catch (IOException e) {
                    HttpServer.log.error("", (Throwable)e);
                }
            }
            this.close();
        }
    }

    protected void read() {
        if (this.closed.get()) {
            return;
        }
        this.channel.read(this._buf.get(), this._buf.get(), this.readHandler);
    }

    protected void doRead(ByteBuffer buf) {
        if (this.ws != null) {
            try {
                this.ws.decoder.decode(buf);
            }
            catch (Exception ex) {
                HttpServer.log.error("Web socket decode error. from: " + this.getRemoteAddress(), (Throwable)ex);
                this.close();
            }
        } else {
            if (this.request == null) {
                this.request = new HttpRequest(this);
            }
            try {
                this.request.decoder.decode(buf);
            }
            catch (Exception ex) {
                HttpServer.log.error("Http decode error. from: " + this.getRemoteAddress(), (Throwable)ex);
                this.close();
                return;
            }
            if (this.request.decoder.complete) {
                if (this.request.decoder.websocket) {
                    this.ws = new WebSocket(this);
                    this.server.receive(this.request);
                } else {
                    HttpRequest req = this.request;
                    this.request = null;
                    this.server.receive(req);
                }
            }
        }
    }

    public String getRemoteAddress() {
        try {
            return this.channel.getRemoteAddress().toString();
        }
        catch (IOException e) {
            HttpServer.log.error("", (Throwable)e);
            return null;
        }
    }

    public String getLocalAddress() {
        try {
            return this.channel.getLocalAddress().toString();
        }
        catch (IOException e) {
            HttpServer.log.error("", (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return HttpAioSession.class.getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "[" + this.channel.toString() + "]";
    }

    protected class ReadHandler
    implements CompletionHandler<Integer, ByteBuffer> {
        protected ReadHandler() {
        }

        @Override
        public void completed(Integer count, ByteBuffer buf) {
            if (count > 0) {
                HttpAioSession.this.lastUsed = System.currentTimeMillis();
                buf.flip();
                HttpAioSession.this.doRead(buf);
                buf.compact();
                HttpAioSession.this.read();
            } else if (!HttpAioSession.this.channel.isOpen()) {
                HttpAioSession.this.close();
            }
        }

        @Override
        public void failed(Throwable ex, ByteBuffer buf) {
            if (!(ex instanceof ClosedChannelException)) {
                try {
                    HttpServer.log.error(ex.getClass().getSimpleName() + " " + HttpAioSession.this.channel.getLocalAddress().toString() + " ->" + HttpAioSession.this.channel.getRemoteAddress().toString(), ex);
                }
                catch (IOException e) {
                    HttpServer.log.error("", (Throwable)e);
                }
            }
            HttpAioSession.this.close();
        }
    }
}

