/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import java.util.function.Supplier;

public class FileData {
    private String originName;
    private String finalName;
    private transient InputStream inputStream;
    private transient File file;
    private Long size;
    private String extension;

    public FileData setOriginName(String fName) {
        String extension;
        this.originName = fName;
        this.extension = extension = FileData.extractFileExtension(fName);
        String id = UUID.randomUUID().toString().replace("-", "");
        this.finalName = extension.isEmpty() ? id : id + '.' + extension;
        return this;
    }

    public static String extractFileExtension(String fileName) {
        if (fileName == null) {
            return "";
        }
        int i = fileName.lastIndexOf(".");
        if (i == -1) {
            return "";
        }
        return fileName.substring(i + 1);
    }

    public File transferTo(File dir) throws Exception {
        if (dir == null) {
            throw new IllegalArgumentException("Param dir required");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Param dir must be a directory");
        }
        dir.mkdirs();
        File target = new File(dir, this.finalName);
        if (!target.exists()) {
            target.createNewFile();
        }
        byte[] bs = new byte[((Supplier<Integer>)() -> {
            if (this.size > 0x6400000L) {
                return 0xA00000;
            }
            if (this.size > 0x3200000L) {
                return 0x600000;
            }
            if (this.size > 0xA00000L) {
                return 0x100000;
            }
            if (this.size > 0x500000L) {
                return 614400;
            }
            if (this.size > 0x100000L) {
                return 204800;
            }
            return 20480;
        }).get().intValue()];
        try (FileOutputStream fos = new FileOutputStream(target);){
            int length;
            while ((length = this.getInputStream().read(bs)) != -1) {
                ((OutputStream)fos).write(bs, 0, length);
            }
        }
        return target;
    }

    public File appendTo(File targetFile) throws Exception {
        if (targetFile == null) {
            throw new IllegalArgumentException("Param targetFile required");
        }
        if (targetFile.isDirectory()) {
            throw new IllegalArgumentException("Param targetFile must be a file");
        }
        if (!targetFile.exists()) {
            targetFile.getParentFile().mkdirs();
            targetFile.createNewFile();
        }
        byte[] bs = new byte[((Supplier<Integer>)() -> {
            if (this.size > 0x6400000L) {
                return 0xA00000;
            }
            if (this.size > 0x3200000L) {
                return 0x600000;
            }
            if (this.size > 0xA00000L) {
                return 0x100000;
            }
            if (this.size > 0x500000L) {
                return 614400;
            }
            if (this.size > 0x100000L) {
                return 204800;
            }
            return 20480;
        }).get().intValue()];
        try (FileOutputStream fos = new FileOutputStream(targetFile, true);){
            int length;
            while ((length = this.getInputStream().read(bs)) != -1) {
                ((OutputStream)fos).write(bs, 0, length);
            }
        }
        return targetFile;
    }

    public void delete() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.inputStream = null;
        this.size = null;
        if (this.file != null) {
            this.file.delete();
        }
    }

    public String toString() {
        return FileData.class.getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "[finalName=" + this.finalName + ", originName=" + this.originName + ", size=" + this.size + ", extension=" + this.extension + "]";
    }

    public String getOriginName() {
        return this.originName;
    }

    public String getFinalName() {
        return this.finalName;
    }

    public FileData setFinalName(String finalName) {
        this.finalName = finalName;
        return this;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        if (this.inputStream == null && this.file != null) {
            this.inputStream = new FileInputStream(this.file);
        }
        return this.inputStream;
    }

    public FileData setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public Long getSize() {
        return this.size;
    }

    public FileData setSize(Long size) {
        this.size = size;
        return this;
    }

    public String getExtension() {
        return this.extension;
    }

    public FileData setExtension(String extension) {
        this.extension = extension;
        return this;
    }

    public File getFile() {
        return this.file;
    }

    public FileData setFile(File file) {
        this.file = file;
        this.setSize(file.length());
        return this;
    }
}

