/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.http;

import cn.xnatural.http.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ConvergeInputStream
extends InputStream {
    protected long readCount = 0L;
    protected final Queue<InputStream> streamQueue = new ConcurrentLinkedQueue<InputStream>();
    protected InputStream currentStream;
    protected boolean enEnd;
    final Long createTime = System.currentTimeMillis();
    protected RuntimeException ex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        int result;
        if (this.ex != null) {
            throw this.ex;
        }
        if (this.isEnd()) {
            return -1;
        }
        if (this.currentStream == null && this.streamQueue.isEmpty()) {
            ConvergeInputStream convergeInputStream = this;
            synchronized (convergeInputStream) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.currentStream == null) {
            this.currentStream = this.streamQueue.poll();
        }
        if ((result = this.currentStream.read()) == -1) {
            this.currentStream = null;
            return this.read();
        }
        ++this.readCount;
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.currentStream != null && this.currentStream.available() >= len) {
            this.readCount += (long)len;
            return this.currentStream.read(b, off, len);
        }
        return super.read(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConvergeInputStream addStream(InputStream stream) {
        if (stream == null) {
            throw new NullPointerException("Param stream required");
        }
        if (this.isEnd()) {
            throw new RuntimeException("Already end");
        }
        this.streamQueue.offer(stream);
        ConvergeInputStream convergeInputStream = this;
        synchronized (convergeInputStream) {
            this.notify();
        }
        return this;
    }

    @Override
    public int available() throws IOException {
        return this.currentStream == null ? 0 : this.currentStream.available() + this.streamQueue.stream().mapToInt(stream -> {
            try {
                return stream.available();
            }
            catch (IOException e) {
                HttpServer.log.error("", (Throwable)e);
                return 0;
            }
        }).sum();
    }

    public boolean isEnd() {
        return this.enEnd && this.currentStream == null && this.streamQueue.isEmpty();
    }

    public int left() {
        return this.streamQueue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enEnd() {
        this.enEnd = true;
        ConvergeInputStream convergeInputStream = this;
        synchronized (convergeInputStream) {
            this.notify();
        }
    }

    public long getReadCount() {
        return this.readCount;
    }
}

