/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.http;

import cn.xnatural.http.FilterHandler;
import cn.xnatural.http.Handler;
import cn.xnatural.http.HttpContext;
import cn.xnatural.http.HttpResponse;
import cn.xnatural.http.HttpServer;
import cn.xnatural.http.PathHandler;
import cn.xnatural.http.Piece;
import cn.xnatural.http.WSHandler;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Chain {
    protected static final Logger log = LoggerFactory.getLogger(Chain.class);
    protected final LinkedList<Handler> handlers = new LinkedList();
    protected final HttpServer server;
    protected final Map<String, Chain> subChains = new ConcurrentHashMap<String, Chain>(7);

    public Chain(HttpServer server) {
        this.server = server;
    }

    protected void handle(HttpContext hCtx) {
        boolean match = false;
        for (Handler h : this.handlers) {
            if (h instanceof FilterHandler) {
                try {
                    hCtx.passedHandler.add(h);
                    h.handle(hCtx);
                }
                catch (Throwable ex) {
                    this.server.errHandle(ex, hCtx);
                }
            } else if (h instanceof PathHandler) {
                match = h.match(hCtx);
                log.trace("{} {}, {}", new Object[]{match ? "Matched" : "Unmatch", ((PathHandler)h).path(), hCtx.request.getPath()});
                if (match) {
                    try {
                        hCtx.passedHandler.add(h);
                        h.handle(hCtx);
                    }
                    catch (Throwable ex) {
                        this.server.errHandle(ex, hCtx);
                    }
                    break;
                }
            } else {
                throw new RuntimeException("Unknown Handler type: " + h.getClass().getName());
            }
            if (!hCtx.response.commit.get()) continue;
            break;
        }
        if (hCtx.response.commit.get()) {
            return;
        }
        if (!match) {
            hCtx.response.statusIfNotSet(404);
            log.warn("Request {}({}). id: {}, url: {}", new Object[]{HttpResponse.statusMsg.get(hCtx.response.status), hCtx.response.status, hCtx.request.getId(), hCtx.request.getRowUrl()});
            hCtx.render();
            hCtx.close();
        } else if (hCtx.response.status != null) {
            log.warn("Request {}({}). id: {}, url: {}", new Object[]{HttpResponse.statusMsg.get(hCtx.response.status), hCtx.response.status, hCtx.request.getId(), hCtx.request.getRowUrl()});
            hCtx.render();
        }
    }

    protected Chain add(Handler handler) {
        if (this.handlers.isEmpty()) {
            this.handlers.add(handler);
            return this;
        }
        ListIterator<Handler> it = this.handlers.listIterator();
        while (it.hasNext()) {
            Handler h = (Handler)it.next();
            if (handler.compareTo(h) > 0) {
                if (it.hasPrevious()) {
                    it.previous();
                    it.add(handler);
                    break;
                }
                this.handlers.offerFirst(handler);
                break;
            }
            if (it.hasNext()) continue;
            it.add(handler);
            break;
        }
        return this;
    }

    public Chain method(final String method, final String path, final String[] contentTypes, final String produce, final Handler handler) {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("path mut not be empty");
        }
        if (contentTypes != null && contentTypes.length > 0 && Arrays.stream(contentTypes).anyMatch(s -> s == null || s.isEmpty())) {
            throw new IllegalArgumentException("@Path consumer config error");
        }
        return this.add(new PathHandler(){

            @Override
            public void handle(HttpContext ctx) throws Throwable {
                handler.handle(ctx);
            }

            @Override
            String path() {
                return path;
            }

            @Override
            public boolean match(HttpContext hCtx) {
                boolean matched = super.match(hCtx);
                if (!matched) {
                    return false;
                }
                if (method != null && !method.isEmpty() && !method.equalsIgnoreCase(hCtx.request.method)) {
                    hCtx.response.status(405);
                    hCtx.pathToken.clear();
                    return false;
                }
                if (contentTypes != null && contentTypes.length > 0) {
                    boolean f = false;
                    String ct = hCtx.request.getContentType();
                    if (ct != null) {
                        for (String contentType : contentTypes) {
                            if (!contentType.split(";")[0].equalsIgnoreCase(ct.split(";")[0])) continue;
                            f = true;
                            break;
                        }
                    }
                    if (!f) {
                        hCtx.response.status(415);
                        hCtx.pathToken.clear();
                        return false;
                    }
                }
                if (hCtx.response.status != null && (415 == hCtx.response.status || 405 == hCtx.response.status)) {
                    hCtx.response.status = null;
                }
                if (produce != null && !produce.isEmpty()) {
                    hCtx.response.contentType(produce);
                }
                return true;
            }
        });
    }

    public Chain ws(final String path, final Handler handler) {
        return this.add(new WSHandler(){

            @Override
            public void handle(HttpContext ctx) throws Throwable {
                handler.handle(ctx);
            }

            @Override
            String path() {
                return path;
            }
        });
    }

    public Chain filter(final Handler handler, final int order) {
        return this.add(new FilterHandler(){

            @Override
            public void handle(HttpContext ctx) throws Throwable {
                handler.handle(ctx);
            }

            @Override
            public int getOrder() {
                return order;
            }
        });
    }

    public Chain path(String path, Handler handler) {
        return this.method(null, path, null, null, handler);
    }

    public Chain get(String path, Handler handler) {
        return this.method("get", path, null, null, handler);
    }

    public Chain post(String path, Handler handler) {
        return this.method("post", path, null, null, handler);
    }

    public Chain delete(String path, Handler handler) {
        return this.method("delete", path, null, null, handler);
    }

    public Chain prefix(String prefix, Consumer<Chain> handlerBuilder) {
        Chain subChain = this;
        for (final String singlePrefix : Handler.extract(prefix).split("/")) {
            Chain parentChain = subChain;
            final Chain finalSubChain = subChain = subChain.subChains.computeIfAbsent(singlePrefix, s -> new Chain(this.server));
            parentChain.add(new PathHandler(){
                final Chain chain;
                {
                    this.chain = finalSubChain;
                }

                @Override
                String path() {
                    return singlePrefix;
                }

                @Override
                public boolean match(HttpContext hCtx) {
                    Map.Entry e = ((Map)this._pieceMap.get()).entrySet().iterator().next();
                    if (((Piece)e.getValue()).match(hCtx.pieces.get(0), hCtx.pathToken)) {
                        hCtx.pieces.pop();
                        return true;
                    }
                    return false;
                }

                @Override
                public void handle(HttpContext hCtx) {
                    this.chain.handle(hCtx);
                }

                @Override
                public String toString() {
                    return "\n\t" + this.getType() + "{" + this.path() + " -> " + this.chain + "}\n";
                }
            });
        }
        handlerBuilder.accept(subChain);
        return this;
    }

    public String toString() {
        return "Chain{\n\t" + this.handlers + "}";
    }
}

