/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.http;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class ApiResp<T>
implements Serializable {
    public static String OK_CODE = "00";
    public static String FAIL_CODE = "01";
    private String code;
    private T data;
    private String msg;
    private String id;
    private String mark;

    public static <T> ApiResp<T> ok() {
        return new ApiResp<T>().setCode(OK_CODE);
    }

    public static <T> ApiResp<T> ok(T data) {
        return new ApiResp<T>().setCode(OK_CODE).setData(data);
    }

    public static <T> ApiResp<T> of(String code, String desc) {
        return new ApiResp<T>().setCode(code).setMsg(desc);
    }

    public static <T> ApiResp<T> fail(String errMsg) {
        return new ApiResp<T>().setCode(FAIL_CODE).setMsg(errMsg);
    }

    public ApiResp<Map<String, Object>> attr(String attrName, Object attrValue) {
        if (this.data == null) {
            this.data = new LinkedHashMap();
        }
        if (!(this.data instanceof Map)) {
            throw new IllegalArgumentException("data\u7c7b\u578b\u5fc5\u987b\u4e3aMap\u7c7b\u578b");
        }
        ((Map)this.data).put(attrName, attrValue);
        return this;
    }

    public ApiResp<Map<String, Object>> attrs(Map<String, Object> attrs) {
        attrs.forEach((s, o) -> this.attr((String)s, o));
        return this;
    }

    public ApiResp<T> desc(String desc) {
        this.msg = desc;
        return this;
    }

    public String toString() {
        return ApiResp.class.getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "[code=" + this.code + ", traceNo=" + this.id + ", desc=" + this.msg + ", mark: " + this.mark + ", data=" + this.data + "]";
    }

    public String getCode() {
        return this.code;
    }

    public ApiResp<T> setCode(String code) {
        this.code = code;
        return this;
    }

    public T getData() {
        return this.data;
    }

    public ApiResp<T> setData(T data) {
        this.data = data;
        return this;
    }

    public String getMsg() {
        return this.msg;
    }

    public ApiResp<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public ApiResp<T> setId(String id) {
        this.id = id;
        return this;
    }

    public String getMark() {
        return this.mark;
    }

    public ApiResp<T> setMark(String mark) {
        this.mark = mark;
        return this;
    }
}

