/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.enet.core;

import cn.xnatural.enet.common.Log;
import cn.xnatural.enet.common.Utils;
import cn.xnatural.enet.event.EC;
import cn.xnatural.enet.event.EL;
import cn.xnatural.enet.event.EP;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public class Environment {
    public static final String PROP_ACTIVE = "enet.profile.active";
    protected Log log = Log.of(Environment.class);
    protected EP ep;
    protected final List<String> cfgFileLocations = new LinkedList<String>();
    protected List<String> cfgFileNames = new LinkedList<String>();
    protected final Map<String, String> finalAttrs = new ConcurrentHashMap<String, String>();
    protected final Map<String, String> runtimeAttrs = new ConcurrentHashMap<String, String>(7);
    protected final Map<String, Map<String, String>> locationSources = new LinkedHashMap<String, Map<String, String>>();
    protected final Map<String, Map<String, String>> profileSources = new LinkedHashMap<String, Map<String, String>>();
    protected final Set<String> allProfiles = new HashSet<String>(7);
    protected final Set<String> activeProfiles = new LinkedHashSet<String>(5);
    protected Pattern p = Pattern.compile("(\\$\\{(?<attr>[\\w\\._]+)\\})+");

    public Environment(EP ep) {
        if (ep == null) {
            throw new IllegalArgumentException("ep must not be null");
        }
        this.ep = ep;
        ep.addListenerSource((Object)this);
        this.init();
    }

    protected void init() {
        this.cfgFileLocations.add("classpath:/");
        this.cfgFileLocations.add("classpath:/config/");
        this.cfgFileLocations.add("file:./");
        this.cfgFileLocations.add("file:./config/");
        String p = System.getProperty("enet.cfgFileLocations");
        if (p != null && !p.isEmpty()) {
            for (String s : p.split(",")) {
                if (s == null || s.trim().isEmpty()) continue;
                this.cfgFileLocations.add(s.trim());
            }
        }
        this.cfgFileNames.add("application");
        p = System.getProperty("enet.cfgFileName");
        if (p != null && !p.isEmpty()) {
            for (String s : p.split(",")) {
                if (s == null || s.trim().isEmpty()) continue;
                this.cfgFileNames.add(s.trim());
            }
        }
        if (Utils.isNotEmpty((String)System.getProperty(PROP_ACTIVE))) {
            this.allProfiles.addAll(Arrays.asList(System.getProperty(PROP_ACTIVE).split(",")));
        }
    }

    protected void loadCfg() {
        this.log.trace("start loading configuration file", new Object[0]);
        for (String l : this.cfgFileLocations) {
            if (l == null || l.isEmpty()) continue;
            for (String n : this.cfgFileNames) {
                this.loadPropertiesFile(null, l, n);
            }
        }
        HashSet<String> loadedProfiles = new HashSet<String>();
        while (this.allProfiles.size() > loadedProfiles.size()) {
            for (String p : this.allProfiles) {
                if (loadedProfiles.contains(p)) continue;
                loadedProfiles.add(p);
                for (String l : this.cfgFileLocations) {
                    if (l == null || l.isEmpty()) continue;
                    for (String n : this.cfgFileNames) {
                        this.loadPropertiesFile(p, l, n);
                    }
                }
            }
        }
        if (Utils.isNotEmpty((String)System.getProperty(PROP_ACTIVE))) {
            this.activeProfiles.clear();
            this.activeProfiles.addAll(Arrays.asList(System.getProperty(PROP_ACTIVE).split(",")));
        }
        if (!this.profileSources.isEmpty()) {
            this.finalAttrs.putAll(this.profileSources.get(null));
        }
        for (String p : this.activeProfiles) {
            if (!this.profileSources.containsKey(p)) continue;
            this.finalAttrs.putAll(this.profileSources.get(p));
        }
        this.finalAttrs.put(PROP_ACTIVE, this.activeProfiles.stream().collect(Collectors.joining(",")));
        this.parseValue(this.finalAttrs, new AtomicInteger(0));
        Log.init(() -> this.initLog());
        this.log.debug("final attrs: {}", new Object[]{this.finalAttrs});
        this.log.trace("System attrs: {}", new Object[]{System.getProperties()});
        this.log.info("The following profiles are active: {}", new Object[]{this.finalAttrs.get(PROP_ACTIVE)});
        this.ep.fire("env.configured", EC.of((Object)this));
    }

    protected void initLog() {
        ILoggerFactory fa = LoggerFactory.getILoggerFactory();
        if ("ch.qos.logback.classic.LoggerContext".equals(fa.getClass().getName())) {
            try {
                System.setProperty("PID", Utils.getPid());
                String logPath = this.getAttr("log.path");
                if (Utils.isNotEmpty((String)logPath)) {
                    System.setProperty("LOG_PATH", logPath);
                }
                Object o = Class.forName("ch.qos.logback.classic.joran.JoranConfigurator").newInstance();
                Method m = Utils.findMethod(o.getClass(), (String)"setContext", (Class[])new Class[]{Class.forName("ch.qos.logback.core.Context")});
                m.invoke(o, fa);
                m = Utils.findMethod(fa.getClass(), (String)"reset", (Class[])new Class[0]);
                m.invoke((Object)fa, new Object[0]);
                m = Utils.findMethod(o.getClass(), (String)"doConfigure", (Class[])new Class[]{InputStream.class});
                boolean f = false;
                for (String p : this.activeProfiles) {
                    String fName = "logback-" + p + ".xml";
                    InputStream in = this.getClass().getClassLoader().getResourceAsStream(fName);
                    if (in == null) continue;
                    this.log.info("Configure logback file: {}", new Object[]{fName});
                    m.invoke(o, in);
                    f = true;
                }
                if (!f) {
                    String fName = "logback.xml";
                    InputStream in = this.getClass().getClassLoader().getResourceAsStream(fName);
                    if (in != null) {
                        this.log.info("Configure logback file: {}", new Object[]{fName});
                        m.invoke(o, in);
                    }
                }
                Method setLevel = Utils.findMethod(Class.forName("ch.qos.logback.classic.Logger"), (String)"setLevel", (Class[])new Class[]{Class.forName("ch.qos.logback.classic.Level")});
                Method toLevel = Utils.findMethod(Class.forName("ch.qos.logback.classic.Level"), (String)"toLevel", (Class[])new Class[]{String.class});
                for (Map.Entry<String, String> e : this.groupAttr("log.level").entrySet()) {
                    setLevel.invoke((Object)fa.getLogger(e.getKey()), toLevel.invoke(null, e.getValue()));
                }
            }
            catch (Exception e) {
                this.log.error((Throwable)e);
            }
        }
    }

    protected void loadPropertiesFile(String profile, String cfgFileLocation, String cfgFileName) {
        Properties p;
        Throwable throwable;
        InputStream in;
        String f = cfgFileLocation + cfgFileName + (profile == null ? "" : "-" + profile) + ".properties";
        LinkedHashMap<Object, Object> r = null;
        if (cfgFileLocation.startsWith("classpath:")) {
            try {
                in = this.getClass().getClassLoader().getResourceAsStream(f.replace("classpath:/", ""));
                throwable = null;
                try {
                    if (in != null) {
                        p = new Properties();
                        p.load(in);
                        r = new LinkedHashMap<Object, Object>(p);
                    }
                }
                catch (Throwable p2) {
                    throwable = p2;
                    throw p2;
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable p2) {
                                throwable.addSuppressed(p2);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Throwable)e, "load cfg file '{}' error", new Object[]{f});
            }
        } else {
            try {
                in = new URL(f).openStream();
                throwable = null;
                try {
                    p = new Properties();
                    p.load(in);
                    r = new LinkedHashMap<Object, Object>(p);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                this.log.trace("not found cfg file '{}'", new Object[]{f});
            }
            catch (Exception e) {
                this.log.error((Throwable)e, "load cfg file '{}' error", new Object[]{f});
            }
        }
        if (r == null) {
            return;
        }
        this.log.trace("load cfg file '{}'\n{}", new Object[]{f, r});
        this.locationSources.put(f, r);
        this.profileSources.computeIfAbsent(profile, s -> new LinkedHashMap()).putAll(r);
        if (r.containsKey(PROP_ACTIVE)) {
            this.activeProfiles.clear();
            for (String p3 : ((String)r.get(PROP_ACTIVE)).split(",")) {
                if (!Utils.isNotBlank((CharSequence[])new CharSequence[]{p3})) continue;
                this.activeProfiles.add(p3.trim());
            }
            this.allProfiles.addAll(this.activeProfiles);
        }
    }

    protected void parseValue(Map<String, String> attrs, AtomicInteger count) {
        if (count.get() >= 3) {
            return;
        }
        boolean f = false;
        count.getAndIncrement();
        for (Map.Entry<String, String> e : attrs.entrySet()) {
            Matcher m = this.p.matcher(e.getValue());
            if (!m.find()) continue;
            f = true;
            attrs.put(e.getKey(), e.getValue().replace(m.group(0), attrs.getOrDefault(m.group("attr"), "")));
        }
        if (f) {
            this.parseValue(attrs, count);
        }
    }

    public Integer getInteger(String key, Integer defaultValue) {
        return Utils.toInteger((Object)this.getAttr(key), (Integer)defaultValue);
    }

    public Long getLong(String key, Long defaultValue) {
        return Utils.toLong((Object)this.getAttr(key), (Long)defaultValue);
    }

    public String getString(String key, String defaultValue) {
        String v = this.getAttr(key);
        return v == null ? defaultValue : v;
    }

    public Boolean getBoolean(String name, Boolean defaultValue) {
        return Utils.toBoolean((Object)this.getAttr(name), (Boolean)defaultValue);
    }

    @EL(name={"env.getAttr"}, async=false)
    protected String getAttr(String key) {
        String v = this.runtimeAttrs.get(key);
        if (v == null) {
            v = System.getProperty(key);
        }
        if (v == null) {
            v = this.finalAttrs.get(key);
        }
        return v;
    }

    public Environment setAttr(String key, String value) {
        if (PROP_ACTIVE.equals(key)) {
            throw new RuntimeException("not allow change this property 'enet.profile.active'");
        }
        this.ep.fire("env.updateAttr", EC.of((Object)this).args(new Object[]{key, value}).completeFn(ec -> {
            if (ec.isSuccess()) {
                this.runtimeAttrs.put(key, value);
            }
        }));
        return this;
    }

    @EL(name={"env.ns"}, async=false)
    public Map<String, String> groupAttr(String ... keys) {
        HashMap<String, String> group = new HashMap<String, String>();
        if (keys == null || keys.length < 1) {
            return group;
        }
        BiConsumer<String, String> fn = (k, v) -> {
            for (String key : keys) {
                if (!k.startsWith(key)) continue;
                if (k.equals(key)) {
                    group.put((String)k, (String)v);
                    continue;
                }
                group.put(k.substring(key.length() + 1), (String)v);
            }
        };
        this.finalAttrs.forEach(fn);
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> fn.accept(k.toString(), Objects.toString(v, null))));
        this.runtimeAttrs.forEach(fn);
        return group;
    }

    public Map<String, String> getFinalAttrs() {
        return new HashMap<String, String>(this.finalAttrs);
    }

    public Map<String, Map<String, String>> getLocationSources() {
        return new LinkedHashMap<String, Map<String, String>>(this.locationSources);
    }
}

