/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.enet.core;

import cn.xnatural.enet.common.Log;
import cn.xnatural.enet.common.Utils;
import cn.xnatural.enet.core.Environment;
import cn.xnatural.enet.event.EC;
import cn.xnatural.enet.event.EL;
import cn.xnatural.enet.event.EP;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.Resource;

public class AppContext {
    protected Log log = Log.of(AppContext.class);
    protected String name;
    protected ThreadPoolExecutor exec;
    protected EP ep;
    protected Environment env;
    protected Map<String, Object> sourceMap = new HashMap<String, Object>();
    protected final Date startup = new Date();
    protected Thread shutdownHook = new Thread(() -> this.stop());

    public void start() {
        this.log.info("Starting Application on {} with PID {}", new Object[]{Utils.getHostname(), Utils.getPid()});
        if (this.exec == null) {
            this.initExecutor();
        }
        this.ep = this.initEp();
        this.ep.addListenerSource((Object)this);
        this.sourceMap.forEach((k, v) -> {
            this.inject(v);
            this.ep.addListenerSource(v);
        });
        this.env = new Environment(this.ep);
        this.env.loadCfg();
        this.ep.fire("sys.starting", EC.of((Object)this), ec -> {
            if (this.shutdownHook != null) {
                Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            }
            this.autoInject();
            this.log.info("Started Application in {} seconds (JVM running for {})", new Object[]{(double)(System.currentTimeMillis() - this.startup.getTime()) / 1000.0, (double)ManagementFactory.getRuntimeMXBean().getUptime() / 1000.0});
            this.ep.fire("sys.started", EC.of((Object)this));
        });
    }

    public void stop() {
        this.ep.fire("sys.stopping", EC.of((Object)this), ce -> {
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            this.exec.shutdown();
        });
    }

    @EL(name={"sys.addSource"}, async=false)
    public void addSource(Object source) {
        String name;
        if (source == null || source instanceof Class) {
            return;
        }
        Method m = Utils.findMethod(source.getClass(), mm -> Modifier.isPublic(mm.getModifiers()) && "getName".equals(mm.getName()) && mm.getParameterCount() == 0 && String.class.equals(mm.getReturnType()));
        if (m == null) {
            name = source.getClass().getSimpleName().replace("$$EnhancerByCGLIB$$", "@");
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
        } else {
            name = (String)Utils.invoke((Method)m, (Object)source, (Object[])new Object[0]);
        }
        if (Utils.isEmpty((String)name)) {
            this.log.warn("Get name property is empty from '{}'", new Object[]{source});
            return;
        }
        if ("sys".equalsIgnoreCase(name) || "env".equalsIgnoreCase(name) || "log".equalsIgnoreCase(name)) {
            this.log.warn("Name property cannot equal 'sys', 'env' or 'log' . source: {}", new Object[]{source});
            return;
        }
        if (this.sourceMap.containsKey(name)) {
            this.log.warn("Name property '{}' already exist in source: {}", new Object[]{name, this.sourceMap.get(name)});
            return;
        }
        this.sourceMap.put(name, source);
        if (this.ep != null) {
            this.inject(source);
            this.ep.addListenerSource(source);
        }
    }

    protected void autoInject() {
        this.log.debug("Auto inject @Resource field", new Object[0]);
        this.sourceMap.forEach((s, o) -> this.inject(o));
    }

    @EL(name={"inject"}, async=false)
    protected void inject(Object o) {
        Utils.iterateField(o.getClass(), (Consumer[])new Consumer[]{f -> {
            Resource r = f.getAnnotation(Resource.class);
            if (r == null) {
                return;
            }
            try {
                f.setAccessible(true);
                Object v = f.get(o);
                if (v != null) {
                    return;
                }
                v = EP.class.isAssignableFrom(f.getType()) ? this.wrapEpForSource(o) : (Executor.class.isAssignableFrom(f.getType()) ? this.wrapExecForSource(o) : (Environment.class.isAssignableFrom(f.getType()) ? this.env : (AppContext.class.isAssignableFrom(f.getType()) ? this : this.ep.fire("bean.get", EC.of((Object)this).sync().args(new Object[]{f.getType(), r.name()})))));
                if (v == null) {
                    return;
                }
                f.set(o, v);
                this.log.trace("Inject @Resource field '{}' for object '{}'", new Object[]{f.getName(), o});
            }
            catch (Exception e) {
                this.log.error((Throwable)e);
            }
        }});
    }

    @EL(name={"bean.get", "sys.bean.get"}, async=false, order=1.0f)
    protected Object findLocalBean(EC ec, Class beanType, String beanName) {
        Object bean;
        block6: {
            block5: {
                if (ec.result != null) {
                    return ec.result;
                }
                bean = null;
                if (!Utils.isNotEmpty((String)beanName) || beanType == null) break block5;
                bean = this.sourceMap.get(beanName);
                if (bean == null || beanType.isAssignableFrom(bean.getClass())) break block6;
                bean = null;
                break block6;
            }
            if (Utils.isNotEmpty((String)beanName) && beanType == null) {
                bean = this.sourceMap.get(beanName);
            } else if (Utils.isEmpty((String)beanName) && beanType != null) {
                for (Map.Entry<String, Object> entry : this.sourceMap.entrySet()) {
                    if (!beanType.isAssignableFrom(entry.getValue().getClass())) continue;
                    bean = entry.getValue();
                    break;
                }
            }
        }
        return bean;
    }

    protected EP initEp() {
        return new EP(this.exec){

            protected Object doPublish(String eName, EC ec, Consumer<EC> completeFn) {
                if (("sys.starting".equals(eName) || "sys.stopping".equals(eName) || "sys.started".equals(eName)) && ec.source() != AppContext.this) {
                    throw new UnsupportedOperationException("not allow fire event '" + eName + "'");
                }
                if ("env.updateAttr".equals(eName) && ec.source() != AppContext.this.env) {
                    throw new UnsupportedOperationException("not allow fire event '" + eName + "'");
                }
                return super.doPublish(eName, ec, completeFn);
            }

            public String toString() {
                return "coreEp";
            }
        };
    }

    protected void initExecutor() {
        this.exec = new ThreadPoolExecutor(4, 8, 60L, TimeUnit.MINUTES, new LinkedBlockingQueue(), new ThreadFactory(){
            final AtomicInteger i = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "sys-" + this.i.getAndIncrement());
            }
        }){

            @Override
            public void execute(Runnable fn) {
                try {
                    super.execute(fn);
                }
                catch (RejectedExecutionException ex) {
                    AppContext.this.log.warn("Thread pool rejected new task very heavy load. {}", new Object[]{this});
                }
                catch (Throwable t) {
                    AppContext.this.log.error("Task happen unknown error", new Object[]{t});
                }
            }
        };
        this.exec.allowCoreThreadTimeOut(true);
    }

    @EL(name={"env.configured"})
    protected void envConfigured() {
        Long k;
        Integer m;
        Integer c = this.env.getInteger("sys.exec.corePoolSize", null);
        if (c != null) {
            this.exec.setCorePoolSize(c);
        }
        if ((m = this.env.getInteger("sys.exec.maximumPoolSize", null)) != null) {
            this.exec.setMaximumPoolSize(m);
        }
        if (this.exec.getCorePoolSize() > this.exec.getMaximumPoolSize()) {
            this.exec.setMaximumPoolSize(this.exec.getCorePoolSize());
        }
        if ((k = this.env.getLong("sys.exec.keepAliveTime", null)) != null) {
            this.exec.setKeepAliveTime(k, TimeUnit.SECONDS);
        }
        this.ep.addTrackEvent(this.env.getString("ep.track", "").split(","));
    }

    @EL(name={"env.updateAttr"})
    protected void updateAttr(String k, String v) {
        if (k.startsWith("sys.exec")) {
            if ("sys.exec.corePoolSize".equals(k)) {
                Integer i = Utils.toInteger((Object)v, null);
                if (i == null) {
                    throw new IllegalArgumentException("sys.exec.corePoolSize\u5c5e\u6027\u503c\u53ea\u80fd\u662f\u6574\u6570");
                }
                this.exec.setCorePoolSize(i);
            } else if ("sys.exec.maximumPoolSize".equals(k)) {
                Integer i = Utils.toInteger((Object)v, null);
                if (i == null) {
                    throw new IllegalArgumentException("sys.exec.maximumPoolSize\u5c5e\u6027\u503c\u53ea\u80fd\u662f\u6574\u6570");
                }
                this.exec.setCorePoolSize(i);
            } else if ("sys.exec.keepAliveTime".equals(k)) {
                Long l = Utils.toLong((Object)v, null);
                if (l == null) {
                    throw new IllegalArgumentException("sys.exec.keepAliveTime\u5c5e\u6027\u503c\u53ea\u80fd\u662f\u6574\u6570");
                }
                this.exec.setKeepAliveTime(l, TimeUnit.SECONDS);
            } else {
                this.log.warn("Not allow change property '{}'", new Object[]{k});
            }
        }
    }

    @EL(name={"sys.info"})
    protected Object info() {
        HashMap<String, TreeSet<String>> info = new HashMap<String, TreeSet<String>>();
        info.put("modules", new TreeSet<String>(this.sourceMap.keySet()));
        return info;
    }

    protected Executor wrapExecForSource(Object source) {
        return new Executor(){

            @Override
            public void execute(Runnable cmd) {
                AppContext.this.exec.execute(cmd);
            }

            public int getCorePoolSize() {
                return AppContext.this.exec.getCorePoolSize();
            }
        };
    }

    protected EP wrapEpForSource(final Object source) {
        return new EP(){

            protected void init(Executor exec) {
            }

            public Object fire(String eName, EC ec, Consumer<EC> completeFn) {
                if (ec.source() == null) {
                    ec.source(source);
                }
                return AppContext.this.ep.fire(eName, ec, completeFn);
            }

            public EP addListenerSource(Object source2) {
                AppContext.this.ep.addListenerSource(source2);
                return this;
            }

            public String toString() {
                return "wrappedCoreEp:" + source.getClass().getSimpleName();
            }
        };
    }

    public Environment env() {
        return this.env;
    }

    public String getName() {
        return this.name;
    }

    public AppContext setName(String name) {
        if (this.exec != null) {
            throw new RuntimeException("Application is running, not allow change");
        }
        this.name = name;
        return this;
    }
}

